/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gnu.trove.THash;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.io.Serializable;
import java.util.Arrays;

public abstract class TObjectHash
extends THash
implements Serializable,
TObjectHashingStrategy {
    private transient CachePerfStats cacheStats;
    protected transient Object[] _set;
    protected TObjectHashingStrategy _hashingStrategy;
    protected static final Object REMOVED = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TObjectHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public void setCachePerfStats(CachePerfStats stats) {
        this.cacheStats = stats;
    }

    @Override
    public Object clone() {
        TObjectHash h = (TObjectHash)super.clone();
        h._set = (Object[])this._set.clone();
        return h;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index2) {
        super.removeAt(index2);
        this._set[index2] = REMOVED;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        return capacity;
    }

    public boolean forEach(TObjectProcedure procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected int index(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index2 = hash % length;
        Object cur = set[index2];
        if (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            long start = -1L;
            if (this.cacheStats != null) {
                TObjectHash tObjectHash = this;
                start = tObjectHash.cacheStats.getStatTime();
            }
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while ((cur = set[index2]) != null && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
            if (this.cacheStats != null) {
                this.cacheStats.endQueryResultsHashCollisionProbe(start);
            }
        }
        return cur == null ? -1 : index2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertionIndex(Object obj) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index2 = hash % length;
        Object cur = set[index2];
        if (cur == null) {
            return index2;
        }
        if (this._hashingStrategy.equals(cur, obj)) {
            return -index2 - 1;
        }
        long start = -1L;
        if (this.cacheStats != null) {
            TObjectHash tObjectHash = this;
            start = tObjectHash.cacheStats.getStatTime();
            this.cacheStats.incQueryResultsHashCollisions();
        }
        try {
            int probe = 1 + hash % (length - 2);
            if (cur != REMOVED) {
                do {
                    if ((index2 -= probe) >= 0) continue;
                    index2 += length;
                } while ((cur = set[index2]) != null && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
            }
            if (cur == REMOVED) {
                int firstRemoved = index2;
                while (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                    if ((index2 -= probe) < 0) {
                        index2 += length;
                    }
                    cur = set[index2];
                }
                int n = cur != null && cur != REMOVED ? -index2 - 1 : firstRemoved;
                return n;
            }
            int n = cur != null && cur != REMOVED ? -index2 - 1 : index2;
            return n;
        }
        finally {
            if (this.cacheStats != null) {
                this.cacheStats.endQueryResultsHashCollisionProbe(start);
            }
        }
    }

    @Override
    public final int computeHashCode(Object o) {
        return o.hashCode();
    }

    @Override
    public final boolean equals(Object o1, Object o2) {
        return o1.equals(o2);
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + TObjectHash.objToString(o1) + "; object #2 =" + TObjectHash.objToString(o2));
    }

    private static String objToString(Object o) {
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        return String.valueOf(o);
    }
}

