/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.SerializationProcedure;
import com.gemstone.gnu.trove.TIntFunction;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TObjectHash;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectIntIterator;
import com.gemstone.gnu.trove.TObjectIntProcedure;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TObjectIntHashMap
extends TObjectHash
implements Serializable {
    private static final long serialVersionUID = 309134146652813984L;
    protected transient int[] _values;

    public TObjectIntHashMap() {
    }

    public TObjectIntHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TObjectIntHashMap(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public TObjectIntHashMap(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TObjectIntHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TObjectIntIterator iterator() {
        return new TObjectIntIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new int[capacity];
        return capacity;
    }

    public int put(Object key2, int value2) {
        int previous = 0;
        int index2 = this.insertionIndex(key2);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        Object oldKey = this._set[index2];
        this._set[index2] = key2;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        int[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new int[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public int get(Object key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? 0 : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        int[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = 0;
        }
    }

    public int remove(Object key2) {
        int prev = 0;
        int index2 = this.index(key2);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TObjectIntHashMap)) {
            return false;
        }
        TObjectIntHashMap that = (TObjectIntHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        return 0;
    }

    @Override
    protected void removeAt(int index2) {
        super.removeAt(index2);
        this._values[index2] = 0;
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        Object[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public Object[] keys() {
        Object[] keys = new Object[this.size()];
        Object[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == null || k[i] == REMOVED) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(int val) {
        Object[] keys = this._set;
        int[] vals = this._values;
        int i = vals.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || val != vals[i]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Object key2) {
        return this.contains(key2);
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TIntProcedure procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectIntProcedure procedure) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectIntProcedure procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        int[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TIntFunction function) {
        Object[] keys = this._set;
        int[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    public boolean increment(Object key2) {
        return this.adjustValue(key2, 1);
    }

    public boolean adjustValue(Object key2, int amount) {
        int index2 = this.index(key2);
        if (index2 < 0) {
            return false;
        }
        int n = index2;
        this._values[n] = this._values[n] + amount;
        return true;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object key2 = stream.readObject();
            int val = stream.readInt();
            this.put(key2, val);
        }
    }

    private static final class EqProcedure
    implements TObjectIntProcedure {
        private final TObjectIntHashMap _otherMap;

        EqProcedure(TObjectIntHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(Object key2, int value2) {
            int index2 = this._otherMap.index(key2);
            return index2 >= 0 && this.eq(value2, this._otherMap.get(key2));
        }

        private final boolean eq(int v1, int v2) {
            return v1 == v2;
        }
    }
}

