/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.TIterator;
import com.gemstone.gnu.trove.TObjectHash;
import com.gemstone.gnu.trove.TObjectLongHashMap;
import java.util.ConcurrentModificationException;

public class TObjectLongIterator
extends TIterator {
    private final TObjectLongHashMap _map;

    public TObjectLongIterator(TObjectLongHashMap map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public long value() {
        return this._map._values[this._index];
    }

    public long setValue(long val) {
        long old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

