/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TStatelessPrimitiveHash;
import java.util.Arrays;

public abstract class TStatelessIntHash
extends TStatelessPrimitiveHash
implements TIntHashingStrategy {
    protected transient int[] _set;
    protected int _FREE;
    protected TIntHashingStrategy _hashingStrategy;

    public TStatelessIntHash(int freeValue) {
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessIntHash(int freeValue, int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessIntHash(int freeValue, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessIntHash(int freeValue, TIntHashingStrategy strategy) {
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public TStatelessIntHash(int freeValue, int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public TStatelessIntHash(int freeValue, int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public int getFreeValue() {
        return this._FREE;
    }

    @Override
    public Object clone() {
        TStatelessIntHash h = (TStatelessIntHash)super.clone();
        h._set = (int[])this._set.clone();
        h._FREE = this._FREE;
        return h;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        if (this._FREE != 0) {
            Arrays.fill(this._set, this._FREE);
        }
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        int[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == this._FREE || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected int index(int val) {
        if (val == this._FREE) {
            return -1;
        }
        int[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (set[index2] != this._FREE && set[index2] != val) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (set[index2] != this._FREE && set[index2] != val);
        }
        return set[index2] == this._FREE ? -1 : index2;
    }

    protected int insertionIndex(int val) {
        if (val == this._FREE) {
            throw new IllegalArgumentException("can not add the value " + val);
        }
        int[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (set[index2] == this._FREE) {
            return index2;
        }
        if (set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (set[index2] != this._FREE && set[index2] != val);
        return set[index2] != this._FREE ? -index2 - 1 : index2;
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

