/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntObjectProcedure;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TObjectFunction;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.gemstone.gnu.trove.TStatelessIntHash;
import com.gemstone.gnu.trove.TStatelessIntObjectIterator;
import java.util.Arrays;

public class TStatelessIntObjectHashMap
extends TStatelessIntHash {
    protected transient Object[] _values;

    public TStatelessIntObjectHashMap(int freeValue) {
        super(freeValue);
    }

    public TStatelessIntObjectHashMap(int freeValue, int initialCapacity) {
        super(freeValue, initialCapacity);
    }

    public TStatelessIntObjectHashMap(int freeValue, int initialCapacity, float loadFactor) {
        super(freeValue, initialCapacity, loadFactor);
    }

    public TStatelessIntObjectHashMap(int freeValue, TIntHashingStrategy strategy) {
        super(freeValue, strategy);
    }

    public TStatelessIntObjectHashMap(int freeValue, int initialCapacity, TIntHashingStrategy strategy) {
        super(freeValue, initialCapacity, strategy);
    }

    public TStatelessIntObjectHashMap(int freeValue, int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(freeValue, initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TStatelessIntObjectHashMap m = (TStatelessIntObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    public TStatelessIntObjectIterator iterator() {
        return new TStatelessIntObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(int key2, Object value2) {
        Object previous = null;
        int index2 = this.insertionIndex(key2);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        int previousKey = this._set[index2];
        this._set[index2] = key2;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousKey == this._FREE);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new int[newCapacity];
        if (this._FREE != 0) {
            Arrays.fill(this._set, this._FREE);
        }
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == this._FREE) continue;
            int o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public Object get(int key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? null : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        int[] keys = this._set;
        Object[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = this._FREE;
            vals[i] = null;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TStatelessIntObjectHashMap)) {
            return false;
        }
        TStatelessIntObjectHashMap that = (TStatelessIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] v = this._values;
        int[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == this._FREE) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == this._FREE) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(Object val) {
        int[] keys = this._set;
        Object[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (keys[i] == this._FREE || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (keys[i] == this._FREE || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key2) {
        return this.contains(key2);
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        int[] keys = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == this._FREE || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure procedure) {
        int[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == this._FREE || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction function) {
        int[] keys = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (this._set[i] == this._FREE) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private static final class EqProcedure
    implements TIntObjectProcedure {
        private final TStatelessIntObjectHashMap _otherMap;

        EqProcedure(TStatelessIntObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(int key2, Object value2) {
            int index2 = this._otherMap.index(key2);
            return index2 >= 0 && this.eq(value2, this._otherMap.get(key2));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    protected final class HashProcedure
    implements TIntObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key2, Object value2) {
            this.h += TStatelessIntObjectHashMap.this._hashingStrategy.computeHashCode(key2) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

