/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.TLongHashingStrategy;
import com.gemstone.gnu.trove.TLongProcedure;
import com.gemstone.gnu.trove.TStatelessPrimitiveHash;
import java.util.Arrays;

public abstract class TStatelessLongHash
extends TStatelessPrimitiveHash
implements TLongHashingStrategy {
    protected transient long[] _set;
    protected long _FREE;
    protected TLongHashingStrategy _hashingStrategy;

    public TStatelessLongHash(long freeValue) {
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessLongHash(long freeValue, int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessLongHash(long freeValue, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
        this._FREE = freeValue;
    }

    public TStatelessLongHash(long freeValue, TLongHashingStrategy strategy) {
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public TStatelessLongHash(long freeValue, int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public TStatelessLongHash(long freeValue, int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
        this._FREE = freeValue;
    }

    public long getFreeValue() {
        return this._FREE;
    }

    @Override
    public Object clone() {
        TStatelessLongHash h = (TStatelessLongHash)super.clone();
        h._set = (long[])this._set.clone();
        h._FREE = this._FREE;
        return h;
    }

    @Override
    protected int capacity() {
        return this._set.length;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new long[capacity];
        if (this._FREE != 0L) {
            Arrays.fill(this._set, this._FREE);
        }
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        long[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == this._FREE || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected int index(long val) {
        if (val == this._FREE) {
            return -1;
        }
        long[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (set[index2] != this._FREE && set[index2] != val) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index2 -= probe) >= 0) continue;
                index2 += length;
            } while (set[index2] != this._FREE && set[index2] != val);
        }
        return set[index2] == this._FREE ? -1 : index2;
    }

    protected int insertionIndex(long val) {
        if (val == this._FREE) {
            throw new IllegalArgumentException("can not add the value " + val);
        }
        long[] set = this._set;
        int length = set.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index2 = hash % length;
        if (set[index2] == this._FREE) {
            return index2;
        }
        if (set[index2] == val) {
            return -index2 - 1;
        }
        int probe = 1 + hash % (length - 2);
        do {
            if ((index2 -= probe) >= 0) continue;
            index2 += length;
        } while (set[index2] != this._FREE && set[index2] != val);
        return set[index2] != this._FREE ? -index2 - 1 : index2;
    }

    @Override
    public final int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }
}

