/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.TLongHashingStrategy;
import com.gemstone.gnu.trove.TLongProcedure;
import com.gemstone.gnu.trove.TStatelessLongHash;
import com.gemstone.gnu.trove.TStatelessLongIterator;
import java.util.Arrays;

public class TStatelessLongHashSet
extends TStatelessLongHash {
    public TStatelessLongHashSet(long freeValue) {
        super(freeValue);
    }

    public TStatelessLongHashSet(long freeValue, int initialCapacity) {
        super(freeValue, initialCapacity);
    }

    public TStatelessLongHashSet(long freeValue, int initialCapacity, float loadFactor) {
        super(freeValue, initialCapacity, loadFactor);
    }

    public TStatelessLongHashSet(long freeValue, long[] array) {
        this(freeValue, array.length);
        this.addAll(array);
    }

    public TStatelessLongHashSet(long freeValue, TLongHashingStrategy strategy) {
        super(freeValue, strategy);
    }

    public TStatelessLongHashSet(long freeValue, int initialCapacity, TLongHashingStrategy strategy) {
        super(freeValue, initialCapacity, strategy);
    }

    public TStatelessLongHashSet(long freeValue, int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(freeValue, initialCapacity, loadFactor, strategy);
    }

    public TStatelessLongHashSet(long freeValue, long[] array, TLongHashingStrategy strategy) {
        this(freeValue, array.length, strategy);
        this.addAll(array);
    }

    public TStatelessLongIterator iterator() {
        return new TStatelessLongIterator(this);
    }

    public boolean add(long val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        long previousState = this._set[index2];
        this._set[index2] = val;
        this.postInsertHook(previousState == this._FREE);
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldSet = this._set;
        this._set = new long[newCapacity];
        if (this._FREE != 0L) {
            Arrays.fill(this._set, this._FREE);
        }
        int i = oldCapacity;
        while (i-- > 0) {
            long o = oldSet[i];
            if (o == this._FREE) continue;
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
        }
    }

    public long[] toArray() {
        long[] result = new long[this.size()];
        long[] set = this._set;
        int i = set.length;
        int j = 0;
        while (i-- > 0) {
            long o = set[i];
            if (o == this._FREE) continue;
            result[j++] = o;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this._set, this._FREE);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TStatelessLongHashSet)) {
            return false;
        }
        final TStatelessLongHashSet that = (TStatelessLongHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TLongProcedure(){

            @Override
            public final boolean execute(long value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean containsAll(long[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(long[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    protected final class HashProcedure
    implements TLongProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(long key2) {
            this.h += TStatelessLongHashSet.this._hashingStrategy.computeHashCode(key2);
            return true;
        }
    }
}

