/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.TLongHashingStrategy;
import com.gemstone.gnu.trove.TLongObjectProcedure;
import com.gemstone.gnu.trove.TLongProcedure;
import com.gemstone.gnu.trove.TObjectFunction;
import com.gemstone.gnu.trove.TObjectProcedure;
import com.gemstone.gnu.trove.TStatelessLongHash;
import com.gemstone.gnu.trove.TStatelessLongObjectIterator;
import java.util.Arrays;

public class TStatelessLongObjectHashMap
extends TStatelessLongHash {
    protected transient Object[] _values;

    public TStatelessLongObjectHashMap(long freeValue) {
        super(freeValue);
    }

    public TStatelessLongObjectHashMap(long freeValue, int initialCapacity) {
        super(freeValue, initialCapacity);
    }

    public TStatelessLongObjectHashMap(long freeValue, int initialCapacity, float loadFactor) {
        super(freeValue, initialCapacity, loadFactor);
    }

    public TStatelessLongObjectHashMap(long freeValue, TLongHashingStrategy strategy) {
        super(freeValue, strategy);
    }

    public TStatelessLongObjectHashMap(long freeValue, int initialCapacity, TLongHashingStrategy strategy) {
        super(freeValue, initialCapacity, strategy);
    }

    public TStatelessLongObjectHashMap(long freeValue, int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(freeValue, initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TStatelessLongObjectHashMap m = (TStatelessLongObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    public TStatelessLongObjectIterator iterator() {
        return new TStatelessLongObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(long key2, Object value2) {
        Object previous = null;
        int index2 = this.insertionIndex(key2);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        long previousKey = this._set[index2];
        this._set[index2] = key2;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousKey == this._FREE);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new long[newCapacity];
        if (this._FREE != 0L) {
            Arrays.fill(this._set, this._FREE);
        }
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == this._FREE) continue;
            long o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public Object get(long key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? null : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        long[] keys = this._set;
        Object[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = this._FREE;
            vals[i] = null;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TStatelessLongObjectHashMap)) {
            return false;
        }
        TStatelessLongObjectHashMap that = (TStatelessLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] v = this._values;
        long[] keys = this._set;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (keys[i] == this._FREE) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public long[] keys() {
        long[] keys = new long[this.size()];
        long[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == this._FREE) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(Object val) {
        long[] keys = this._set;
        Object[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (keys[i] == this._FREE || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (keys[i] == this._FREE || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key2) {
        return this.contains(key2);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        long[] keys = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (keys[i] == this._FREE || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongObjectProcedure procedure) {
        long[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == this._FREE || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public void transformValues(TObjectFunction function) {
        long[] keys = this._set;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (this._set[i] == this._FREE) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private static final class EqProcedure
    implements TLongObjectProcedure {
        private final TStatelessLongObjectHashMap _otherMap;

        EqProcedure(TStatelessLongObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(long key2, Object value2) {
            int index2 = this._otherMap.index(key2);
            return index2 >= 0 && this.eq(value2, this._otherMap.get(key2));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    protected final class HashProcedure
    implements TLongObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(long key2, Object value2) {
            this.h += TStatelessLongObjectHashMap.this._hashingStrategy.computeHashCode(key2) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

