/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.TIterator;
import com.gemstone.gnu.trove.TStatelessLongObjectHashMap;
import java.util.ConcurrentModificationException;

public class TStatelessLongObjectIterator
extends TIterator {
    private final TStatelessLongObjectHashMap _map;

    public TStatelessLongObjectIterator(TStatelessLongObjectHashMap map) {
        super(map);
        this._map = map;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public long key() {
        return this._map._set[this._index];
    }

    public Object value() {
        return this._map._values[this._index];
    }

    public Object setValue(Object val) {
        Object old = this.value();
        this._map._values[this._index] = val;
        return old;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        long[] keys = this._map._set;
        long FREE = this._map.getFreeValue();
        int i = this._index;
        while (i-- > 0 && keys[i] == FREE) {
        }
        return i;
    }
}

