/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.joptsimple;

import com.gemstone.joptsimple.AbstractOptionSpec;
import com.gemstone.joptsimple.ArgumentList;
import com.gemstone.joptsimple.OptionArgumentConversionException;
import com.gemstone.joptsimple.OptionException;
import com.gemstone.joptsimple.OptionParser;
import com.gemstone.joptsimple.OptionSet;
import com.gemstone.joptsimple.ValueConversionException;
import com.gemstone.joptsimple.ValueConverter;
import com.gemstone.joptsimple.internal.Objects;
import com.gemstone.joptsimple.internal.Reflection;
import com.gemstone.joptsimple.internal.ReflectionException;
import com.gemstone.joptsimple.internal.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class ArgumentAcceptingOptionSpec<V>
extends AbstractOptionSpec<V> {
    private static final char NIL_VALUE_SEPARATOR = '\u0000';
    private boolean optionRequired;
    private final boolean argumentRequired;
    private ValueConverter<V> converter;
    private String argumentDescription = "";
    private String valueSeparator = String.valueOf('\u0000');
    private final List<V> defaultValues = new ArrayList<V>();

    ArgumentAcceptingOptionSpec(String option, boolean argumentRequired) {
        super(option);
        this.argumentRequired = argumentRequired;
    }

    ArgumentAcceptingOptionSpec(Collection<String> options, boolean argumentRequired, String description) {
        super(options, description);
        this.argumentRequired = argumentRequired;
    }

    public final <T> ArgumentAcceptingOptionSpec<T> ofType(Class<T> argumentType) {
        return this.withValuesConvertedBy(Reflection.findConverter(argumentType));
    }

    public final <T> ArgumentAcceptingOptionSpec<T> withValuesConvertedBy(ValueConverter<T> aConverter) {
        if (aConverter == null) {
            throw new NullPointerException("illegal null converter");
        }
        this.converter = aConverter;
        return this;
    }

    public final ArgumentAcceptingOptionSpec<V> describedAs(String description) {
        this.argumentDescription = description;
        return this;
    }

    public final ArgumentAcceptingOptionSpec<V> withValuesSeparatedBy(char separator) {
        if (separator == '\u0000') {
            throw new IllegalArgumentException("cannot use U+0000 as separator");
        }
        this.valueSeparator = String.valueOf(separator);
        return this;
    }

    public final ArgumentAcceptingOptionSpec<V> withValuesSeparatedBy(String separator) {
        if (separator.indexOf(0) != -1) {
            throw new IllegalArgumentException("cannot use U+0000 in separator");
        }
        this.valueSeparator = separator;
        return this;
    }

    public ArgumentAcceptingOptionSpec<V> defaultsTo(V value2, V ... values) {
        this.addDefaultValue(value2);
        this.defaultsTo(values);
        return this;
    }

    public ArgumentAcceptingOptionSpec<V> defaultsTo(V[] values) {
        for (V each : values) {
            this.addDefaultValue(each);
        }
        return this;
    }

    public ArgumentAcceptingOptionSpec<V> required() {
        this.optionRequired = true;
        return this;
    }

    @Override
    public boolean isRequired() {
        return this.optionRequired;
    }

    private void addDefaultValue(V value2) {
        Objects.ensureNotNull(value2);
        this.defaultValues.add(value2);
    }

    @Override
    final void handleOption(OptionParser parser, ArgumentList arguments, OptionSet detectedOptions, String detectedArgument) {
        if (Strings.isNullOrEmpty(detectedArgument)) {
            this.detectOptionArgument(parser, arguments, detectedOptions);
        } else {
            this.addArguments(detectedOptions, detectedArgument);
        }
    }

    protected void addArguments(OptionSet detectedOptions, String detectedArgument) {
        StringTokenizer lexer = new StringTokenizer(detectedArgument, this.valueSeparator);
        if (!lexer.hasMoreTokens()) {
            detectedOptions.addWithArgument(this, detectedArgument);
        } else {
            while (lexer.hasMoreTokens()) {
                detectedOptions.addWithArgument(this, lexer.nextToken());
            }
        }
    }

    protected abstract void detectOptionArgument(OptionParser var1, ArgumentList var2, OptionSet var3);

    @Override
    protected final V convert(String argument) {
        if (this.converter == null) {
            return (V)argument;
        }
        try {
            return this.converter.convert(argument);
        }
        catch (ReflectionException ex) {
            throw new OptionArgumentConversionException(this.options(), argument, this.converter.valueType(), ex);
        }
        catch (ValueConversionException ex) {
            throw new OptionArgumentConversionException(this.options(), argument, this.converter.valueType(), ex);
        }
    }

    protected boolean canConvertArgument(String argument) {
        StringTokenizer lexer = new StringTokenizer(argument, this.valueSeparator);
        try {
            while (lexer.hasMoreTokens()) {
                this.convert(lexer.nextToken());
            }
            return true;
        }
        catch (OptionException ignored) {
            return false;
        }
    }

    protected boolean isArgumentOfNumberType() {
        return this.converter != null && Number.class.isAssignableFrom(this.converter.valueType());
    }

    @Override
    public boolean acceptsArguments() {
        return true;
    }

    @Override
    public boolean requiresArgument() {
        return this.argumentRequired;
    }

    @Override
    public String argumentDescription() {
        return this.argumentDescription;
    }

    @Override
    public String argumentTypeIndicator() {
        if (this.converter == null) {
            return null;
        }
        String pattern = this.converter.valuePattern();
        return pattern == null ? this.converter.valueType().getName() : pattern;
    }

    public List<V> defaultValues() {
        return Collections.unmodifiableList(this.defaultValues);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        ArgumentAcceptingOptionSpec other = (ArgumentAcceptingOptionSpec)that;
        return this.requiresArgument() == other.requiresArgument();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.argumentRequired ? 0 : 1);
    }
}

