/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.joptsimple;

import com.gemstone.joptsimple.OptionSet;
import com.gemstone.joptsimple.UnrecognizedOptionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class OptionException
extends RuntimeException {
    private static final long serialVersionUID = -1L;
    private OptionSet detected;
    private final List<String> options = new ArrayList<String>();

    protected OptionException(Collection<String> options) {
        this.options.addAll(options);
    }

    protected OptionException(Collection<String> options, Throwable cause) {
        super(cause);
        this.options.addAll(options);
    }

    protected OptionException(Collection<String> options, OptionSet detected) {
        this.options.addAll(options);
        this.detected = detected;
    }

    public Collection<String> options() {
        return Collections.unmodifiableCollection(this.options);
    }

    protected final String singleOptionMessage() {
        return this.singleOptionMessage(this.options.get(0));
    }

    protected final String singleOptionMessage(String option) {
        return "'" + option + "'";
    }

    protected final String multipleOptionMessage() {
        StringBuilder buffer = new StringBuilder("[");
        Iterator<String> iter = this.options.iterator();
        while (iter.hasNext()) {
            buffer.append(this.singleOptionMessage(iter.next()));
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    public static OptionException createUnrecognizedOptionException(String option, OptionSet detected) {
        return new UnrecognizedOptionException(option, detected);
    }

    public OptionSet getDetected() {
        return this.detected;
    }
}

