/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.membership.MembershipTestHook;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.BlockEvent;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.ExitEvent;
import com.gemstone.org.jgroups.GetStateEvent;
import com.gemstone.org.jgroups.MergeView;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SetStateEvent;
import com.gemstone.org.jgroups.SuspectEvent;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.conf.ConfiguratorFactory;
import com.gemstone.org.jgroups.conf.ProtocolStackConfigurator;
import com.gemstone.org.jgroups.protocols.pbcast.NAKACK;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.stack.StateTransferInfo;
import com.gemstone.org.jgroups.util.CondVar;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Util;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.w3c.dom.Element;

public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "UDP(mcast_addr=228.1.2.3;mcast_port=45566;ip_ttl=32):PING(timeout=3000;num_initial_members=6):FD(timeout=3000):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=10;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=10000):FRAG:pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";
    static final String FORCE_PROPS = "force.properties";
    private String props = null;
    protected Address local_addr = null;
    protected String channel_name = null;
    private View my_view = null;
    protected final Queue mq = new Queue();
    protected ProtocolStack prot_stack = null;
    protected CloserThread closer = null;
    private final Promise local_addr_promise = new Promise();
    protected final Promise connect_promise = new Promise();
    private final Promise state_promise = new Promise();
    private final Object suspend_mutex = new Object();
    private boolean suspended = false;
    private long LOCAL_ADDR_TIMEOUT = 30000L;
    private static final long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private boolean receive_views = true;
    private boolean receive_suspects = true;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean receive_get_states = false;
    protected boolean auto_reconnect = false;
    protected boolean auto_getstate = false;
    protected volatile boolean connected = false;
    private final CondVar block_sending = new CondVar("block_sending", Boolean.FALSE);
    private volatile boolean closed = false;
    private volatile boolean closing = false;
    protected volatile RuntimeException closeException = null;
    private boolean state_transfer_supported = false;
    protected byte[] additional_data = null;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;
    public Event exitEvent;
    MembershipTestHook channelTestHook;

    public JChannel() throws ChannelException {
    }

    public JChannel(File properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    protected JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
        this.props = configurator.getProtocolStackString();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Configuring JGroups stack with '" + this.props + "'");
        }
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw new ChannelException("unable to setup the protocol stack", e);
        }
    }

    @Deprecated
    public JChannel(Object properties) throws ChannelException {
        if (properties == null) {
            properties = DEFAULT_PROTOCOL_STACK;
        }
        try {
            ProtocolStackConfigurator c = ConfiguratorFactory.getStackConfigurator(properties);
            this.props = c.getProtocolStackString();
        }
        catch (Exception x) {
            throw new ChannelException("unable to load protocol stack", x);
        }
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw new ChannelException("failed to setup protocol stack", e);
        }
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    @Override
    protected GemFireTracer getLog() {
        return this.log;
    }

    public String getProperties() {
        return this.props;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    public long getSentMessages() {
        return this.sent_msgs;
    }

    public long getSentBytes() {
        return this.sent_bytes;
    }

    public long getReceivedMessages() {
        return this.received_msgs;
    }

    public long getReceivedBytes() {
        return this.received_bytes;
    }

    public int getNumberOfTasksInTimer() {
        return this.prot_stack != null ? this.prot_stack.timer.size() : -1;
    }

    public String dumpTimerQueue() {
        return this.prot_stack != null ? this.prot_stack.dumpTimerQueue() : "<n/a";
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    @Override
    public void connect(String channel_name) throws ChannelException, ChannelClosedException {
        this.exitEvent = null;
        this.checkClosed();
        if (this.connected) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.JChannel_ALREADY_CONNECTED_TO__0, channel_name);
            }
            return;
        }
        if (channel_name == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.JChannel_CHANNEL_NAME_IS_NULL_ASSUMING_UNICAST_CHANNEL);
            }
        } else {
            this.channel_name = channel_name;
        }
        try {
            this.prot_stack.startStack();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable e) {
            SystemFailure.checkFailure();
            throw new ChannelException("error connecting distribution channel", e);
        }
        try {
            this.LOCAL_ADDR_TIMEOUT = Long.parseLong(System.getProperty("local_addr.timeout", "30000"));
        }
        catch (SecurityException e1) {
            // empty catch block
        }
        this.local_addr = (Address)this.local_addr_promise.getResult(this.LOCAL_ADDR_TIMEOUT);
        if (this.local_addr == null) {
            this.log.fatal("local_addr is null; cannot connect");
            throw new ChannelException("local_addr is null");
        }
        Vector<Address> t = new Vector<Address>(1);
        t.addElement(this.local_addr);
        this.my_view = new View(this.local_addr, 0L, t);
        if (channel_name != null) {
            this.connect_promise.reset();
            Event connect_event = new Event(2, channel_name);
            this.down(connect_event);
            this.connect_promise.getResult();
        }
        if (!this.closing && !this.closed) {
            this.connected = true;
            if (this.channel_listener != null) {
                this.channel_listener.channelConnected(this);
            }
        } else {
            if (this.closeException != null) {
                throw this.closeException;
            }
            String s = "Failure during connect (closing = " + this.closing + ", closed = " + this.closed + ")";
            throw new ChannelException(s);
        }
        this.connected = true;
        this.notifyChannelConnected(this);
    }

    @Override
    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        this.resume();
        if (this.connected) {
            block5: {
                if (this.channel_name != null) {
                    Event disconnect_event = new Event(4, this.local_addr);
                    this.down(disconnect_event);
                }
                this.down(new Event(23));
                this.connected = false;
                try {
                    this.prot_stack.stopStack();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error("caught unexpected exception", (Throwable)e);
                }
            }
            this.notifyChannelDisconnected(this);
            this.init();
        }
    }

    @Override
    public synchronized void close() {
        this.closing = true;
        this._close(true, true);
        if (this.closer != null) {
            try {
                this.closer.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void closeAsync() {
        this.closing = true;
        this._close(true, true);
    }

    @Override
    public synchronized void shutdown() {
        this._close(false, true);
    }

    @Override
    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack = new ProtocolStack(this, this.props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("failed to open channel", e);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getNumMessages() {
        return this.mq != null ? this.mq.size() : -1;
    }

    @Override
    public String dumpQueue() {
        return Util.dumpQueue(this.mq);
    }

    @Override
    public Map dumpStats() {
        Map tmp;
        Map retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    private Map dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", this.sent_msgs);
        retval.put("sent_bytes", this.sent_bytes);
        retval.put("received_msgs", this.received_msgs);
        retval.put("received_bytes", this.received_bytes);
        return retval;
    }

    @Override
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        this.down(new Event(1, msg));
    }

    @Override
    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    @Override
    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            retval = JChannel.getEvent(evt);
            evt = null;
            if (this.stats && retval != null && retval instanceof Message) {
                ++this.received_msgs;
                this.received_bytes += (long)((Message)retval).getLength();
            }
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("caught unexpected exception", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        Object retval = null;
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            if (this.log.isErrorEnabled()) {
                this.log.error("caught unexpected exception", (Throwable)queue_closed);
            }
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error("caught unexpected exception", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    @Override
    public Address getLocalAddress() {
        return this.closed ? null : this.local_addr;
    }

    @Override
    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.channel_name);
    }

    @Override
    public void setOpt(int option, Object value2) {
        if (this.closed) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("channel is closed; option not set !");
            }
            return;
        }
        switch (option) {
            case 1: {
                if (value2 instanceof Boolean) {
                    this.receive_views = (Boolean)value2;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            case 2: {
                if (value2 instanceof Boolean) {
                    this.receive_suspects = (Boolean)value2;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            case 0: {
                if (value2 instanceof Boolean) {
                    this.receive_blocks = (Boolean)value2;
                } else if (this.log.isErrorEnabled()) {
                    this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                }
                if (!this.receive_blocks) break;
                this.receive_views = true;
                break;
            }
            case 4: {
                if (value2 instanceof Boolean) {
                    this.receive_get_states = (Boolean)value2;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            case 3: {
                if (value2 instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value2;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            case 5: {
                if (value2 instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value2;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            case 6: {
                if (value2 instanceof Boolean) {
                    this.auto_getstate = (Boolean)value2;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error("option " + Channel.option2String(option) + " (" + value2 + "): value has to be Boolean");
                break;
            }
            default: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error(JGroupsStrings.JChannel_OPTION__0__NOT_KNOWN, Channel.option2String(option));
            }
        }
    }

    @Override
    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return this.receive_views ? Boolean.TRUE : Boolean.FALSE;
            }
            case 0: {
                return this.receive_blocks ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return this.receive_suspects ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.receive_get_states ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.receive_local_msgs ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error(JGroupsStrings.JChannel_OPTION__0__NOT_KNOWN, Channel.option2String(option));
        }
        return null;
    }

    @Override
    public void blockOk() {
        this.down(new Event(11));
        this.down(new Event(22));
    }

    @Override
    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(1, target);
        info.timeout = timeout;
        return this._getState(new Event(19, info), timeout);
    }

    @Override
    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        StateTransferInfo info = new StateTransferInfo(2, targets);
        return this._getState(new Event(19, info), timeout);
    }

    @Override
    public void returnState(byte[] state) {
        this.down(new Event(18, state));
    }

    public void up(Event evt) {
        block33: {
            int type = evt.getType();
            switch (type) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                    return;
                }
                case 6: {
                    View tmp = (View)evt.getArg();
                    this.my_view = tmp instanceof MergeView ? new View(tmp.getVid(), tmp.getMembers()) : tmp;
                    if (!this.connected) {
                        this.connected = true;
                        this.connect_promise.setResult(Boolean.TRUE);
                    }
                    this.down(new Event(23));
                    if (this.receive_views) break;
                    return;
                }
                case 9: {
                    if (this.receive_suspects) break;
                    return;
                }
                case 17: {
                    if (this.receive_get_states) break;
                    this.down(new Event(18, null));
                    return;
                }
                case 56: {
                    HashMap config = (HashMap)evt.getArg();
                    if (config == null || !config.containsKey("state_transfer")) break;
                    this.state_transfer_supported = (Boolean)config.get("state_transfer");
                    break;
                }
                case 10: {
                    if (this.receive_blocks) break;
                    this.down(new Event(11));
                    this.down(new Event(22));
                    return;
                }
                case 3: {
                    this.connect_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 5: {
                    break;
                }
                case 20: {
                    Object state = evt.getArg();
                    this.state_promise.setResult(state);
                    if (this.up_handler != null) {
                        this.up_handler.up(evt);
                        return;
                    }
                    if (state == null) break;
                    if (this.receiver != null) {
                        this.receiver.setState((byte[])state);
                        break;
                    }
                    try {
                        this.mq.add(new Event(21, state));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 8: {
                    this.local_addr_promise.setResult(evt.getArg());
                    break;
                }
                case 46: {
                    this.exitEvent = evt;
                    this.handleExit(evt);
                    return;
                }
                case 54: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.JChannel_RECEIVED_BLOCK_SEND);
                    }
                    this.block_sending.set(Boolean.TRUE);
                    break;
                }
                case 55: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.JChannel_RECEIVED_UNBLOCK_SEND);
                    }
                    this.block_sending.set(Boolean.FALSE);
                    break;
                }
            }
            if (this.up_handler != null) {
                this.up_handler.up(evt);
                return;
            }
            switch (type) {
                case 1: {
                    if (this.receiver == null) break;
                    this.receiver.receive((Message)evt.getArg());
                    return;
                }
                case 6: {
                    if (this.receiver == null) break;
                    this.receiver.viewAccepted((View)evt.getArg());
                    return;
                }
                case 9: {
                    if (this.receiver == null) break;
                    this.receiver.suspect((SuspectMember)evt.getArg());
                    return;
                }
                case 17: {
                    if (this.receiver == null) break;
                    byte[] tmp_state = this.receiver.getState();
                    this.returnState(tmp_state);
                    return;
                }
                case 10: {
                    if (this.receiver == null) break;
                    this.receiver.block();
                    return;
                }
            }
            if (this.receiver != null && (type == 1 || type == 6 || type == 9 || type == 17 || type == 10)) {
                try {
                    this.mq.add(evt);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block33;
                    this.log.error("caught unexpected exception", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void down(Event evt) {
        block18: {
            int type;
            if (evt == null) {
                return;
            }
            if (this.suspended) {
                Object object = this.suspend_mutex;
                synchronized (object) {
                    while (this.suspended) {
                        boolean interrupted = Thread.interrupted();
                        try {
                            this.suspend_mutex.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (!interrupted) continue;
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            if ((type = evt.getType()) == 1 && this.block_sending.get().equals(Boolean.TRUE)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("down() blocks because block_sending == true");
                }
                this.block_sending.waitUntil(Boolean.FALSE);
            }
            if (type == 56) {
                try {
                    Map m = (Map)evt.getArg();
                    if (m != null && m.containsKey("additional_data")) {
                        this.additional_data = (byte[])m.get("additional_data");
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    if (!this.log.isErrorEnabled()) break block18;
                    this.log.error(JGroupsStrings.JChannel_CONFIG_EVENT_DID_NOT_CONTAIN_A_HASHMAP__0, t);
                }
            }
        }
        if (this.prot_stack != null) {
            this.prot_stack.down(evt);
            return;
        }
        if (!this.log.isErrorEnabled()) return;
        this.log.error(JGroupsStrings.JChannel_NO_PROTOCOL_STACK_AVAILABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.suspend_mutex;
        synchronized (object) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.suspend_mutex;
        synchronized (object) {
            this.suspended = false;
            this.suspend_mutex.notifyAll();
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("channel_name=").append(this.channel_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        if (this.mq != null) {
            sb.append("incoming queue size=").append(this.mq.size()).append('\n');
        }
        if (details) {
            sb.append("block_sending=").append(this.block_sending).append('\n');
            sb.append("receive_views=").append(this.receive_views).append('\n');
            sb.append("receive_suspects=").append(this.receive_suspects).append('\n');
            sb.append("receive_blocks=").append(this.receive_blocks).append('\n');
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append('\n');
            sb.append("receive_get_states=").append(this.receive_get_states).append('\n');
            sb.append("auto_reconnect=").append(this.auto_reconnect).append('\n');
            sb.append("auto_getstate=").append(this.auto_getstate).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.props).append('\n');
        }
        return sb.toString();
    }

    private void init() {
        this.local_addr = null;
        this.channel_name = null;
        this.my_view = null;
        this.connect_promise.reset();
        this.connected = false;
        this.block_sending.set(Boolean.FALSE);
    }

    private final void checkNotConnected() throws ChannelNotConnectedException {
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    private final void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            ChannelClosedException ex = new ChannelClosedException();
            if (this.closeException != null) {
                ex.initCause(this.closeException);
            }
            throw ex;
        }
    }

    static Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent((SuspectMember)evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 17: {
                return new GetStateEvent(evt.getArg());
            }
            case 21: {
                return new SetStateEvent((byte[])evt.getArg());
            }
            case 46: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    public void installGemFireStats(JGroupMembershipManager jgmm, DMStats stats, boolean enableClockStats, boolean enableJgStackStats) {
        this.prot_stack.gemfireStats = stats;
        this.prot_stack.jgmm = jgmm;
        this.prot_stack.enableClockStats = enableClockStats;
        this.prot_stack.enableJgStackStats = enableJgStackStats;
    }

    boolean _getState(Event evt, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (!this.state_transfer_supported) {
            this.log.error("fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol configuration");
            return false;
        }
        this.state_promise.reset();
        this.down(evt);
        byte[] state = (byte[])this.state_promise.getResult(timeout);
        return state != null;
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        block11: {
            block10: {
                if (this.closed) {
                    return;
                }
                if (!disconnect) {
                    this.resume();
                }
                if (disconnect) {
                    this.disconnect();
                }
                if (close_mq) {
                    try {
                        if (this.mq != null) {
                            this.mq.close(false);
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block10;
                        this.log.error("caught unexpected exception", (Throwable)e);
                    }
                }
            }
            if (this.prot_stack != null) {
                try {
                    this.prot_stack.stopStack();
                    this.prot_stack.destroy();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error("caught unexpected exception", (Throwable)e);
                }
            }
        }
        this.closed = true;
        this.closing = false;
        this.connected = false;
        this.notifyChannelClosed(this);
        this.init();
    }

    public Exception getCloseException() {
        return this.closeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExit(Event evt) {
        this.closing = true;
        if (evt.getArg() instanceof RuntimeException) {
            this.closeException = (RuntimeException)evt.getArg();
        }
        this.notifyChannelShunned();
        JChannel jChannel = this;
        synchronized (jChannel) {
            if (this.closer != null && !this.closer.isAlive()) {
                this.closer = null;
            }
            if (this.closer == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.JChannel_RECEIVED_AN_EXIT_EVENT_WILL_LEAVE_THE_CHANNEL);
                }
                this.closer = new CloserThread(evt);
                this.closer.start();
            }
        }
    }

    @Override
    public boolean closing() {
        return this.closing || this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForClose() throws InterruptedException {
        CloserThread c;
        JChannel jChannel = this;
        synchronized (jChannel) {
            c = this.closer;
        }
        if (c != null && c.isAlive()) {
            c.join();
        }
    }

    public long getMulticastState() {
        NAKACK nakack = (NAKACK)this.prot_stack.findProtocol("NAKACK");
        if (nakack == null) {
            return 0L;
        }
        return nakack.getCurrentSeqno();
    }

    public void waitForMulticastState(Address otherMember, long seqno) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        NAKACK nakack = (NAKACK)this.prot_stack.findProtocol("NAKACK");
        if (nakack != null) {
            long highest;
            while ((highest = nakack.getHighSeqnoDispatched(otherMember)) < seqno) {
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("Waiting for multicast seqno for " + otherMember + ", current=" + highest + ", need=" + seqno);
                }
                Thread.sleep(100L);
            }
        }
    }

    public void setClosed(boolean isClosed) {
        this.closed = isClosed;
    }

    public void registerTestHook(MembershipTestHook testHook) {
        this.channelTestHook = testHook;
    }

    public void unregisterTestHook() {
        this.channelTestHook = null;
    }

    public MembershipTestHook getTestHook() {
        return this.channelTestHook;
    }

    class CloserThread
    extends Thread {
        final Event evt;
        final Thread t = null;
        final AtomicBoolean done = new AtomicBoolean(false);

        CloserThread(Event evt) {
            this.evt = evt;
            this.setName("CloserThread");
            this.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Boolean.getBoolean("gemfire.snapshotCloserThread")) {
                ((LogWriterImpl)JChannel.this.log.getInternalLogWriter()).logTraces(true, this, 500, this.done);
            }
            try {
                String old_channel_name;
                block51: {
                    old_channel_name = JChannel.this.channel_name;
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info(JGroupsStrings.JChannel_CLOSING_THE_CHANNEL);
                    }
                    AlertAppender.getInstance().shuttingDown();
                    if (JChannel.this.channelTestHook != null) {
                        JChannel.this.channelTestHook.beforeChannelClosing("before channel closing", JChannel.this.closeException);
                    }
                    JChannel.this._close(false, false);
                    if (JChannel.this.up_handler != null) {
                        JChannel.this.up_handler.up(this.evt);
                    } else {
                        try {
                            if (JChannel.this.receiver == null) {
                                JChannel.this.mq.add(this.evt);
                            } else {
                                JChannel.this.receiver.channelClosing(JChannel.this, JChannel.this.closeException);
                            }
                        }
                        catch (Exception ex) {
                            if (!JChannel.this.log.isErrorEnabled()) break block51;
                            JChannel.this.log.error("caught unexpected exception", (Throwable)ex);
                        }
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!JChannel.this.connected) {
                    JChannel.this.connect_promise.setResult(Boolean.FALSE);
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info(JGroupsStrings.JChannel_RECONNECTING_TO_GROUP__0, old_channel_name);
                        }
                        JChannel.this.open();
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error(JGroupsStrings.JChannel_FAILURE_REOPENING_CHANNEL__0, (Throwable)ex);
                        }
                        CloserThread closerThread = this;
                        synchronized (closerThread) {
                            this.done.set(true);
                            JChannel.this.closer = null;
                        }
                        return;
                    }
                    try {
                        if (JChannel.this.additional_data != null) {
                            HashMap<String, byte[]> m = new HashMap<String, byte[]>(11);
                            m.put("additional_data", JChannel.this.additional_data);
                            JChannel.this.down(new Event(56, m));
                        }
                        JChannel.this.connect(old_channel_name);
                        JChannel.this.notifyChannelReconnected(JChannel.this.local_addr);
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error(JGroupsStrings.JChannel_FAILURE_RECONNECTING_TO_CHANNEL__0, (Throwable)ex);
                        }
                        CloserThread closerThread = this;
                        synchronized (closerThread) {
                            this.done.set(true);
                            JChannel.this.closer = null;
                        }
                        return;
                    }
                }
                if (JChannel.this.auto_getstate) {
                    boolean rc;
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info(JGroupsStrings.JChannel_FETCHING_THE_STATE_AUTO_GETSTATETRUE);
                    }
                    if (rc = JChannel.this.getState(null, 5000L)) {
                        if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info(JGroupsStrings.JChannel_STATE_WAS_RETRIEVED_SUCCESSFULLY);
                        } else if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info(JGroupsStrings.JChannel_STATE_TRANSFER_FAILED);
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (JChannel.this.log.isErrorEnabled()) {
                    JChannel.this.log.error("JGroups closer thread caught exception", (Throwable)ex);
                }
            }
            finally {
                CloserThread closerThread = this;
                synchronized (closerThread) {
                    this.done.set(true);
                    JChannel.this.closer = null;
                }
            }
        }
    }
}

