/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class MergeView
extends View {
    protected Vector subgroups = null;

    public MergeView() {
    }

    public MergeView(ViewId vid, Vector members, Vector subgroups) {
        super(vid, members);
        this.subgroups = subgroups;
    }

    public MergeView(Address creator, long id, Vector members, Vector subgroups) {
        super(creator, id, members);
        this.subgroups = subgroups;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Vector getSubgroups() {
        return this.subgroups;
    }

    @Override
    public Object clone() {
        ViewId vid2 = this.vid != null ? (ViewId)this.vid.clone() : null;
        Vector members2 = this.members != null ? (Vector)this.members.clone() : null;
        Vector subgroups2 = this.subgroups != null ? (Vector)this.subgroups.clone() : null;
        return new MergeView(vid2, members2, subgroups2);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MergeView::" + super.toString());
        sb.append(", subgroups=" + this.subgroups);
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.subgroups);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.subgroups = (Vector)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        super.writeTo(out);
        int len = this.subgroups != null ? this.subgroups.size() : 0;
        out.writeShort(len);
        if (len == 0) {
            return;
        }
        for (View v : this.subgroups) {
            v.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        super.readFrom(in);
        int len = in.readShort();
        if (len > 0) {
            this.subgroups = new Vector();
            for (int i = 0; i < len; ++i) {
                View v = new View();
                v.readFrom(in);
                this.subgroups.add(v);
            }
        }
    }

    @Override
    public int serializedSize(short version) {
        int retval = super.serializedSize(version);
        retval += 2;
        if (this.subgroups == null) {
            return retval;
        }
        for (View v : this.subgroups) {
            retval += v.serializedSize(version);
        }
        return retval;
    }
}

