/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.ChannelFactory;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.blocks.RpcDispatcher;
import com.gemstone.org.jgroups.persistence.CannotPersistException;
import com.gemstone.org.jgroups.persistence.CannotRemoveException;
import com.gemstone.org.jgroups.persistence.PersistenceFactory;
import com.gemstone.org.jgroups.persistence.PersistenceManager;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Util;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

public class DistributedHashtable
extends Hashtable
implements MessageListener,
MembershipListener {
    private static final long serialVersionUID = -1438997064696285344L;
    private transient Channel channel;
    protected transient RpcDispatcher disp = null;
    private transient String groupname = null;
    private final transient Vector notifs = new Vector();
    private final transient Vector members = new Vector();
    private transient Class[] put_signature = null;
    private transient Class[] putAll_signature = null;
    private transient Class[] clear_signature = null;
    private transient Class[] remove_signature = null;
    private transient boolean persistent = false;
    private transient PersistenceManager persistence_mgr = null;
    private transient boolean send_message = false;
    protected final transient Promise state_promise = new Promise();
    protected final transient GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.initSignatures();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.setOpt(4, Boolean.TRUE);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(String groupname, ChannelFactory factory, String properties, boolean persistent, long state_timeout) throws ChannelException {
        this.groupname = groupname;
        this.persistent = persistent;
        this.initSignatures();
        this.channel = factory != null ? factory.createChannel(properties) : new JChannel(properties);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
        this.channel.setOpt(4, Boolean.TRUE);
        this.channel.connect(groupname);
        this.start(state_timeout);
    }

    public DistributedHashtable(JChannel channel, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this(channel, false, state_timeout);
    }

    public DistributedHashtable(JChannel channel, boolean persistent, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.groupname = channel.getChannelName();
        this.channel = channel;
        this.persistent = persistent;
        this.init(state_timeout);
    }

    public DistributedHashtable(PullPushAdapter adapter, Serializable id, long state_timeout) throws ChannelNotConnectedException, ChannelClosedException {
        this.initSignatures();
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getChannelName();
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
        this.channel.setOpt(4, Boolean.TRUE);
        this.start(state_timeout);
    }

    public DistributedHashtable(PullPushAdapter adapter, Serializable id) {
        this.initSignatures();
        this.channel = (Channel)adapter.getTransport();
        this.groupname = this.channel.getChannelName();
        this.disp = new RpcDispatcher(adapter, id, (MessageListener)this, (MembershipListener)this, this);
        this.channel.setOpt(4, Boolean.TRUE);
    }

    protected void init(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        this.initSignatures();
        this.channel.setOpt(4, Boolean.TRUE);
        this.disp = new RpcDispatcher(this.channel, (MessageListener)this, (MembershipListener)this, (Object)this);
    }

    public void start(long state_timeout) throws ChannelClosedException, ChannelNotConnectedException {
        if (this.persistent) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.DistributedHashtable_FETCHING_STATE_FROM_DATABASE);
            }
            try {
                this.persistence_mgr = PersistenceFactory.getInstance().createManager();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                }
                this.persistent = false;
            }
        }
        this.state_promise.reset();
        boolean rc = this.channel.getState(null, state_timeout);
        if (rc) {
            Boolean result;
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.DistributedHashtable_STATE_WAS_RETRIEVED_SUCCESSFULLY_WAITING_FOR_SETSTATE);
            }
            if ((result = (Boolean)this.state_promise.getResult(state_timeout)) == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.DistributedHashtable_SETSTATE_NEVER_GOT_CALLED);
                }
            } else if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.DistributedHashtable_SETSTATE_WAS_CALLED);
            }
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.DistributedHashtable_STATE_COULD_NOT_BE_RETRIEVED_FIRST_MEMBER);
            }
            if (this.persistent) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.DistributedHashtable_FETCHING_STATE_FROM_DATABASE);
                }
                try {
                    Map m = this.persistence_mgr.retrieveAll();
                    if (m != null) {
                        for (Map.Entry entry : m.entrySet()) {
                            Object key2 = entry.getKey();
                            Object val = entry.getValue();
                            if (this.log.isInfoEnabled()) {
                                this.log.info(JGroupsStrings.DistributedHashtable_INSERTING__0____1, new Object[]{key2, val});
                            }
                            this.put(key2, val);
                        }
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed creating PersistenceManager, turning persistency off. Exception: " + Util.printStackTrace(ex));
                    }
                    this.persistent = false;
                }
            }
        }
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean p) {
        this.persistent = p;
    }

    public void addNotifier(Notification n) {
        if (!this.notifs.contains(n)) {
            this.notifs.addElement(n);
        }
    }

    public void removeNotifier(Notification n) {
        if (this.notifs.contains(n)) {
            this.notifs.removeElement(n);
        }
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
            this.disp = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    @Override
    public Object put(Object key2, Object value2) {
        Object prev_val = this.get(key2);
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_put", new Object[]{key2, value2}, this.put_signature, 2, 0L);
            }
            catch (Exception e) {}
        } else {
            this._put(key2, value2);
        }
        return prev_val;
    }

    @Override
    public void putAll(Map m) {
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_putAll", new Object[]{m}, this.putAll_signature, 2, 0L);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
            }
        } else {
            this._putAll(m);
        }
    }

    @Override
    public synchronized void clear() {
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_clear", null, this.clear_signature, 2, 0L);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.DistributedHashtable_EXCEPTION_0, (Throwable)e);
                }
            }
        } else {
            this._clear();
        }
    }

    @Override
    public Object remove(Object key2) {
        Object retval = this.get(key2);
        if (this.send_message) {
            try {
                this.disp.callRemoteMethods(null, "_remove", new Object[]{key2}, this.remove_signature, 2, 0L);
            }
            catch (Exception exception) {}
        } else {
            this._remove(key2);
        }
        return retval;
    }

    public Object _put(Object key2, Object value2) {
        Object retval;
        block7: {
            retval = super.put(key2, value2);
            if (this.persistent) {
                try {
                    this.persistence_mgr.save((Serializable)key2, (Serializable)value2);
                }
                catch (CannotPersistException cannot_persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error("failed persisting " + key2 + " + " + value2 + ", exception=" + cannot_persist_ex);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error("failed persisting " + key2 + " + " + value2 + ", exception=" + Util.printStackTrace(t));
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entrySet(key2, value2);
        }
        return retval;
    }

    public void _putAll(Map m) {
        block9: {
            if (m == null) {
                return;
            }
            for (Map.Entry entry : m.entrySet()) {
                super.put(entry.getKey(), entry.getValue());
            }
            if (this.persistent) {
                try {
                    this.persistence_mgr.saveAll(m);
                }
                catch (CannotPersistException persist_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.DistributedHashtable_FAILED_PERSISTING_CONTENTS__0, (Throwable)persist_ex);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    if (!this.log.isErrorEnabled()) break block9;
                    this.log.error(JGroupsStrings.DistributedHashtable_FAILED_PERSISTING_CONTENTS__0, t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsSet(m);
        }
    }

    public void _clear() {
        block7: {
            super.clear();
            if (this.persistent) {
                try {
                    this.persistence_mgr.clear();
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.DistributedHashtable_FAILED_CLEARING_CONTENTS_EXCEPTION_0, (Throwable)cannot_remove_ex);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error(JGroupsStrings.DistributedHashtable_FAILED_CLEARING_CONTENTS_EXCEPTION_0, t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).contentsCleared();
        }
    }

    public Object _remove(Object key2) {
        Object retval;
        block7: {
            retval = super.remove(key2);
            if (this.persistent) {
                try {
                    this.persistence_mgr.remove((Serializable)key2);
                }
                catch (CannotRemoveException cannot_remove_ex) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.DistributedHashtable_FAILED_CLEARING_CONTENTS_EXCEPTION_0, (Throwable)cannot_remove_ex);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    if (!this.log.isErrorEnabled()) break block7;
                    this.log.error(JGroupsStrings.DistributedHashtable_FAILED_CLEARING_CONTENTS_EXCEPTION_0, t);
                }
            }
        }
        for (int i = 0; i < this.notifs.size(); ++i) {
            ((Notification)this.notifs.elementAt(i)).entryRemoved(key2);
        }
        return retval;
    }

    @Override
    public void receive(Message msg) {
    }

    @Override
    public byte[] getState() {
        Hashtable copy = new Hashtable();
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key2 = e.nextElement();
            Object val = this.get(key2);
            copy.put(key2, val);
        }
        try {
            return Util.objectToByteBuffer(copy);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.DistributedHashtable_EXCEPTION_MARSHALLING_STATE__0, ex);
            }
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        Hashtable new_copy;
        try {
            new_copy = (Hashtable)Util.objectFromByteBuffer(new_state);
            if (new_copy == null) {
                return;
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.DistributedHashtable_EXCEPTION_UNMARSHALLING_STATE__0, ex);
            }
            return;
        }
        this._putAll(new_copy);
        this.state_promise.setResult(Boolean.TRUE);
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.sendViewChangeNotifications(new_mbrs, this.members);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    @Override
    public void suspect(SuspectMember suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void channelClosing(Channel c, Exception e) {
    }

    void sendViewChangeNotifications(Vector new_mbrs, Vector old_mbrs) {
        Object mbr;
        int i;
        if (this.notifs.size() == 0 || old_mbrs == null || new_mbrs == null || old_mbrs.size() == 0 || new_mbrs.size() == 0) {
            return;
        }
        Vector joined = new Vector();
        for (i = 0; i < new_mbrs.size(); ++i) {
            mbr = new_mbrs.elementAt(i);
            if (old_mbrs.contains(mbr)) continue;
            joined.addElement(mbr);
        }
        Vector left = new Vector();
        for (i = 0; i < old_mbrs.size(); ++i) {
            mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            left.addElement(mbr);
        }
        for (i = 0; i < this.notifs.size(); ++i) {
            Notification n = (Notification)this.notifs.elementAt(i);
            n.viewChange(joined, left);
        }
    }

    void initSignatures() {
        block7: {
            try {
                if (this.put_signature == null) {
                    this.put_signature = new Class[]{Object.class, Object.class};
                }
                if (this.putAll_signature == null) {
                    this.putAll_signature = new Class[]{Map.class};
                }
                if (this.clear_signature == null) {
                    this.clear_signature = new Class[0];
                }
                if (this.remove_signature == null) {
                    this.remove_signature = new Class[]{Object.class};
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error(JGroupsStrings.DistributedHashtable_EXCEPTION_0, ex);
            }
        }
    }

    public static interface Notification {
        public void entrySet(Object var1, Object var2);

        public void entryRemoved(Object var1);

        public void viewChange(Vector var1, Vector var2);

        public void contentsSet(Map var1);

        public void contentsCleared();
    }
}

