/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.blocks.LockManager;
import com.gemstone.org.jgroups.blocks.LockMultiLockedException;
import com.gemstone.org.jgroups.blocks.LockNotGrantedException;
import com.gemstone.org.jgroups.blocks.LockNotReleasedException;
import com.gemstone.org.jgroups.blocks.TwoPhaseVotingAdapter;
import com.gemstone.org.jgroups.blocks.TwoPhaseVotingListener;
import com.gemstone.org.jgroups.blocks.VoteException;
import com.gemstone.org.jgroups.blocks.VoteResponseProcessor;
import com.gemstone.org.jgroups.blocks.VotingAdapter;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import java.io.Serializable;
import java.util.HashMap;

public class DistributedLockManager
implements TwoPhaseVotingListener,
LockManager,
VoteResponseProcessor {
    private static final int PROCESS_CONTINUE = 0;
    private static final int PROCESS_SKIP = 1;
    private static final int PROCESS_BREAK = 2;
    private static final long ACQUIRE_EXPIRATION = 5000L;
    private static final long VOTE_TIMEOUT = 10000L;
    private final HashMap preparedLocks = new HashMap();
    private final HashMap preparedReleases = new HashMap();
    private final HashMap heldLocks = new HashMap();
    private final TwoPhaseVotingAdapter votingAdapter;
    private final Object id;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public DistributedLockManager(VotingAdapter voteChannel, Object id) {
        this(new TwoPhaseVotingAdapter(voteChannel), id);
    }

    public DistributedLockManager(TwoPhaseVotingAdapter channel, Object id) {
        this.id = id;
        this.votingAdapter = channel;
        this.votingAdapter.addListener(this);
    }

    private boolean localLock(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            lockDecree.commit();
            if (lockDecree.managerId.equals(this.id)) {
                this.heldLocks.put(lockDecree.getKey(), lockDecree);
            }
            return true;
        }
        return localLock.requester.equals(lockDecree.requester);
    }

    private boolean canLock(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private boolean canRelease(LockDecree decree) {
        this.removeExpired(decree);
        LockDecree lock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (lock == null) {
            return true;
        }
        return lock.requester.equals(decree.requester);
    }

    private void removeExpired(LockDecree decree) {
        LockDecree localLock = (LockDecree)this.heldLocks.get(decree.getKey());
        if (localLock != null && !localLock.isValid()) {
            this.heldLocks.remove(localLock.getKey());
        }
    }

    private boolean localRelease(LockDecree lockDecree) {
        this.removeExpired(lockDecree);
        LockDecree localLock = (LockDecree)this.heldLocks.get(lockDecree.getKey());
        if (localLock == null) {
            return true;
        }
        if (localLock.requester.equals(lockDecree.requester)) {
            this.heldLocks.remove(lockDecree.getKey());
            return true;
        }
        return false;
    }

    @Override
    public void lock(Object lockId, Object owner, int timeout) throws LockNotGrantedException, ChannelException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        boolean acquired = this.votingAdapter.vote(new AcquireLockDecree(lockId, owner, this.id), timeout);
        if (!acquired) {
            throw new LockNotGrantedException("Lock cannot be granted.");
        }
    }

    @Override
    public void unlock(Object lockId, Object owner) throws LockNotReleasedException, ChannelException {
        try {
            this.unlock(lockId, owner, false);
        }
        catch (LockMultiLockedException e) {
            this.log.error(JGroupsStrings.DistributedLockManager_CAUGHT_MULTILOCKEDEXCEPTION_BUT_RELEASEMULTILOCKED_IS_FALSE, (Throwable)e);
        }
    }

    @Override
    public void unlock(Object lockId, Object owner, boolean releaseMultiLocked) throws LockNotReleasedException, ChannelException, LockMultiLockedException {
        if (!(lockId instanceof Serializable) || !(owner instanceof Serializable)) {
            throw new ClassCastException("DistributedLockManager works only with serializable objects.");
        }
        ReleaseLockDecree releaseLockDecree = new ReleaseLockDecree(lockId, owner, this.id);
        boolean released = false;
        if (releaseMultiLocked) {
            released = this.votingAdapter.vote(releaseLockDecree, 10000L, this);
            if (releaseLockDecree.isMultipleLocked()) {
                throw new LockMultiLockedException("Lock was also locked by other DistributedLockManager(s)");
            }
        } else {
            released = this.votingAdapter.vote(releaseLockDecree, 10000L);
        }
        if (!released) {
            throw new LockNotReleasedException("Lock cannot be unlocked.");
        }
    }

    private boolean checkPrepared(HashMap preparedContainer, LockDecree requestedDecree) {
        LockDecree preparedDecree = (LockDecree)preparedContainer.get(requestedDecree.getKey());
        if (preparedDecree != null && !preparedDecree.isValid()) {
            preparedContainer.remove(preparedDecree.getKey());
            preparedDecree = null;
        }
        if (preparedDecree != null) {
            return requestedDecree.requester.equals(preparedDecree.requester);
        }
        return true;
    }

    @Override
    public synchronized boolean prepare(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            AcquireLockDecree acquireDecree = (AcquireLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Preparing to acquire decree " + acquireDecree.lockId);
            }
            if (!this.checkPrepared(this.preparedLocks, acquireDecree)) {
                return false;
            }
            if (this.canLock(acquireDecree)) {
                this.preparedLocks.put(acquireDecree.getKey(), acquireDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseDecree = (ReleaseLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Preparing to release decree " + releaseDecree.lockId);
            }
            if (!this.checkPrepared(this.preparedReleases, releaseDecree)) {
                return false;
            }
            if (this.canRelease(releaseDecree)) {
                this.preparedReleases.put(releaseDecree.getKey(), releaseDecree);
                return true;
            }
            return false;
        }
        if (decree instanceof MultiLockDecree) {
            LockDecree lockDecree;
            MultiLockDecree multiLockDecree = (MultiLockDecree)decree;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Marking " + multiLockDecree.getKey() + " as multilocked");
            }
            if ((lockDecree = (LockDecree)this.heldLocks.get(multiLockDecree.getKey())) != null) {
                lockDecree.setMultipleLocked(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean commit(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Committing decree acquisition " + ((LockDecree)decree).lockId);
            }
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return false;
            }
            if (this.localLock((LockDecree)decree)) {
                this.preparedLocks.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Committing decree release " + ((LockDecree)decree).lockId);
            }
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return false;
            }
            if (this.localRelease((LockDecree)decree)) {
                this.preparedReleases.remove(((LockDecree)decree).getKey());
                return true;
            }
            return false;
        }
        return decree instanceof MultiLockDecree;
    }

    @Override
    public synchronized void abort(Object decree) throws VoteException {
        if (!(decree instanceof LockDecree)) {
            throw new VoteException("Uknown decree type. Ignore me.");
        }
        if (decree instanceof AcquireLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Aborting decree acquisition " + ((LockDecree)decree).lockId);
            }
            if (!this.checkPrepared(this.preparedLocks, (LockDecree)decree)) {
                return;
            }
            this.preparedLocks.remove(((LockDecree)decree).getKey());
        } else if (decree instanceof ReleaseLockDecree) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Aborting decree release " + ((LockDecree)decree).lockId);
            }
            if (!this.checkPrepared(this.preparedReleases, (LockDecree)decree)) {
                return;
            }
            this.preparedReleases.remove(((LockDecree)decree).getKey());
        }
    }

    @Override
    public boolean processResponses(RspList responses, int consensusType, Object decree) throws ChannelException {
        Object unwrappedDecree;
        TwoPhaseVotingAdapter.TwoPhaseWrapper wrappedDecree;
        boolean voteResult;
        if (responses == null) {
            return false;
        }
        int totalPositiveVotes = 0;
        int totalNegativeVotes = 0;
        block4: for (int i = 0; i < responses.size(); ++i) {
            Rsp response = (Rsp)responses.elementAt(i);
            switch (this.checkResponse(response)) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    return false;
                }
                default: {
                    VotingAdapter.VoteResult result = (VotingAdapter.VoteResult)response.getValue();
                    totalPositiveVotes += result.getPositiveVotes();
                    totalNegativeVotes += result.getNegativeVotes();
                }
            }
        }
        boolean bl = voteResult = totalNegativeVotes == 0 && totalPositiveVotes > 0;
        if (decree instanceof TwoPhaseVotingAdapter.TwoPhaseWrapper && (wrappedDecree = (TwoPhaseVotingAdapter.TwoPhaseWrapper)decree).isPrepare() && (unwrappedDecree = wrappedDecree.getDecree()) instanceof ReleaseLockDecree) {
            ReleaseLockDecree releaseLockDecree = (ReleaseLockDecree)unwrappedDecree;
            LockDecree lock = null;
            lock = (LockDecree)this.heldLocks.get(releaseLockDecree.getKey());
            if (lock != null) {
                if (!voteResult && this.informLockingNodes(releaseLockDecree)) {
                    lock.setMultipleLocked(true);
                    voteResult = true;
                }
                if (lock.isMultipleLocked()) {
                    releaseLockDecree.setMultipleLocked(true);
                }
            }
        }
        return voteResult;
    }

    private int checkResponse(Rsp response) throws ChannelException {
        if (!response.wasReceived()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Response from node " + response.getSender() + " was not received.");
            }
            throw new ChannelException("Node " + response.getSender() + " failed to respond.");
        }
        if (response.wasSuspected()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Node " + response.getSender() + " was suspected.");
            }
            return 1;
        }
        Object object = response.getValue();
        if (object instanceof Throwable) {
            throw new ChannelException("Node " + response.getSender() + " is faulty.");
        }
        if (object == null) {
            return 1;
        }
        if (!(object instanceof VotingAdapter.VoteResult)) {
            String faultClass = object.getClass().getName();
            throw new ChannelException("Node " + response.getSender() + " generated fault (class " + faultClass + ')');
        }
        if (object instanceof VotingAdapter.FailureVoteResult) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.DistributedLockManager_0, ((VotingAdapter.FailureVoteResult)object).getReason());
            }
            return 2;
        }
        return 0;
    }

    private boolean informLockingNodes(ReleaseLockDecree releaseLockDecree) throws ChannelException {
        return this.votingAdapter.vote(new MultiLockDecree(releaseLockDecree), 10000L);
    }

    public static class MultiLockDecree
    extends LockDecree {
        private static final long serialVersionUID = -8775726661815938941L;

        MultiLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }

        MultiLockDecree(ReleaseLockDecree releaseLockDecree) {
            super(releaseLockDecree.lockId, releaseLockDecree.requester, releaseLockDecree.managerId);
        }
    }

    public static class ReleaseLockDecree
    extends LockDecree {
        private static final long serialVersionUID = -159320406385342426L;

        ReleaseLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }
    }

    public static class AcquireLockDecree
    extends LockDecree {
        private static final long serialVersionUID = 7608853900623293300L;
        private final long creationTime = System.currentTimeMillis();

        protected AcquireLockDecree(Object lockId, Object requester, Object managerId) {
            super(lockId, requester, managerId);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean isValid() {
            boolean result = super.isValid();
            if (!this.commited && result) {
                result = this.creationTime + 5000L > System.currentTimeMillis();
            }
            return result;
        }
    }

    public static class LockDecree
    implements Serializable {
        private static final long serialVersionUID = -7422058144576778340L;
        protected final Object lockId;
        protected final Object requester;
        protected final Object managerId;
        protected boolean commited;
        private boolean multipleLocked = false;

        protected LockDecree(Object lockId, Object requester, Object managerId) {
            this.lockId = lockId;
            this.requester = requester;
            this.managerId = managerId;
        }

        public Object getKey() {
            return this.lockId;
        }

        public boolean isValid() {
            return true;
        }

        public void commit() {
            this.commited = true;
        }

        public boolean isMultipleLocked() {
            return this.multipleLocked;
        }

        public void setMultipleLocked(boolean multipleLocked) {
            this.multipleLocked = multipleLocked;
        }

        public int hashCode() {
            return this.lockId.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof LockDecree) {
                return ((LockDecree)other).lockId.equals(this.lockId);
            }
            return false;
        }
    }
}

