/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.blocks.Link;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.net.InetAddress;
import java.util.Vector;

public class LogicalLink
implements Link.Receiver {
    Receiver receiver = null;
    final Vector links = new Vector();
    static final int link_to_use = 0;
    GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public LogicalLink(Receiver r) {
        this.receiver = r;
    }

    public LogicalLink() {
    }

    public void addLink(String local_addr, int local_port, String remote_addr, int remote_port) {
        Link new_link = new Link(local_addr, local_port, remote_addr, remote_port, this);
        if (this.links.contains(new_link)) {
            this.log.error(JGroupsStrings.LogicalLink_LOGICALLINKADD_LINK__0__IS_ALREADY_PRESENT, new_link);
        } else {
            this.links.addElement(new_link);
        }
    }

    public void addLink(String local_addr, int local_port, String remote_addr, int remote_port, long timeout, long hb_interval) {
        Link new_link = new Link(local_addr, local_port, remote_addr, remote_port, timeout, hb_interval, this);
        if (this.links.contains(new_link)) {
            this.log.error(JGroupsStrings.LogicalLink_LOGICALLINKADD_LINK__0__IS_ALREADY_PRESENT, new_link);
        } else {
            this.links.addElement(new_link);
        }
    }

    public void removeAllLinks() {
        for (int i = 0; i < this.links.size(); ++i) {
            Link tmp = (Link)this.links.elementAt(i);
            tmp.stop();
        }
        this.links.removeAllElements();
    }

    public Vector getLinks() {
        return this.links;
    }

    public int numberOfLinks() {
        return this.links.size();
    }

    public int numberOfEstablishedLinks() {
        int n = 0;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!((Link)this.links.elementAt(i)).established()) continue;
            ++n;
        }
        return n;
    }

    public void start() {
        for (int i = 0; i < this.links.size(); ++i) {
            Link tmp = (Link)this.links.elementAt(i);
            try {
                tmp.start();
                continue;
            }
            catch (Exception ex) {
                this.log.error(JGroupsStrings.LogicalLink_LOGICALLINKSTART_COULD_NOT_CREATE_PHYSICAL_LINK_REASON__0, (Throwable)ex);
            }
        }
    }

    public void stop() {
        for (int i = 0; i < this.links.size(); ++i) {
            Link tmp = (Link)this.links.elementAt(i);
            tmp.stop();
        }
    }

    public boolean send(byte[] buf) throws AllLinksDown, NoLinksAvailable {
        int link_used = 0;
        if (buf == null || buf.length == 0) {
            this.log.error(JGroupsStrings.LogicalLink_LOGICALLINKSEND_BUF_IS_NULL_OR_EMPTY);
            return false;
        }
        if (this.links.size() == 0) {
            throw new NoLinksAvailable();
        }
        for (int i = 0; i < this.links.size(); ++i) {
            Link link = (Link)this.links.elementAt(i);
            if (!link.established() || !link.send(buf)) continue;
            System.out.println("Send over link #" + link_used + ": " + link);
            return true;
        }
        throw new AllLinksDown();
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    @Override
    public synchronized void receive(byte[] buf) {
        if (this.receiver != null) {
            this.receiver.receive(buf);
        }
    }

    @Override
    public synchronized void linkDown(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.linkDown(local2, local_port, remote, remote_port);
        }
    }

    @Override
    public synchronized void linkUp(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.linkUp(local2, local_port, remote, remote_port);
        }
    }

    @Override
    public synchronized void missedHeartbeat(InetAddress local2, int local_port, InetAddress remote, int remote_port, int num_missed_hbs) {
        if (this.receiver != null) {
            this.receiver.missedHeartbeat(local2, local_port, remote, remote_port, num_missed_hbs);
        }
    }

    @Override
    public synchronized void receivedHeartbeatAgain(InetAddress local2, int local_port, InetAddress remote, int remote_port) {
        if (this.receiver != null) {
            this.receiver.receivedHeartbeatAgain(local2, local_port, remote, remote_port);
        }
    }

    protected static class MyReceiver
    implements Receiver {
        protected MyReceiver() {
        }

        @Override
        public void receive(byte[] buf) {
            System.out.println("<-- " + new String(buf));
        }

        @Override
        public synchronized void linkDown(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkDown(): " + r + ':' + rp);
        }

        @Override
        public synchronized void linkUp(InetAddress l, int lp, InetAddress r, int rp) {
            System.out.println("** linkUp(): " + r + ':' + rp);
        }

        @Override
        public synchronized void missedHeartbeat(InetAddress l, int lp, InetAddress r, int rp, int num) {
        }

        @Override
        public synchronized void receivedHeartbeatAgain(InetAddress l, int lp, InetAddress r, int rp) {
        }
    }

    public static interface Receiver {
        public void receive(byte[] var1);

        public void linkDown(InetAddress var1, int var2, InetAddress var3, int var4);

        public void linkUp(InetAddress var1, int var2, InetAddress var3, int var4);

        public void missedHeartbeat(InetAddress var1, int var2, InetAddress var3, int var4, int var5);

        public void receivedHeartbeatAgain(InetAddress var1, int var2, InetAddress var3, int var4);
    }

    public static class AllLinksDown
    extends Exception {
        private static final long serialVersionUID = -2294651737997827005L;

        @Override
        public String toString() {
            return "LogicalLinks.AllLinksDown: all physical links are currently down";
        }
    }

    public static class NoLinksAvailable
    extends Exception {
        private static final long serialVersionUID = -4180512062659195788L;

        @Override
        public String toString() {
            return "LogicalLinks.NoLinksAvailable: there are no physical links available";
        }
    }
}

