/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.SuspectedException;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.UpHandler;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.GroupRequest;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.blocks.RequestCorrelator;
import com.gemstone.org.jgroups.blocks.RequestHandler;
import com.gemstone.org.jgroups.blocks.RspCollector;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;

public class MessageDispatcher
implements RequestHandler {
    protected Channel channel = null;
    protected RequestCorrelator corr = null;
    protected MessageListener msg_listener = null;
    protected MembershipListener membership_listener = null;
    protected RequestHandler req_handler = null;
    protected ProtocolAdapter prot_adapter = null;
    protected TransportAdapter transport_adapter = null;
    protected final Collection members = new TreeSet();
    protected Address local_addr = null;
    protected boolean deadlock_detection = false;
    protected PullPushAdapter adapter = null;
    protected Serializable id = null;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    protected boolean concurrent_processing = false;

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2) {
        this.channel = channel;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, boolean deadlock_detection, boolean concurrent_processing) {
        this.channel = channel;
        this.deadlock_detection = deadlock_detection;
        this.concurrent_processing = concurrent_processing;
        this.prot_adapter = new ProtocolAdapter();
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            channel.setOpt(4, Boolean.TRUE);
        }
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        if (channel != null) {
            channel.setUpHandler(this.prot_adapter);
        }
        this.start();
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this(channel, l, l2);
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection) {
        this(channel, l, l2);
        this.deadlock_detection = deadlock_detection;
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(Channel channel, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean deadlock_detection, boolean concurrent_processing) {
        this(channel, l, l2);
        this.deadlock_detection = deadlock_detection;
        this.concurrent_processing = concurrent_processing;
        this.setRequestHandler(req_handler);
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler) {
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    public MessageDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, RequestHandler req_handler, boolean concurrent_processing) {
        this.concurrent_processing = concurrent_processing;
        this.adapter = adapter;
        this.id = id;
        this.setMembers(((Channel)adapter.getTransport()).getView().getMembers());
        this.setRequestHandler(req_handler);
        this.setMessageListener(l);
        this.setMembershipListener(l2);
        PullPushHandler handler = new PullPushHandler();
        this.transport_adapter = new TransportAdapter();
        adapter.addMembershipListener(handler);
        if (id == null) {
            adapter.setListener(handler);
        } else {
            adapter.registerListener(id, handler);
        }
        Transport tp = adapter.getTransport();
        if (tp instanceof Channel) {
            ((Channel)tp).setOpt(4, Boolean.TRUE);
            this.local_addr = ((Channel)tp).getLocalAddress();
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMembers(Vector new_mbrs) {
        if (new_mbrs != null) {
            Collection collection = this.members;
            synchronized (collection) {
                this.members.clear();
                this.members.addAll(new_mbrs);
            }
        }
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
        if (this.corr != null) {
            this.corr.setDeadlockDetection(flag);
        }
    }

    public void setConcurrentProcessing(boolean flag) {
        this.concurrent_processing = flag;
    }

    public void start() {
        if (this.corr == null) {
            this.corr = this.transport_adapter != null ? new RequestCorrelator("MessageDispatcher", this.transport_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing) : new RequestCorrelator("MessageDispatcher", this.prot_adapter, this, this.deadlock_detection, this.local_addr, this.concurrent_processing);
        }
        this.corr.start();
        if (this.channel != null) {
            Vector tmp_mbrs = this.channel.getView() != null ? this.channel.getView().getMembers() : null;
            this.setMembers(tmp_mbrs);
        }
    }

    public void stop() {
        if (this.corr != null) {
            this.corr.stop();
        }
    }

    public void setMessageListener(MessageListener l) {
        this.msg_listener = l;
    }

    public MessageListener getMessageListener() {
        return this.msg_listener;
    }

    public void setMembershipListener(MembershipListener l) {
        this.membership_listener = l;
    }

    public void setRequestHandler(RequestHandler rh) {
        this.req_handler = rh;
    }

    public Channel getChannel() {
        return this.channel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        if (this.channel != null) {
            this.channel.send(msg);
            return;
        } else if (this.adapter != null) {
            try {
                if (this.id != null) {
                    this.adapter.send(this.id, msg);
                    return;
                }
                this.adapter.send(msg);
                return;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) return;
                this.log.error(JGroupsStrings.MessageDispatcher_EXCEPTION_0, Util.print(ex));
                return;
            }
        } else {
            if (!this.log.isErrorEnabled()) return;
            this.log.error(JGroupsStrings.MessageDispatcher_CHANNEL__NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        Vector real_dests;
        GroupRequest _req = null;
        if (dests != null) {
            real_dests = (Vector)dests.clone();
        } else {
            Collection collection = this.members;
            synchronized (collection) {
                real_dests = new Vector(this.members);
            }
        }
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null && real_dests != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("real_dests=" + real_dests);
        }
        if (real_dests == null || real_dests.size() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("destination list is empty, won't send message");
            }
            return new RspList();
        }
        _req = new GroupRequest(msg, this.corr, real_dests, mode, timeout, 0);
        _req.setCaller(this.local_addr);
        _req.execute();
        return _req.getResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void castMessage(Vector dests, long req_id, Message msg, RspCollector coll) {
        Vector real_dests;
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MessageDispatcher_REQUEST_IS_NULL);
            }
            return;
        }
        if (coll == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MessageDispatcher_RESPONSE_COLLECTOR_IS_NULL_MUST_BE_NONNULL);
            }
            return;
        }
        if (dests != null) {
            real_dests = (Vector)dests.clone();
        } else {
            Collection collection = this.members;
            synchronized (collection) {
                real_dests = new Vector(this.members);
            }
        }
        Channel tmp = this.channel;
        if (tmp == null && this.adapter != null && this.adapter.getTransport() instanceof Channel) {
            tmp = (Channel)this.adapter.getTransport();
        }
        if (tmp != null && tmp.getOpt(3).equals(Boolean.FALSE)) {
            if (this.local_addr == null) {
                this.local_addr = tmp.getLocalAddress();
            }
            if (this.local_addr != null) {
                real_dests.removeElement(this.local_addr);
            }
        }
        if (real_dests.size() == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("destination list is empty, won't send message");
            }
            return;
        }
        this.corr.sendRequest(req_id, real_dests, msg, coll);
    }

    public void done(long req_id) {
        this.corr.done(req_id);
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("the message's destination is null, cannot send message");
            }
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this.corr, mbrs, mode, timeout, 0);
        _req.setCaller(this.local_addr);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(" response list is empty");
            }
            return null;
        }
        if (rsp_list.size() > 1 && this.log.isWarnEnabled()) {
            this.log.warn("response list contains more that 1 response; returning first response !");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    @Override
    public Object handle(Message msg) {
        if (this.req_handler != null) {
            return this.req_handler.handle(msg);
        }
        return null;
    }

    class PullPushHandler
    implements MessageListener,
    MembershipListener {
        PullPushHandler() {
        }

        @Override
        public void receive(Message msg) {
            boolean pass_up = true;
            if (MessageDispatcher.this.corr != null) {
                pass_up = MessageDispatcher.this.corr.receiveMessage(msg);
            }
            if (pass_up && MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.receive(msg);
            }
        }

        @Override
        public byte[] getState() {
            return MessageDispatcher.this.msg_listener != null ? MessageDispatcher.this.msg_listener.getState() : null;
        }

        @Override
        public void setState(byte[] state) {
            if (MessageDispatcher.this.msg_listener != null) {
                MessageDispatcher.this.msg_listener.setState(state);
            }
        }

        @Override
        public void viewAccepted(View v) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveView(v);
            }
            Vector new_mbrs = v.getMembers();
            MessageDispatcher.this.setMembers(new_mbrs);
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.viewAccepted(v);
            }
        }

        @Override
        public void suspect(SuspectMember suspected_mbr) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receiveSuspect(suspected_mbr.suspectedMember);
            }
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.suspect(suspected_mbr);
            }
        }

        @Override
        public void block() {
            if (MessageDispatcher.this.membership_listener != null) {
                MessageDispatcher.this.membership_listener.block();
            }
        }

        @Override
        public void channelClosing(Channel c, Exception e) {
        }
    }

    class TransportAdapter
    implements Transport {
        TransportAdapter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void send(Message msg) throws Exception {
            if (MessageDispatcher.this.channel != null) {
                MessageDispatcher.this.channel.send(msg);
                return;
            } else if (MessageDispatcher.this.adapter != null) {
                try {
                    if (MessageDispatcher.this.id != null) {
                        MessageDispatcher.this.adapter.send(MessageDispatcher.this.id, msg);
                        return;
                    }
                    MessageDispatcher.this.adapter.send(msg);
                    return;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (!MessageDispatcher.this.log.isErrorEnabled()) return;
                    MessageDispatcher.this.log.error(JGroupsStrings.MessageDispatcher_EXCEPTION_0, Util.print(ex));
                    return;
                }
            } else {
                if (!MessageDispatcher.this.log.isErrorEnabled()) return;
                MessageDispatcher.this.log.error(JGroupsStrings.MessageDispatcher_CHANNEL__NULL);
            }
        }

        @Override
        public Object receive(long timeout) throws Exception {
            return null;
        }
    }

    class ProtocolAdapter
    extends Protocol
    implements UpHandler {
        ProtocolAdapter() {
        }

        @Override
        public String getName() {
            return "MessageDispatcher";
        }

        @Override
        public void startUpHandler() {
        }

        @Override
        public void startDownHandler() {
        }

        @Override
        public void stopInternal() {
        }

        @Override
        protected void receiveUpEvent(Event evt) {
        }

        @Override
        protected void receiveDownEvent(Event evt) {
        }

        @Override
        public void passUp(Event evt) {
            byte[] tmp_state = null;
            switch (evt.getType()) {
                case 1: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    MessageDispatcher.this.msg_listener.receive((Message)evt.getArg());
                    break;
                }
                case 17: {
                    if (MessageDispatcher.this.msg_listener != null) {
                        try {
                            tmp_state = MessageDispatcher.this.msg_listener.getState();
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            MessageDispatcher.this.log.error(JGroupsStrings.MessageDispatcher_FAILED_GETTING_STATE_FROM_MESSAGE_LISTENER__0, MessageDispatcher.this.msg_listener, t);
                        }
                    }
                    MessageDispatcher.this.channel.returnState(tmp_state);
                    break;
                }
                case 20: {
                    if (MessageDispatcher.this.msg_listener == null) break;
                    try {
                        MessageDispatcher.this.msg_listener.setState((byte[])evt.getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("received SetStateEvent, but argument " + evt.getArg() + " is not serializable. Discarding message.");
                    }
                    break;
                }
                case 6: {
                    View v = (View)evt.getArg();
                    Vector new_mbrs = v.getMembers();
                    MessageDispatcher.this.setMembers(new_mbrs);
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.viewAccepted(v);
                    break;
                }
                case 8: {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("setting local_addr (" + MessageDispatcher.this.local_addr + ") to " + evt.getArg());
                    }
                    MessageDispatcher.this.local_addr = (Address)evt.getArg();
                    break;
                }
                case 9: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.suspect((SuspectMember)evt.getArg());
                    break;
                }
                case 10: {
                    if (MessageDispatcher.this.membership_listener == null) break;
                    MessageDispatcher.this.membership_listener.block();
                }
            }
        }

        @Override
        public void passDown(Event evt) {
            this.down(evt);
        }

        @Override
        public void up(Event evt) {
            if (MessageDispatcher.this.corr != null) {
                MessageDispatcher.this.corr.receive(evt);
            } else if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MessageDispatcher_CORRELATOR_IS_NULL_EVENT_WILL_BE_IGNORED_EVT_0_, evt);
            }
        }

        @Override
        public void down(Event evt) {
            if (MessageDispatcher.this.channel != null) {
                MessageDispatcher.this.channel.down(evt);
            } else if (this.log.isWarnEnabled()) {
                this.log.warn("channel is null, discarding event " + evt);
            }
        }
    }
}

