/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.BlockEvent;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelListener;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.GetStateEvent;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SetStateEvent;
import com.gemstone.org.jgroups.SuspectEvent;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.Transport;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PullPushAdapter
implements Runnable,
ChannelListener {
    protected Transport transport = null;
    protected MessageListener listener = null;
    protected final List membership_listeners = new ArrayList();
    protected Thread receiver_thread = null;
    protected final HashMap listeners = new HashMap();
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    static final String PULL_HEADER = "PULL_HEADER";

    public PullPushAdapter(Transport transport) {
        this.transport = transport;
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l) {
        this.transport = transport;
        this.setListener(l);
        this.start();
    }

    public PullPushAdapter(Transport transport, MembershipListener ml) {
        this.transport = transport;
        this.addMembershipListener(ml);
        this.start();
    }

    public PullPushAdapter(Transport transport, MessageListener l, MembershipListener ml) {
        this.transport = transport;
        this.setListener(l);
        this.addMembershipListener(ml);
        this.start();
    }

    public Transport getTransport() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        PullPushAdapter pullPushAdapter = this;
        synchronized (pullPushAdapter) {
            if (this.receiver_thread == null || !this.receiver_thread.isAlive()) {
                this.receiver_thread = new Thread((Runnable)this, "PullPushAdapterThread");
                this.receiver_thread.setDaemon(true);
                this.receiver_thread.start();
            }
        }
        if (this.transport instanceof JChannel) {
            ((JChannel)this.transport).addChannelListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tmp;
        PullPushAdapter pullPushAdapter = this;
        synchronized (pullPushAdapter) {
            tmp = this.receiver_thread;
            this.receiver_thread = null;
        }
        if (tmp != null && tmp.isAlive()) {
            tmp.interrupt();
            try {
                tmp.join(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void send(Serializable identifier, Message msg) throws Exception {
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.PullPushAdapter_MSG_IS_NULL);
            }
            return;
        }
        if (identifier == null) {
            this.transport.send(msg);
        } else {
            msg.putHeader(PULL_HEADER, new PullHeader(identifier));
            this.transport.send(msg);
        }
    }

    public void send(Message msg) throws Exception {
        this.send(null, msg);
    }

    public void setListener(MessageListener l) {
        this.listener = l;
    }

    public void registerListener(Serializable identifier, MessageListener l) {
        if (l == null || identifier == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.PullPushAdapter_MESSAGE_LISTENER_OR_IDENTIFIER_IS_NULL);
            }
            return;
        }
        if (this.listeners.containsKey(identifier)) {
            if (this.log.isErrorEnabled()) {
                this.log.error("listener with identifier=" + identifier + " already exists, choose a different identifier or unregister current listener");
            }
            return;
        }
        this.listeners.put(identifier, l);
    }

    public void unregisterListener(Serializable identifier) {
        this.listeners.remove(identifier);
    }

    @Deprecated
    public void setMembershipListener(MembershipListener ml) {
        this.addMembershipListener(ml);
    }

    public void addMembershipListener(MembershipListener l) {
        if (l != null && !this.membership_listeners.contains(l)) {
            this.membership_listeners.add(l);
        }
    }

    public void removeMembershipListener(MembershipListener l) {
        if (l != null && this.membership_listeners.contains(l)) {
            this.membership_listeners.remove(l);
        }
    }

    @Override
    public void run() {
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            try {
                Object obj = this.transport.receive(0L);
                if (obj == null) continue;
                if (obj instanceof Message) {
                    this.handleMessage((Message)obj);
                    continue;
                }
                if (obj instanceof GetStateEvent) {
                    byte[] retval = null;
                    if (this.listener != null) {
                        try {
                            retval = this.listener.getState();
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            this.log.error(JGroupsStrings.PullPushAdapter_GETSTATE_FROM_APPLICATION_FAILED_WILL_RETURN_EMPTY_STATE, t);
                        }
                    } else {
                        this.log.warn("no listener registered, returning empty state");
                    }
                    if (this.transport instanceof Channel) {
                        ((Channel)this.transport).returnState(retval);
                        continue;
                    }
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("underlying transport is not a Channel, but a " + this.transport.getClass().getName() + ": cannot return state using returnState()");
                    continue;
                }
                if (obj instanceof SetStateEvent) {
                    if (this.listener == null) continue;
                    try {
                        this.listener.setState(((SetStateEvent)obj).getArg());
                    }
                    catch (ClassCastException cast_ex) {
                        if (!this.log.isErrorEnabled()) continue;
                        this.log.error("received SetStateEvent, but argument " + (((SetStateEvent)obj).getArg() == null ? "null" : "(" + ((SetStateEvent)obj).getArg().length + " bytes)") + " is not serializable ! Discarding message.");
                    }
                    continue;
                }
                if (obj instanceof View) {
                    this.notifyViewChange((View)obj);
                    continue;
                }
                if (obj instanceof SuspectEvent) {
                    this.notifySuspect((SuspectEvent)obj);
                    continue;
                }
                if (!(obj instanceof BlockEvent)) continue;
                this.notifyBlock();
                continue;
            }
            catch (ChannelNotConnectedException conn) {
                Address local_addr = ((Channel)this.transport).getLocalAddress();
                if (this.log.isWarnEnabled()) {
                    this.log.warn('[' + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel not connected, exception is " + conn);
                }
                try {
                    Util.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            catch (ChannelClosedException closed_ex) {
                if (Thread.currentThread().isInterrupted()) break;
                Address local_addr = ((Channel)this.transport).getLocalAddress();
                if (!this.log.isWarnEnabled()) break;
                this.log.warn('[' + (local_addr == null ? "<null>" : local_addr.toString()) + "] channel closed, exception is " + closed_ex);
            }
            catch (InterruptedException e) {
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                continue;
            }
            break;
        }
    }

    protected void handleMessage(Message msg) {
        Serializable identifier;
        PullHeader hdr = (PullHeader)msg.getHeader(PULL_HEADER);
        if (hdr != null && (identifier = hdr.getIdentifier()) != null) {
            MessageListener l = (MessageListener)this.listeners.get(identifier);
            if (l == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("received a messages tagged with identifier=" + identifier + ", but there is no registration for that identifier. Will drop message");
                }
            } else {
                l.receive(msg);
            }
        } else if (this.listener != null) {
            this.listener.receive(msg);
        }
    }

    protected void notifyViewChange(View v) {
        if (v == null) {
            return;
        }
        for (MembershipListener l : this.membership_listeners) {
            try {
                l.viewAccepted(v);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.PullPushAdapter_EXCEPTION_NOTIFYING__0___1, new Object[]{l, ex});
            }
        }
    }

    protected void notifySuspect(SuspectEvent suspected) {
        if (suspected == null || suspected.getMember() == null) {
            return;
        }
        for (MembershipListener l : this.membership_listeners) {
            try {
                l.suspect(new SuspectMember((Address)suspected.getMember(), (Address)suspected.getSuspector()));
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.PullPushAdapter_EXCEPTION_NOTIFYING__0___1, new Object[]{l, ex});
            }
        }
    }

    protected void notifyBlock() {
        for (MembershipListener l : this.membership_listeners) {
            try {
                l.block();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.PullPushAdapter_EXCEPTION_NOTIFYING__0___1, new Object[]{l, ex});
            }
        }
    }

    @Override
    public void channelConnected(Channel channel) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel is connected");
        }
    }

    @Override
    public void channelDisconnected(Channel channel) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel is disconnected");
        }
    }

    @Override
    public void channelClosed(Channel channel) {
    }

    @Override
    public void channelShunned() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("channel is shunned");
        }
    }

    @Override
    public void channelReconnected(Address addr) {
        this.start();
    }

    public MessageListener getListener() {
        return this.listener;
    }

    public static final class PullHeader
    extends Header {
        Serializable identifier = null;

        public PullHeader() {
        }

        public PullHeader(Serializable identifier) {
            this.identifier = identifier;
        }

        public Serializable getIdentifier() {
            return this.identifier;
        }

        @Override
        public long size(short version) {
            if (this.identifier == null) {
                return 12L;
            }
            return 64L;
        }

        @Override
        public String toString() {
            return "PullHeader";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.identifier);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.identifier = (Serializable)in.readObject();
        }
    }
}

