/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;

@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"}, justification="GemFire does not use this class")
public class ReplicatedTree
implements Runnable,
MessageListener,
MembershipListener {
    public static final String SEPARATOR = "/";
    static final int INDENT = 4;
    Node root = new Node("/", "/", null, null);
    final Vector listeners = new Vector();
    final Queue request_queue = new Queue();
    Thread request_handler = null;
    JChannel channel = null;
    PullPushAdapter adapter = null;
    String groupname = "ReplicatedTree-Group";
    final Vector members = new Vector();
    long state_fetch_timeout = 10000L;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    boolean remote_calls = true;
    String props = "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.STABLE(desired_avg_gossip=20000):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):FRAG(frag_size=16000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
    private boolean send_message = false;

    public ReplicatedTree(String groupname, String props, long state_fetch_timeout) throws Exception {
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        this.start();
    }

    public ReplicatedTree(String groupname, String props, long state_fetch_timeout, boolean jmx) throws Exception {
        ArrayList<MBeanServer> servers;
        if (groupname != null) {
            this.groupname = groupname;
        }
        if (props != null) {
            this.props = props;
        }
        this.state_fetch_timeout = state_fetch_timeout;
        this.channel = new JChannel(this.props);
        this.channel.connect(this.groupname);
        if (jmx && ((servers = MBeanServerFactory.findMBeanServer(null)) == null || servers.size() == 0)) {
            throw new Exception("No MBeanServers found;\nJmxTest needs to be run with an MBeanServer present, or inside JDK 5");
        }
        this.start();
    }

    public ReplicatedTree() {
    }

    public ReplicatedTree(JChannel channel) throws Exception {
        this.channel = channel;
        this.start();
    }

    public void setRemoteCalls(boolean flag) {
        this.remote_calls = flag;
    }

    public void setRootNode(Node n) {
        this.root = n;
    }

    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    public Vector getMembers() {
        return this.members;
    }

    public void fetchState(long timeout) throws ChannelClosedException, ChannelNotConnectedException {
        boolean rc = this.channel.getState(null, timeout);
        if (rc) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ReplicatedTree_STATE_WAS_RETRIEVED_SUCCESSFULLY);
            } else if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ReplicatedTree_STATE_COULD_NOT_BE_RETRIEVED_FIRST_MEMBER);
            }
        }
    }

    public void addReplicatedTreeListener(ReplicatedTreeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeReplicatedTreeListener(ReplicatedTreeListener listener) {
        this.listeners.removeElement(listener);
    }

    public synchronized void start() throws Exception {
        if (this.request_handler == null) {
            this.request_handler = new Thread((Runnable)this, "ReplicatedTree.RequestHandler thread");
            this.request_handler.setDaemon(true);
            this.request_handler.start();
        }
        this.adapter = new PullPushAdapter(this.channel, this, this);
        this.adapter.setListener(this);
        this.channel.setOpt(4, Boolean.TRUE);
        boolean rc = this.channel.getState(null, this.state_fetch_timeout);
        if (rc) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ReplicatedTree_STATE_WAS_RETRIEVED_SUCCESSFULLY);
            } else if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ReplicatedTree_STATE_COULD_NOT_BE_RETRIEVED_FIRST_MEMBER);
            }
        }
    }

    public synchronized void stop() {
        if (this.request_handler != null && this.request_handler.isAlive()) {
            this.request_queue.close(true);
            this.request_handler.interrupt();
            this.request_handler = null;
        }
        this.request_handler = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.adapter != null) {
            this.adapter.stop();
            this.adapter = null;
        }
        this.channel = null;
    }

    public void put(String fqn, HashMap data) {
        if (!this.remote_calls) {
            this._put(fqn, data);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_CHANNEL_IS_NULL_CANNOT_BROADCAST_PUT_REQUEST);
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, data)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_FAILURE_BCASTING_PUT_REQUEST__0, (Throwable)ex);
                }
            }
        } else {
            this._put(fqn, data);
        }
    }

    public void put(String fqn, String key2, Object value2) {
        if (!this.remote_calls) {
            this._put(fqn, key2, value2);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_CHANNEL_IS_NULL_CANNOT_BROADCAST_PUT_REQUEST);
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(1, fqn, key2, value2)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_FAILURE_BCASTING_PUT_REQUEST__0, (Throwable)ex);
                }
            }
        } else {
            this._put(fqn, key2, value2);
        }
    }

    public void remove(String fqn) {
        if (!this.remote_calls) {
            this._remove(fqn);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_CHANNEL_IS_NULL_CANNOT_BROADCAST_REMOVE_REQUEST);
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_FAILURE_BCASTING_REMOVE_REQUEST__0, (Throwable)ex);
                }
            }
        } else {
            this._remove(fqn);
        }
    }

    public void remove(String fqn, String key2) {
        if (!this.remote_calls) {
            this._remove(fqn, key2);
            return;
        }
        if (this.send_message) {
            if (this.channel == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_CHANNEL_IS_NULL_CANNOT_BROADCAST_REMOVE_REQUEST);
                }
                return;
            }
            try {
                this.channel.send(new Message(null, null, new Request(2, fqn, key2)));
            }
            catch (Exception ex) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicatedTree_FAILURE_BCASTING_REMOVE_REQUEST__0, (Throwable)ex);
                }
            }
        } else {
            this._remove(fqn, key2);
        }
    }

    public boolean exists(String fqn) {
        if (fqn == null) {
            return false;
        }
        return this.findNode(fqn) != null;
    }

    public Set getKeys(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        HashMap data = n.getData();
        if (data == null) {
            return null;
        }
        return data.keySet();
    }

    public Object get(String fqn, String key2) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData(key2);
    }

    HashMap get(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.getData();
    }

    public String print(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        return n.toString();
    }

    public Set getChildrenNames(String fqn) {
        Node n = this.findNode(fqn);
        if (n == null) {
            return null;
        }
        Map m = n.getChildren();
        if (m != null) {
            return m.keySet();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int indent = 0;
        Map children = this.root.getChildren();
        if (children != null && children.size() > 0) {
            Collection nodes = children.values();
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                ((Node)it.next()).print(sb, indent);
                sb.append('\n');
            }
        } else {
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    public String getGroupName() {
        return this.groupname;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getGroupMembersNumber() {
        return this.members.size();
    }

    public void _put(String fqn, HashMap data) {
        StringHolder child_name = new StringHolder();
        boolean child_exists = false;
        if (fqn == null) {
            return;
        }
        Node n = this.findParentNode(fqn, child_name, true);
        if (child_name.getValue() != null) {
            child_exists = n.childExists(child_name.getValue());
            n.createChild(child_name.getValue(), fqn, n, data);
        } else {
            child_exists = true;
            n.setData(data);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _put(String fqn, String key2, Object value2) {
        StringHolder child_name = new StringHolder();
        boolean child_exists = false;
        if (fqn == null || key2 == null || value2 == null) {
            return;
        }
        Node n = this.findParentNode(fqn, child_name, true);
        if (child_name.getValue() != null) {
            child_exists = n.childExists(child_name.getValue());
            n.createChild(child_name.getValue(), fqn, n, key2, value2);
        } else {
            child_exists = true;
            n.setData(key2, value2);
        }
        if (child_exists) {
            this.notifyNodeModified(fqn);
        } else {
            this.notifyNodeAdded(fqn);
        }
    }

    public void _remove(String fqn) {
        StringHolder child_name = new StringHolder();
        if (fqn == null) {
            return;
        }
        if (fqn.equals(SEPARATOR)) {
            this.root.removeAll();
            this.notifyNodeRemoved(fqn);
            return;
        }
        Node n = this.findParentNode(fqn, child_name, false);
        if (n == null) {
            return;
        }
        n.removeChild(child_name.getValue(), fqn);
        this.notifyNodeRemoved(fqn);
    }

    public void _remove(String fqn, String key2) {
        if (fqn == null || key2 == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData(key2);
        }
    }

    public void _removeData(String fqn) {
        if (fqn == null) {
            return;
        }
        Node n = this.findNode(fqn);
        if (n != null) {
            n.removeData();
        }
    }

    @Override
    public void receive(Message msg) {
        Request req = null;
        if (msg == null || msg.getLength() == 0) {
            return;
        }
        try {
            req = (Request)msg.getObject();
            this.request_queue.add(req);
        }
        catch (QueueClosedException queue_closed_ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicatedTree_REQUEST_QUEUE_IS_NULL);
            }
        }
        catch (Exception ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicatedTree_FAILED_UNMARSHALLING_REQUEST__0, (Throwable)ex);
            }
            return;
        }
    }

    @Override
    public byte[] getState() {
        try {
            return Util.objectToByteBuffer(this.root.clone());
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicatedTree_EXCEPTION_RETURNING_CACHE__0, ex);
            }
            return null;
        }
    }

    @Override
    public void setState(byte[] new_state) {
        block5: {
            Node new_root = null;
            if (new_state == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ReplicatedTree_NEW_CACHE_IS_NULL);
                }
                return;
            }
            try {
                Object obj = Util.objectFromByteBuffer(new_state);
                this.root = new_root = (Node)((Node)obj).clone();
                this.notifyAllNodesCreated(this.root);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error(JGroupsStrings.ReplicatedTree_COULD_NOT_SET_CACHE__0, ex);
            }
        }
    }

    @Override
    public void viewAccepted(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            this.notifyViewChange(new_view);
            this.members.removeAllElements();
            for (int i = 0; i < new_mbrs.size(); ++i) {
                this.members.addElement(new_mbrs.elementAt(i));
            }
        }
        this.send_message = this.members.size() > 1;
    }

    @Override
    public void suspect(SuspectMember suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void channelClosing(Channel c, Exception e) {
    }

    @Override
    public void run() {
        String fqn = null;
        block8: while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            try {
                Request req = (Request)this.request_queue.remove(0L);
                fqn = req.fqn;
                switch (req.type) {
                    case 1: {
                        if (req.key != null && req.value != null) {
                            this._put(fqn, req.key, req.value);
                            continue block8;
                        }
                        this._put(fqn, req.data);
                        continue block8;
                    }
                    case 2: {
                        if (req.key != null) {
                            this._remove(fqn, req.key);
                            continue block8;
                        }
                        this._remove(fqn);
                        continue block8;
                    }
                }
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.ReplicatedTree_TYPE__0__UNKNOWN, req.type);
                continue;
            }
            catch (QueueClosedException queue_closed_ex) {
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable other_ex) {
                SystemFailure.checkFailure();
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn("exception processing request: " + other_ex);
                continue;
            }
            break;
        }
    }

    Node findParentNode(String fqn, StringHolder child_name, boolean create_if_not_exists) {
        Node curr = this.root;
        StringBuffer sb = null;
        if (fqn == null || fqn.equals(SEPARATOR) || "".equals(fqn)) {
            return curr;
        }
        sb = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(fqn, SEPARATOR);
        while (tok.countTokens() > 1) {
            String name = tok.nextToken();
            sb.append(SEPARATOR).append(name);
            Node node = curr.getChild(name);
            if (node == null && create_if_not_exists) {
                node = curr.createChild(name, sb.toString(), null, null);
            }
            if (node == null) {
                return null;
            }
            curr = node;
        }
        if (tok.countTokens() > 0 && child_name != null) {
            child_name.setValue(tok.nextToken());
        }
        return curr;
    }

    Node findNode(String fqn) {
        StringHolder sh = new StringHolder();
        Node n = this.findParentNode(fqn, sh, false);
        String child_name = sh.getValue();
        if (fqn == null || fqn.equals(SEPARATOR) || "".equals(fqn)) {
            return this.root;
        }
        if (n == null || child_name == null) {
            return null;
        }
        return n.getChild(child_name);
    }

    void notifyNodeAdded(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeAdded(fqn);
        }
    }

    void notifyNodeRemoved(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeRemoved(fqn);
        }
    }

    void notifyNodeModified(String fqn) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).nodeModified(fqn);
        }
    }

    void notifyViewChange(View v) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ReplicatedTreeListener)this.listeners.elementAt(i)).viewChange(v);
        }
    }

    void notifyAllNodesCreated(Node curr) {
        if (curr == null) {
            return;
        }
        this.notifyNodeAdded(curr.fqn);
        Map children = curr.getChildren();
        if (children != null) {
            for (Node n : children.values()) {
                this.notifyAllNodesCreated(n);
            }
        }
    }

    static class MyListener
    implements ReplicatedTreeListener {
        MyListener() {
        }

        @Override
        public void nodeAdded(String fqn) {
            System.out.println("** node added: " + fqn);
        }

        @Override
        public void nodeRemoved(String fqn) {
            System.out.println("** node removed: " + fqn);
        }

        @Override
        public void nodeModified(String fqn) {
            System.out.println("** node modified: " + fqn);
        }

        @Override
        public void viewChange(View new_view) {
            System.out.println("** view change: " + new_view);
        }
    }

    private static class Request
    implements Serializable {
        private static final long serialVersionUID = 6700917610434765172L;
        static final int PUT = 1;
        static final int REMOVE = 2;
        int type = 0;
        String fqn = null;
        String key = null;
        Object value = null;
        HashMap data = null;

        protected Request(int type, String fqn) {
            this.type = type;
            this.fqn = fqn;
        }

        protected Request(int type, String fqn, HashMap data) {
            this(type, fqn);
            this.data = data;
        }

        protected Request(int type, String fqn, String key2) {
            this(type, fqn);
            this.key = key2;
        }

        protected Request(int type, String fqn, String key2, Object value2) {
            this(type, fqn);
            this.key = key2;
            this.value = value2;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(Request.type2String(this.type)).append(" (");
            if (this.fqn != null) {
                sb.append(" fqn=" + this.fqn);
            }
            switch (this.type) {
                case 1: {
                    if (this.data != null) {
                        sb.append(", data=" + this.data);
                    }
                    if (this.key != null) {
                        sb.append(", key=" + this.key);
                    }
                    if (this.value == null) break;
                    sb.append(", value=" + this.value);
                    break;
                }
                case 2: {
                    if (this.key == null) break;
                    sb.append(", key=" + this.key);
                    break;
                }
            }
            sb.append(')');
            return sb.toString();
        }

        static String type2String(int t) {
            switch (t) {
                case 1: {
                    return "PUT";
                }
                case 2: {
                    return "REMOVE";
                }
            }
            return "UNKNOWN";
        }
    }

    protected static class StringHolder {
        String s = null;

        StringHolder() {
        }

        void setValue(String s) {
            this.s = s;
        }

        String getValue() {
            return this.s;
        }
    }

    public static class Node
    implements Serializable {
        private static final long serialVersionUID = -6687893970420949516L;
        String name = null;
        String fqn = null;
        Node parent = null;
        TreeMap children = null;
        HashMap data = null;

        protected Node(String child_name, String fqn, Node parent, HashMap data) {
            this.name = child_name;
            this.fqn = fqn;
            this.parent = parent;
            if (data != null) {
                this.data = (HashMap)data.clone();
            }
        }

        private Node(String child_name, String fqn, Node parent, String key2, Object value2) {
            this.name = child_name;
            this.fqn = fqn;
            this.parent = parent;
            if (this.data == null) {
                this.data = new HashMap();
            }
            this.data.put(key2, value2);
        }

        void setData(Map data) {
            if (data == null) {
                return;
            }
            if (this.data == null) {
                this.data = new HashMap();
            }
            this.data.putAll(data);
        }

        void setData(String key2, Object value2) {
            if (this.data == null) {
                this.data = new HashMap();
            }
            this.data.put(key2, value2);
        }

        HashMap getData() {
            return this.data;
        }

        Object getData(String key2) {
            return this.data != null ? this.data.get(key2) : null;
        }

        boolean childExists(String child_name) {
            if (child_name == null) {
                return false;
            }
            return this.children != null ? this.children.containsKey(child_name) : false;
        }

        Node createChild(String child_name, String fqn, Node parent, HashMap data) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = new TreeMap();
            }
            if ((child = (Node)this.children.get(child_name)) != null) {
                child.setData(data);
            } else {
                child = new Node(child_name, fqn, parent, data);
                this.children.put(child_name, child);
            }
            return child;
        }

        Node createChild(String child_name, String fqn, Node parent, String key2, Object value2) {
            Node child = null;
            if (child_name == null) {
                return null;
            }
            if (this.children == null) {
                this.children = new TreeMap();
            }
            if ((child = (Node)this.children.get(child_name)) != null) {
                child.setData(key2, value2);
            } else {
                child = new Node(child_name, fqn, parent, key2, value2);
                this.children.put(child_name, child);
            }
            return child;
        }

        Node getChild(String child_name) {
            return child_name == null ? null : (this.children == null ? null : (Node)this.children.get(child_name));
        }

        Map getChildren() {
            return this.children;
        }

        void removeData(String key2) {
            if (this.data != null) {
                this.data.remove(key2);
            }
        }

        void removeData() {
            if (this.data != null) {
                this.data.clear();
            }
        }

        void removeChild(String child_name, String fqn) {
            if (child_name != null && this.children != null && this.children.containsKey(child_name)) {
                this.children.remove(child_name);
            }
        }

        void removeAll() {
            if (this.children != null) {
                this.children.clear();
            }
        }

        void print(StringBuffer sb, int indent) {
            this.printIndent(sb, indent);
            sb.append(ReplicatedTree.SEPARATOR).append(this.name);
            if (this.children != null && this.children.size() > 0) {
                Collection values = this.children.values();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    sb.append('\n');
                    ((Node)it.next()).print(sb, indent + 4);
                }
            }
        }

        void printIndent(StringBuffer sb, int indent) {
            if (sb != null) {
                for (int i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.name != null) {
                sb.append("\nname=" + this.name);
            }
            if (this.fqn != null) {
                sb.append("\nfqn=" + this.fqn);
            }
            if (this.data != null) {
                sb.append("\ndata=" + this.data);
            }
            return sb.toString();
        }

        public Object clone() throws CloneNotSupportedException {
            Node n = new Node(this.name, this.fqn, this.parent != null ? (Node)this.parent.clone() : null, this.data);
            if (this.children != null) {
                n.children = (TreeMap)this.children.clone();
            }
            return n;
        }
    }

    public static interface ReplicatedTreeListener {
        public void nodeAdded(String var1);

        public void nodeRemoved(String var1);

        public void nodeModified(String var1);

        public void viewChange(View var1);
    }
}

