/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.MembershipListener;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.MessageListener;
import com.gemstone.org.jgroups.blocks.LockingException;
import com.gemstone.org.jgroups.blocks.MessageDispatcher;
import com.gemstone.org.jgroups.blocks.PullPushAdapter;
import com.gemstone.org.jgroups.blocks.ReplicationData;
import com.gemstone.org.jgroups.blocks.ReplicationReceiver;
import com.gemstone.org.jgroups.blocks.RequestHandler;
import com.gemstone.org.jgroups.blocks.UpdateException;
import com.gemstone.org.jgroups.blocks.Xid;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.RspList;
import java.io.Serializable;

public class ReplicationManager
implements RequestHandler {
    Address local_addr = null;
    ReplicationReceiver receiver = null;
    protected MessageDispatcher disp = null;
    protected final GemFireTracer log = GemFireTracer.getLog(this.getClass());

    public ReplicationManager(Channel channel, MessageListener ml, MembershipListener l, ReplicationReceiver receiver) {
        this.setReplicationReceiver(receiver);
        if (channel != null) {
            this.local_addr = channel.getLocalAddress();
            this.disp = new MessageDispatcher(channel, ml, l, this, true);
        }
    }

    public ReplicationManager(PullPushAdapter adapter, Serializable id, MessageListener ml, MembershipListener l, ReplicationReceiver receiver) {
        if (adapter != null && adapter.getTransport() != null && adapter.getTransport() instanceof Channel) {
            this.local_addr = ((Channel)adapter.getTransport()).getLocalAddress();
        }
        this.setReplicationReceiver(receiver);
        this.disp = new MessageDispatcher(adapter, id, ml, l, this);
        this.disp.setDeadlockDetection(true);
    }

    public void stop() {
        if (this.disp != null) {
            this.disp.stop();
        }
    }

    public Xid begin() throws Exception {
        return this.begin(1);
    }

    public Xid begin(int transaction_mode) throws Exception {
        return Xid.create(this.local_addr, transaction_mode);
    }

    public void setReplicationReceiver(ReplicationReceiver handler) {
        this.receiver = handler;
    }

    public void setMembershipListener(MembershipListener l) {
        if (l == null) {
            return;
        }
        if (this.disp == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicationManager_DISPATCHER_IS_NULL_CANNOT_SET_MEMBERSHIPLISTENER);
            }
        } else {
            this.disp.setMembershipListener(l);
        }
    }

    public RspList send(Address dest, byte[] data, boolean synchronous, long synchronous_timeout, Xid transaction, byte[] lock_info, long lock_acquisition_timeout, long lock_lease_timeout, boolean use_locks) {
        Message msg = null;
        ReplicationData d = new ReplicationData(1, data, transaction, lock_info, lock_acquisition_timeout, lock_lease_timeout, use_locks);
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ReplicationManager_DATA_IS__0__SYNCHRONOUS_1, new Object[]{d, synchronous});
        }
        msg = new Message(dest, null, d);
        if (synchronous) {
            return this.disp.castMessage(null, msg, 2, synchronous_timeout);
        }
        this.disp.castMessage(null, msg, 6, 0L);
        return null;
    }

    public void commit(Xid transaction) {
        this.sendMessage(2, transaction);
    }

    public void rollback(Xid transaction) {
        this.sendMessage(3, transaction);
    }

    @Override
    public Object handle(Message msg) {
        ReplicationData data;
        Object retval = null;
        if (msg == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicationManager_RECEIVED_MESSAGE_WAS_NULL);
            }
            return null;
        }
        if (msg.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicationManager_PAYLOAD_OF_RECEIVED_MESSAGE_WAS_NULL);
            }
            return null;
        }
        try {
            data = (ReplicationData)msg.getObject();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ReplicationManager_FAILURE_UNMARSHALLING_MESSAGE__0, ex);
            }
            return null;
        }
        switch (data.getType()) {
            case 1: {
                try {
                    return this.handleSend(data);
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.ReplicationManager_FAILED_HANDLING_UPDATE__0, ex);
                    }
                    return ex;
                }
            }
            case 2: {
                this.handleCommit(data.getTransaction());
                break;
            }
            case 3: {
                this.handleRollback(data.getTransaction());
                break;
            }
            default: {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.ReplicationManager_RECEIVED_INCORRECT_REPLICATION_MESSAGE__0, data);
                }
                return null;
            }
        }
        return retval;
    }

    protected Object handleSend(ReplicationData data) throws UpdateException, LockingException {
        try {
            if (this.receiver == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("receiver is not set");
                }
                return null;
            }
            return this.receiver.receive(data.getTransaction(), data.getData(), data.getLockInfo(), data.getLockAcquisitionTimeout(), data.getLockLeaseTimeout(), data.useLocks());
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            return ex;
        }
    }

    protected void handleCommit(Xid transaction) {
        if (this.receiver == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("receiver is not set");
            }
        } else {
            this.receiver.commit(transaction);
        }
    }

    protected void handleRollback(Xid transaction) {
        if (this.receiver == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("receiver is not set");
            }
        } else {
            this.receiver.rollback(transaction);
        }
    }

    void sendMessage(int type, Xid transaction) {
        ReplicationData data = new ReplicationData(type, null, transaction, null, 0L, 0L, false);
        Message msg = new Message(null, null, data);
        this.disp.castMessage(null, msg, 6, 0L);
    }
}

