/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.blocks;

import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.blocks.TwoPhaseVotingListener;
import com.gemstone.org.jgroups.blocks.VoteException;
import com.gemstone.org.jgroups.blocks.VoteResponseProcessor;
import com.gemstone.org.jgroups.blocks.VotingAdapter;
import com.gemstone.org.jgroups.blocks.VotingListener;
import java.io.Serializable;

public class TwoPhaseVotingAdapter {
    private final VotingAdapter voteChannel;

    public TwoPhaseVotingAdapter(VotingAdapter voteChannel) {
        this.voteChannel = voteChannel;
    }

    public void addListener(TwoPhaseVotingListener listener) {
        this.voteChannel.addVoteListener(new TwoPhaseVoteWrapper(listener));
    }

    public void removeListener(TwoPhaseVotingListener listener) {
        this.voteChannel.removeVoteListener(new TwoPhaseVoteWrapper(listener));
    }

    public boolean vote(Object decree, long timeout) throws ChannelException {
        return this.vote(decree, timeout, null);
    }

    public boolean vote(Object decree, long timeout, VoteResponseProcessor voteResponseProcessor) throws ChannelException {
        TwoPhaseWrapper wrappedDecree = new TwoPhaseWrapper(decree);
        try {
            if (this.voteChannel.vote((Object)wrappedDecree, timeout / 3L, voteResponseProcessor)) {
                wrappedDecree.commit();
                if (!this.voteChannel.vote((Object)wrappedDecree, timeout / 3L, voteResponseProcessor)) {
                    wrappedDecree.abort();
                    this.voteChannel.vote((Object)wrappedDecree, timeout / 3L, voteResponseProcessor);
                    return false;
                }
                return true;
            }
            wrappedDecree.abort();
            this.voteChannel.vote((Object)wrappedDecree, timeout / 3L, voteResponseProcessor);
            return false;
        }
        catch (ChannelException chex) {
            wrappedDecree.abort();
            this.voteChannel.vote((Object)wrappedDecree, timeout / 3L, voteResponseProcessor);
            throw chex;
        }
    }

    public VotingAdapter getVoteChannel() {
        return this.voteChannel;
    }

    public static class TwoPhaseWrapper
    implements Serializable {
        private static final long serialVersionUID = 413742420131273083L;
        private static final int PREPARE = 0;
        private static final int COMMIT = 1;
        private static final int ABORT = 2;
        private Object decree;
        private int type;

        public TwoPhaseWrapper(Object decree) {
            this.setDecree(decree);
            this.setType(0);
        }

        public Object getDecree() {
            return this.decree;
        }

        public void setDecree(Object decree) {
            this.decree = decree;
        }

        private void setType(int type) {
            this.type = type;
        }

        private boolean isType(int type) {
            return this.type == type;
        }

        public boolean isPrepare() {
            return this.isType(0);
        }

        public boolean isCommit() {
            return this.isType(1);
        }

        public boolean isAbort() {
            return this.isType(2);
        }

        public void commit() {
            this.setType(1);
        }

        public void abort() {
            this.setType(2);
        }

        public String toString() {
            return this.decree.toString();
        }
    }

    public static class TwoPhaseVoteWrapper
    implements VotingListener {
        private final TwoPhaseVotingListener listener;

        public TwoPhaseVoteWrapper(TwoPhaseVotingListener listener) {
            this.listener = listener;
        }

        @Override
        public boolean vote(Object decree) throws VoteException {
            if (!(decree instanceof TwoPhaseWrapper)) {
                throw new VoteException("Not my type of decree. Ignore me.");
            }
            TwoPhaseWrapper wrapper = (TwoPhaseWrapper)decree;
            if (wrapper.isPrepare()) {
                return this.listener.prepare(wrapper.getDecree());
            }
            if (wrapper.isCommit()) {
                return this.listener.commit(wrapper.getDecree());
            }
            this.listener.abort(wrapper.getDecree());
            return false;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object other) {
            return this.listener.equals(other);
        }
    }
}

