/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.conf;

import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClassPathEntityResolver
implements EntityResolver {
    public String mDefaultJGroupsDTD = "com/gemstone/gemfire/distributed/internal/javagroups-protocol.dtd";

    public ClassPathEntityResolver() {
    }

    public ClassPathEntityResolver(String dtdName) {
        this.mDefaultJGroupsDTD = dtdName;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource source = new InputSource(this.getInputStream(this.mDefaultJGroupsDTD));
        return source;
    }

    protected InputStream getInputStream(String dtdurl) throws IOException {
        String url = dtdurl;
        if (url == null) {
            url = this.mDefaultJGroupsDTD;
        }
        try {
            URL inurl = new URL(url);
            return inurl.openStream();
        }
        catch (Exception ignore) {
            InputStream stream = Util.getResourceAsStream(url, this.getClass());
            if (stream == null) {
                throw new IOException("Could not locate the DTD with name:[" + url + "] in the classpath.");
            }
            return stream;
        }
    }
}

