/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.conf;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.conf.ClassMap;
import com.gemstone.org.jgroups.conf.ClassPathEntityResolver;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class MagicNumberReader {
    private static boolean xml_debug = false;
    public static final String MAGIC_NUMBER_FILE = "jg-magic-map.xml";
    public static final String MAGIC_NUMBER_TEXT_FILE = "jg-magic-map.txt";
    public String mMagicNumberFile = "jg-magic-map.xml";

    private static GemFireTracer getLog() {
        return GemFireTracer.getLog(GemFireTracer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassMap[] readMagicNumberMappingFromText() {
        ClassMap[] clsMapRet = new ClassMap[]{};
        InputStream stream = null;
        try {
            stream = ClassPathLoader.getLatest().getResourceAsStream(MagicNumberReader.class, MAGIC_NUMBER_TEXT_FILE);
            if (stream == null) {
                if (MagicNumberReader.getLog().isWarnEnabled()) {
                    MagicNumberReader.getLog().warn("MagicNumberReader.readMagicNumberMappingFromTest(): failed reading jg-magic-map.txt. Please make sure it is in the CLASSPATH. Will continue, but marshalling will be slower");
                }
            } else {
                clsMapRet = MagicNumberReader.parseText(stream);
            }
        }
        catch (Exception x) {
            if (xml_debug) {
                x.printStackTrace();
            }
            MagicNumberReader.getLog().error(JGroupsStrings.MagicNumberReader_MAGICNUMBERREADERREADMAGICNUMBERMAPPING, (Throwable)x);
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException x) {
                    MagicNumberReader.getLog().warn("MagicNumberReader.readMagicNumberMappingFromTest(): exception on closing InputStream ", x);
                }
            }
        }
        return clsMapRet;
    }

    protected static ClassMap[] parseText(InputStream stream) throws IOException {
        String line;
        ArrayList<ClassMap> classMaps = new ArrayList<ClassMap>();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "US-ASCII"));
        while (br.ready() && (line = br.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, "/");
            if (!st.hasMoreTokens()) continue;
            String className = st.nextToken();
            String description = st.nextToken();
            boolean preload = Boolean.valueOf(st.nextToken());
            int magicNumber = Integer.parseInt(st.nextToken());
            classMaps.add(new ClassMap(className, description, preload, magicNumber));
        }
        return classMaps.toArray(new ClassMap[0]);
    }

    public void setFilename(String file) {
        this.mMagicNumberFile = file;
    }

    public ClassMap[] readMagicNumberMapping() {
        try {
            InputStream stream = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), this.mMagicNumberFile);
            if (stream == null) {
                MagicNumberReader.getLog().warn("MagicNumberReader.readMagicNumberMapping(): failed reading " + this.mMagicNumberFile + ". Please make sure it is in the CLASSPATH. Will " + "continue, but marshalling will be slower");
                return new ClassMap[0];
            }
            return MagicNumberReader.parse(stream);
        }
        catch (Exception x) {
            if (xml_debug) {
                x.printStackTrace();
            }
            MagicNumberReader.getLog().error(JGroupsStrings.MagicNumberReader_MAGICNUMBERREADERREADMAGICNUMBERMAPPING, (Throwable)x);
            return new ClassMap[0];
        }
    }

    protected static ClassMap[] parse(InputStream stream) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        XmlHandler handler = new XmlHandler();
        parser.parse(stream, (DefaultHandler)handler);
        return handler.getClassMaps();
    }

    public static void main(String[] args) throws Throwable {
        ClassMap[] classes = null;
        if (args.length < 1) {
            classes = MagicNumberReader.readMagicNumberMappingFromText();
        } else {
            FileInputStream fos = new FileInputStream(args[0]);
            classes = MagicNumberReader.parse(fos);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < classes.length; ++i) {
            ClassMap cm = classes[i];
            sb.append(cm.getClassName());
            sb.append('/');
            sb.append(cm.getDescription());
            sb.append('/');
            sb.append(cm.getPreload());
            sb.append('/');
            sb.append(cm.getMagicNumber());
            sb.append('\n');
        }
        System.out.println(sb);
    }

    static class XmlHandler
    extends DefaultHandler {
        private static final int INVALID_STATE = 0;
        private static final int DESCRIPTION_STATE = 1;
        private static final int CLASS_NAME_STATE = 2;
        private static final int PRELOAD_STATE = 3;
        private static final int MAGIC_NUMBER_STATE = 4;
        private List classMaps = new ArrayList();
        private int state;
        private String description;
        private String className;
        private boolean preload;
        private int magicNumber;
        private EntityResolver resolver = new ClassPathEntityResolver();

        XmlHandler() {
        }

        public ClassMap[] getClassMaps() {
            return this.classMaps.toArray(new ClassMap[0]);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("description")) {
                this.state = 1;
            } else if (qName.equals("class-name")) {
                this.state = 2;
            } else if (qName.equals("preload")) {
                this.state = 3;
            } else if (qName.equals("magic-number")) {
                this.state = 4;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("class")) {
                Assert.assertTrue(this.className != null);
                Assert.assertTrue(this.description != null);
                ClassMap classMap = new ClassMap(this.className, this.description, this.preload, this.magicNumber);
                this.classMaps.add(classMap);
                this.className = null;
                this.description = null;
                this.state = 0;
            } else {
                this.state = 0;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 2: {
                    this.className = new String(ch, start, length);
                    break;
                }
                case 1: {
                    this.description = new String(ch, start, length);
                    break;
                }
                case 3: {
                    String s = new String(ch, start, length);
                    this.preload = Boolean.valueOf(s);
                    break;
                }
                case 4: {
                    String s = new String(ch, start, length);
                    try {
                        this.magicNumber = Integer.parseInt(s);
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException("Invalid magic number: " + s);
                    }
                }
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                return this.resolver.resolveEntity(publicId, systemId);
            }
            catch (IOException ex) {
                String s = "While resolving " + publicId + ", " + systemId;
                throw new SAXException(s, ex);
            }
        }
    }
}

