/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.debug;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GemFire does not use this class")
public class Profiler {
    private static OutputStream os = null;
    private static final Hashtable entries = new Hashtable();
    private static GemFireTracer log = GemFireTracer.getLog(Profiler.class);

    public Profiler() {
        try {
            os = new FileOutputStream("profiler.dat");
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static void setFilename(String filename) {
        try {
            if (os != null) {
                os.close();
            }
            os = new FileOutputStream(filename);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static void start(String call_name) {
        Entry e = (Entry)entries.get(call_name);
        if (e == null) {
            e = new Entry();
            entries.put(call_name, e);
        }
        e.start_time = System.currentTimeMillis();
    }

    public static void stop(String call_name) {
        Entry e = (Entry)entries.get(call_name);
        if (e == null) {
            log.error(JGroupsStrings.Profiler_PROFILERSTOP_ENTRY_FOR__0__NOT_FOUND, call_name);
            return;
        }
        e.stop_time = System.currentTimeMillis();
        e.compute();
    }

    public static void dump() {
        if (os == null) {
            log.error(JGroupsStrings.Profiler_PROFILERDUMP_OUTPUT_FILE_IS_NULL);
            return;
        }
        try {
            os.write("Key:      Number of calls:    Total time (ms): Average time (ms):\n".getBytes());
            os.write("-----------------------------------------------------------------\n\n".getBytes());
        }
        catch (Exception e) {
            log.error(e);
        }
        Enumeration e = entries.keys();
        while (e.hasMoreElements()) {
            String key2 = (String)e.nextElement();
            Entry val = (Entry)entries.get(key2);
            try {
                os.write((key2 + ": " + val.num_calls + ' ' + val.tot_time + ' ' + Profiler.trim(val.avg) + '\n').getBytes());
            }
            catch (Exception ex) {
                log.error(ex);
            }
        }
    }

    public static double trim(double inp) {
        double retval = 0.0;
        double rem = 0.0;
        long l1 = (long)inp;
        rem = inp - (double)l1;
        long l2 = (long)(rem *= 100.0);
        rem = (double)l2 / 100.0;
        retval = (double)l1 + rem;
        return retval;
    }

    public static class Entry {
        long num_calls = 0L;
        long tot_time = 0L;
        double avg = 0.0;
        long start_time = 0L;
        long stop_time = 0L;

        synchronized void compute() {
            ++this.num_calls;
            this.tot_time += this.stop_time - this.start_time;
            this.avg = (double)this.tot_time / (double)this.num_calls;
        }
    }
}

