/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.oswego.concurrent.BoundedLinkedQueue;
import com.gemstone.org.jgroups.oswego.concurrent.Channel;
import com.gemstone.org.jgroups.oswego.concurrent.Executor;
import com.gemstone.org.jgroups.oswego.concurrent.ThreadFactoryUser;

public class QueuedExecutor
extends ThreadFactoryUser
implements Executor {
    protected Thread thread_;
    protected static final Runnable ENDTASK = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected volatile boolean shutdown_;
    protected final Channel queue_;
    protected final RunLoop runLoop_;

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public QueuedExecutor(Channel queue) {
        this.queue_ = queue;
        this.runLoop_ = new RunLoop();
    }

    public QueuedExecutor() {
        this(new BoundedLinkedQueue());
    }

    public synchronized void restart() {
        if (this.thread_ == null && !this.shutdown_) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        }
    }

    @Override
    public void execute(Runnable command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.restart();
        this.queue_.put(command);
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        if (!this.shutdown_) {
            try {
                this.queue_.put(ENDTASK);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void shutdownAfterProcessingCurrentTask() {
        this.shutdown_ = true;
        try {
            while (this.queue_.poll(0L) != null) {
            }
            this.queue_.put(ENDTASK);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        Thread t = this.thread_;
        if (t != null) {
            t.interrupt();
        }
        this.shutdownAfterProcessingCurrentTask();
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!QueuedExecutor.this.shutdown_) {
                    SystemFailure.checkFailure();
                    Runnable task = (Runnable)QueuedExecutor.this.queue_.take();
                    if (task == ENDTASK) {
                        QueuedExecutor.this.shutdown_ = true;
                    } else if (task != null) {
                        task.run();
                        task = null;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            finally {
                QueuedExecutor.this.clearThread();
            }
        }
    }
}

