/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class VetoableChangeMulticaster
implements Serializable {
    private static final long serialVersionUID = 7647606497666380264L;
    protected transient VetoableChangeListener[] listeners = new VetoableChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized VetoableChangeMulticaster getChild(String propertyName) {
        return this.children == null ? null : (VetoableChangeMulticaster)this.children.get(propertyName);
    }

    public VetoableChangeMulticaster(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int len = this.listeners.length;
        VetoableChangeListener[] newArray = new VetoableChangeListener[len + 1];
        if (len > 0) {
            System.arraycopy(this.listeners, 0, newArray, 0, len);
        }
        newArray[len] = listener;
        this.listeners = newArray;
    }

    public synchronized void addVetoableChangeListenerIfAbsent(VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int len = this.listeners.length;
        VetoableChangeListener[] newArray = new VetoableChangeListener[len + 1];
        for (int i = 0; i < len; ++i) {
            newArray[i] = this.listeners[i];
            if (!listener.equals(this.listeners[i])) continue;
            return;
        }
        newArray[len] = listener;
        this.listeners = newArray;
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener listener) {
        int newlen = this.listeners.length - 1;
        if (newlen < 0 || listener == null) {
            return;
        }
        VetoableChangeListener[] newArray = new VetoableChangeListener[newlen];
        for (int i = 0; i < newlen; ++i) {
            if (listener.equals(this.listeners[i])) {
                for (int k = i + 1; k <= newlen; ++k) {
                    newArray[k - 1] = this.listeners[k];
                }
                this.listeners = newArray;
                return;
            }
            newArray[i] = this.listeners[i];
        }
        if (listener.equals(this.listeners[newlen])) {
            this.listeners = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster child = null;
        VetoableChangeMulticaster vetoableChangeMulticaster = this;
        synchronized (vetoableChangeMulticaster) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                child = (VetoableChangeMulticaster)this.children.get(propertyName);
            }
            if (child == null) {
                child = new VetoableChangeMulticaster(this.source);
                this.children.put(propertyName, child);
            }
        }
        child.addVetoableChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListenerIfAbsent(String propertyName, VetoableChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        VetoableChangeMulticaster child = null;
        VetoableChangeMulticaster vetoableChangeMulticaster = this;
        synchronized (vetoableChangeMulticaster) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                child = (VetoableChangeMulticaster)this.children.get(propertyName);
            }
            if (child == null) {
                child = new VetoableChangeMulticaster(this.source);
                this.children.put(propertyName, child);
            }
        }
        child.addVetoableChangeListenerIfAbsent(listener);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        VetoableChangeMulticaster child = this.getChild(propertyName);
        if (child != null) {
            child.removeVetoableChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent evt) throws PropertyVetoException {
        VetoableChangeListener[] array;
        VetoableChangeMulticaster child = null;
        VetoableChangeMulticaster vetoableChangeMulticaster = this;
        synchronized (vetoableChangeMulticaster) {
            array = this.listeners;
            if (this.children != null && evt.getPropertyName() != null) {
                child = (VetoableChangeMulticaster)this.children.get(evt.getPropertyName());
            }
        }
        int i = 0;
        try {
            for (i = 0; i < array.length; ++i) {
                array[i].vetoableChange(evt);
            }
            if (child != null) {
                child.multicast(evt);
            }
        }
        catch (PropertyVetoException veto) {
            PropertyChangeEvent revert = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getNewValue(), evt.getOldValue());
            int lastNotified = i < array.length ? i : array.length - 1;
            for (int k = 0; k <= lastNotified; ++k) {
                try {
                    array[k].vetoableChange(revert);
                    continue;
                }
                catch (PropertyVetoException ignore) {
                    // empty catch block
                }
            }
            throw veto;
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        if (oldValue != newValue) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        if (oldValue != newValue) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void fireVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.multicast(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        VetoableChangeMulticaster child;
        VetoableChangeMulticaster vetoableChangeMulticaster = this;
        synchronized (vetoableChangeMulticaster) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (propertyName == null || this.children == null) {
                return false;
            }
            child = (VetoableChangeMulticaster)this.children.get(propertyName);
            if (child == null) {
                return false;
            }
        }
        return child.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.listeners.length; ++i) {
            if (!(this.listeners[i] instanceof Serializable)) continue;
            s.writeObject(this.listeners[i]);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        this.listeners = new VetoableChangeListener[0];
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addVetoableChangeListener((VetoableChangeListener)listenerOrNull);
        }
    }
}

