/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.oswego.concurrent;

import com.gemstone.org.jgroups.oswego.concurrent.Semaphore;

public final class WaiterPreferenceSemaphore
extends Semaphore {
    protected long waits_ = 0L;

    public WaiterPreferenceSemaphore(long initial) {
        super(initial);
    }

    @Override
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permits_ > this.waits_) {
                --this.permits_;
                return;
            }
            ++this.waits_;
            try {
                do {
                    this.wait();
                } while (this.permits_ <= 0L);
                --this.waits_;
                --this.permits_;
                return;
            }
            catch (InterruptedException ex) {
                --this.waits_;
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            if (this.permits_ > this.waits_) {
                --this.permits_;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            ++this.waits_;
            long startTime = System.currentTimeMillis();
            long waitTime = msecs;
            try {
                do {
                    this.wait(waitTime);
                    if (this.permits_ <= 0L) continue;
                    --this.waits_;
                    --this.permits_;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                --this.waits_;
                return false;
            }
            catch (InterruptedException ex) {
                --this.waits_;
                this.notify();
                throw ex;
            }
        }
    }

    @Override
    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    @Override
    public synchronized void release(long n) {
        this.permits_ += n;
        for (long i = 0L; i < n; ++i) {
            this.notify();
        }
    }
}

