/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.Protocol;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class DISCARD
extends Protocol {
    final Vector members = new Vector();
    double up = 0.0;
    double down = 0.0;
    boolean excludeItself = false;
    Address localAddress;
    int num_down = 0;
    int num_up = 0;

    @Override
    public String getName() {
        return "DISCARD";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("up");
        if (str != null) {
            this.up = Double.parseDouble(str);
            props.remove("up");
        }
        if ((str = props.getProperty("down")) != null) {
            this.down = Double.parseDouble(str);
            props.remove("down");
        }
        if ((str = props.getProperty("excludeitself")) != null) {
            this.excludeItself = Boolean.valueOf(str);
            props.remove("excludeitself");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.DISCARD_DISCARDSETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void up(Event evt) {
        if (evt.getType() == 8) {
            this.localAddress = (Address)evt.getArg();
        }
        if (evt.getType() == 1) {
            double r;
            Message msg = (Message)evt.getArg();
            if (this.up > 0.0 && (r = Math.random()) < this.up) {
                if (this.excludeItself && msg.getSrc().equals(this.localAddress)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("excluding itself");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("dropping message");
                    }
                    ++this.num_up;
                    return;
                }
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        if (evt.getType() == 1) {
            double r;
            Message msg = (Message)evt.getArg();
            if (this.down > 0.0 && (r = Math.random()) < this.down) {
                if (this.excludeItself && msg.getSrc().equals(this.localAddress)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("excluding itself");
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("dropping message");
                    }
                    ++this.num_down;
                    return;
                }
            }
        }
        this.passDown(evt);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_up = 0;
        this.num_down = 0;
    }

    @Override
    public Map dumpStats() {
        HashMap<String, Integer> m = new HashMap<String, Integer>(2);
        m.put("num_dropped_down", this.num_down);
        m.put("num_dropped_up", this.num_up);
        return m;
    }
}

