/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.LinkedQueue;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class ENCRYPT
extends Protocol {
    static final String DEFAULT_SYM_ALGO = "Blowfish";
    Address local_addr = null;
    Address keyServerAddr = null;
    String asymProvider = null;
    final String symProvider;
    String asymAlgorithm = "RSA";
    String symAlgorithm = "Blowfish";
    int asymInit = 512;
    int symInit = 56;
    private boolean suppliedKey = false;
    private String keyStoreName;
    private String storePassword = "changeit";
    private String keyPassword = "changeit";
    private String alias = "mykey";
    KeyPair Kpair;
    static final PublicKey serverPubKey = null;
    Cipher symEncodingCipher;
    Cipher symDecodingCipher;
    private String symVersion = null;
    SecretKey secretKey = null;
    final Map keyMap = new WeakHashMap();
    private boolean queue_up = true;
    private boolean queue_down = false;
    private LinkedQueue upMessageQueue = new LinkedQueue();
    private LinkedQueue downMessageQueue = new LinkedQueue();
    private Cipher asymCipher;

    public ENCRYPT() {
        this.symProvider = null;
    }

    @Override
    public String getName() {
        return "ENCRYPT";
    }

    private String getAlgorithm(String s) {
        int index2 = s.indexOf("/");
        if (index2 == -1) {
            return s;
        }
        return s.substring(0, index2);
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("asym_init");
        if (str != null) {
            this.asymInit = Integer.parseInt(str);
            props.remove("asym_init");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_ASYM_ALGO_BITS_USED_IS__0, this.asymInit);
            }
        }
        if ((str = props.getProperty("sym_init")) != null) {
            this.symInit = Integer.parseInt(str);
            props.remove("sym_init");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_SYM_ALGO_BITS_USED_IS__0, this.symInit);
            }
        }
        if ((str = props.getProperty("asym_algorithm")) != null) {
            this.asymAlgorithm = str;
            props.remove("asym_algorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_ASYM_ALGO_USED_IS__0, this.asymAlgorithm);
            }
        }
        if ((str = props.getProperty("sym_algorithm")) != null) {
            this.symAlgorithm = str;
            props.remove("sym_algorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_SYM_ALGO_USED_IS__0, this.symAlgorithm);
            }
        }
        if ((str = props.getProperty("asym_provider")) != null) {
            this.asymProvider = str;
            props.remove("asym_provider");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_ASYMPROVIDER_USED_IS__0, this.asymProvider);
            }
        }
        if ((str = props.getProperty("key_store_name")) != null) {
            this.keyStoreName = str;
            props.remove("key_store_name");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_KEY_STORE_NAME_USED_IS__0, this.keyStoreName);
            }
        }
        if ((str = props.getProperty("store_password")) != null) {
            this.storePassword = str;
            props.remove("store_password");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_STORE_PASSWORD_USED_IS_NOT_NULL);
            }
        }
        if ((str = props.getProperty("key_password")) != null) {
            this.keyPassword = str;
            props.remove("key_password");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_KEY_PASSWORD_USED_IS_NOT_NULL);
            }
        } else if (this.storePassword != null) {
            this.keyPassword = this.storePassword;
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_KEY_PASSWORD_USED_IS_SAME_AS_STORE_PASSWORD);
            }
        }
        if ((str = props.getProperty("alias")) != null) {
            this.alias = str;
            props.remove("alias");
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.ENCRYPT_ALIAS_USED_IS__0, this.alias);
            }
        }
        if (props.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.ENCRYPT_THESE_PROPERTIES_ARE_NOT_RECOGNIZED_0, props);
            }
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        if (this.keyStoreName == null) {
            this.initSymKey();
            this.initKeyPair();
        } else {
            this.initConfiguredKey();
        }
        this.initSymCiphers(this.symAlgorithm, this.getSecretKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguredKey() throws KeyStoreException, Exception, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        InputStream inputStream = null;
        KeyStore store = KeyStore.getInstance("JCEKS");
        SecretKey tempKey = null;
        try {
            inputStream = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), this.keyStoreName);
            if (inputStream == null) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + " ensure file is on classpath");
            }
            try {
                store.load(inputStream, this.storePassword.toCharArray());
                tempKey = (SecretKey)store.getKey(this.alias, this.keyPassword.toCharArray());
            }
            catch (IOException e) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + ": " + e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("No Such algorithm " + this.keyStoreName + ": " + e);
            }
            catch (CertificateException e) {
                throw new Exception("Certificate exception " + this.keyStoreName + ": " + e);
            }
            if (tempKey == null) {
                throw new Exception("Unable to retrieve key '" + this.alias + "' from keystore " + this.keyStoreName);
            }
            this.setSecretKey(tempKey);
            if (this.symAlgorithm.equals(DEFAULT_SYM_ALGO)) {
                this.symAlgorithm = tempKey.getAlgorithm();
            }
            this.suppliedKey = true;
            this.queue_down = false;
            this.queue_up = false;
        }
        catch (Throwable throwable) {
            Util.closeInputStream(inputStream);
            throw throwable;
        }
        Util.closeInputStream(inputStream);
    }

    public void initSymKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.symProvider != null && this.symProvider.trim().length() > 0 ? KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm), this.symProvider) : KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.secretKey = keyGen.generateKey();
        this.setSecretKey(this.secretKey);
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_SYMMETRIC_KEY_GENERATED);
        }
    }

    private void initSymCiphers(String algorithm, SecretKey secret) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_INITIALIZING_SYMMETRIC_CIPHERS);
        }
        this.symEncodingCipher = Cipher.getInstance(algorithm);
        this.symDecodingCipher = Cipher.getInstance(algorithm);
        this.symEncodingCipher.init(1, secret);
        this.symDecodingCipher.init(2, secret);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(secret.getEncoded());
        this.symVersion = new String(digest.digest(), "UTF-8");
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_INITIALIZED_SYMMETRIC_CIPHERS_WITH_SECRET_KEY_VERSION__0, this.symVersion);
        }
    }

    public void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.asymProvider != null && this.asymProvider.trim().length() > 0 ? KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm), this.asymProvider) : KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        this.asymCipher = Cipher.getInstance(this.asymAlgorithm);
        this.asymCipher.init(2, this.Kpair.getPrivate());
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_ASYM_ALGO_INITIALIZED);
        }
    }

    public void reset() {
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("set local address to " + this.local_addr);
                break;
            }
            case 6: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT_HANDLING_VIEW__0, view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view);
                break;
            }
            case 1: {
                if (evt.getArg() == null || ((Message)evt.getArg()).getBuffer() == null) {
                    if (!trace) break;
                    this.log.trace("passing up message as it has an empty buffer ");
                    break;
                }
                try {
                    this.handleUpMessage(evt);
                }
                catch (Exception e) {
                    this.log.warn("Exception occurred decrypting message", e);
                }
                return;
            }
        }
        this.passUp(evt);
    }

    private synchronized void handleViewChange(View view) {
        if (view.getMembers() == null || view.getMembers().get(0) == null) {
            this.becomeKeyServer(this.local_addr);
            return;
        }
        Address tmpKeyServer = (Address)view.getMembers().get(0);
        if (tmpKeyServer.equals(this.local_addr) && (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr))) {
            this.becomeKeyServer(tmpKeyServer);
        } else if (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr)) {
            this.handleNewKeyServer(tmpKeyServer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Membership has changed but I do not care");
        }
    }

    private void becomeKeyServer(Address tmpKeyServer) {
        this.keyServerAddr = tmpKeyServer;
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_I_HAVE_BECOME_KEY_SERVER__0, this.keyServerAddr);
        }
        this.queue_down = false;
        this.queue_up = false;
    }

    private void handleNewKeyServer(Address newKeyServer) {
        this.queue_up = true;
        this.queue_down = true;
        this.keyServerAddr = newKeyServer;
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.ENCRYPT_SENDING_KEY_REQUEST);
        }
        this.sendKeyRequest();
    }

    private void handleUpMessage(Event evt) throws Exception {
        Message msg = (Message)evt.getArg();
        if (msg == null) {
            if (trace) {
                this.log.trace("null message - passing straight up");
            }
            this.passUp(evt);
            return;
        }
        Object obj = msg.getHeader("encrypt");
        if (obj == null || !(obj instanceof EncryptHeader)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("dropping message as ENCRYPT header is null  or has not been recognized, msg will not be passed up, headers are " + msg.getHeaders());
            }
            return;
        }
        EncryptHeader hdr = (EncryptHeader)obj;
        if (trace) {
            this.log.trace("header received " + hdr);
        }
        if (hdr.getType() == 0) {
            if (this.queue_up) {
                if (trace) {
                    this.log.trace("queueing up message as no session key established: " + evt.getArg());
                }
                this.upMessageQueue.put(evt);
            } else {
                Message tmpMsg;
                if (!this.suppliedKey) {
                    this.drainUpQueue();
                }
                if ((tmpMsg = this.decryptMessage(this.symDecodingCipher, msg)) != null) {
                    if (trace) {
                        this.log.trace("decrypted message " + tmpMsg);
                    }
                    this.passUp(evt);
                } else {
                    this.log.warn("Unrecognised cipher discarding message");
                }
            }
        } else if (this.suppliedKey) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("We received an encrypt header of " + hdr.getType() + " while in configured mode");
            }
        } else {
            switch (hdr.getType()) {
                case 1: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.ENCRYPT_RECEIVED_A_KEY_REQUEST_FROM_PEER);
                    }
                    try {
                        PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
                        this.sendSecretKey(this.getSecretKey(), tmpKey, msg.getSrc());
                    }
                    catch (Exception e) {
                        this.log.warn("unable to reconstitute peer's public key");
                    }
                    break;
                }
                case 3: {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.ENCRYPT_RECEIVED_A_SECRETKEY_RESPONSE_FROM_KEYSERVER);
                    }
                    try {
                        SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
                        if (tmp == null) {
                            this.sendKeyRequest();
                            break;
                        }
                        this.setKeys(tmp, hdr.getVersion());
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info(JGroupsStrings.ENCRYPT_DECODED_SECRETKEY_RESPONSE);
                    }
                    catch (Exception e) {
                        this.log.warn("unable to process received public key");
                    }
                    break;
                }
                default: {
                    this.log.warn("Received ignored encrypt header of " + hdr.getType());
                }
            }
        }
    }

    private void drainUpQueue() throws QueueClosedException, Exception {
        Event tmp = null;
        while ((tmp = (Event)this.upMessageQueue.poll(0L)) != null) {
            Message msg = this.decryptMessage(this.symDecodingCipher, (Message)tmp.getArg());
            if (msg != null) {
                if (trace) {
                    this.log.trace("passing up message from drain " + msg);
                }
                this.passUp(tmp);
                continue;
            }
            this.log.warn("discarding message in queue up drain as cannot decode it");
        }
    }

    private void setKeys(SecretKey key2, String version) throws Exception {
        this.keyMap.put(this.getSymVersion(), this.getSymDecodingCipher());
        this.setSecretKey(key2);
        this.initSymCiphers(key2.getAlgorithm(), key2);
        this.setSymVersion(version);
        this.log.info(JGroupsStrings.ENCRYPT_SETTING_QUEUE_UP_TO_FALSE_IN_SETKEYS);
        this.queue_up = false;
        this.drainUpQueue();
        this.queue_down = false;
        this.drainDownQueue();
    }

    private Message decryptMessage(Cipher cipher, Message msg) throws Exception {
        EncryptHeader hdr = (EncryptHeader)msg.getHeader("encrypt");
        if (!hdr.getVersion().equals(this.getSymVersion())) {
            this.log.warn("attempting to use stored cipher as message does not uses current encryption version ");
            Cipher temp = (Cipher)this.keyMap.get(hdr.getVersion());
            if (temp == null) {
                this.log.warn("Unable to find a matching cipher in previous key map");
                return null;
            }
            if (trace) {
                this.log.trace("decrypting using previous cipher version " + hdr.getVersion());
            }
            msg.setBuffer(temp.doFinal(msg.getBuffer()));
            return msg;
        }
        msg.setBuffer(cipher.doFinal(msg.getBuffer()));
        return msg;
    }

    private void sendSecretKey(SecretKey secret, PublicKey pubKey, Address source) throws InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("encoding shared key ");
        }
        Cipher tmp = Cipher.getInstance(this.asymAlgorithm);
        tmp.init(1, pubKey);
        byte[] encryptedKey = tmp.doFinal(secret.getEncoded());
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Generated encoded key which only client can decode:" + this.formatArray(encryptedKey));
        }
        Message newMsg = new Message(source, this.local_addr, encryptedKey);
        newMsg.putHeader("encrypt", new EncryptHeader(3, this.getSymVersion()));
        if (this.log.isDebugEnabled()) {
            this.log.debug(" Sending version " + this.getSymVersion() + " encoded key to client");
        }
        this.passDown(new Event(1, newMsg));
    }

    private Message sendKeyRequest() {
        Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
        newMsg.putHeader("encrypt", new EncryptHeader(1, this.getSymVersion()));
        this.passDown(new Event(1, newMsg));
        return newMsg;
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                try {
                    if (this.queue_down) {
                        if (trace) {
                            this.log.trace("queueing down message as no session key established" + evt.getArg());
                        }
                        this.downMessageQueue.put(evt);
                    } else {
                        this.handleDownEvent(evt);
                    }
                }
                catch (Exception e) {
                    this.log.warn("unable to send down event " + e);
                }
                return;
            }
            case 6: {
                View view = (View)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.ENCRYPT_HANDLING_VIEW__0, view);
                }
                if (this.suppliedKey) break;
                this.handleViewChange(view);
                break;
            }
        }
        this.passDown(evt);
    }

    private void handleDownEvent(Event evt) throws Exception {
        if (!this.suppliedKey) {
            this.drainDownQueue();
        }
        this.sendDown(evt);
    }

    private void drainDownQueue() throws Exception, QueueClosedException {
        Event tmp = null;
        while ((tmp = (Event)this.downMessageQueue.poll(0L)) != null) {
            this.sendDown(tmp);
        }
    }

    private void sendDown(Event evt) throws Exception {
        if (evt.getType() != 1) {
            return;
        }
        Message msg = (Message)evt.getArg();
        msg.putHeader("encrypt", new EncryptHeader(0, this.getSymVersion()));
        if (msg.getBuffer() != null) {
            Message msgEncrypted = msg.copy(false);
            msgEncrypted.setBuffer(this.encryptMessage(this.symEncodingCipher, msg.getBuffer()));
            this.passDown(new Event(1, msgEncrypted));
            return;
        }
        if (trace) {
            this.log.trace("buffer is null not encrypting ");
        }
        this.passDown(evt);
    }

    private byte[] encryptMessage(Cipher cipher, byte[] plain) throws Exception {
        byte[] cypherText = cipher.doFinal(plain);
        return cypherText;
    }

    private SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes = this.asymCipher.doFinal(encodedKey);
        SecretKeySpec keySpec = null;
        try {
            keySpec = new SecretKeySpec(keyBytes, this.getAlgorithm(this.symAlgorithm));
            Cipher temp = Cipher.getInstance(this.symAlgorithm);
            temp.init(3, keySpec);
        }
        catch (Exception e) {
            this.log.fatal(e);
            keySpec = null;
        }
        return keySpec;
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(this.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    private String formatArray(byte[] array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(Integer.toHexString(array[i]));
        }
        return buf.toString();
    }

    protected int getAsymInit() {
        return this.asymInit;
    }

    protected String getAsymProvider() {
        return this.asymProvider;
    }

    protected SecretKey getDesKey() {
        return this.secretKey;
    }

    protected KeyPair getKpair() {
        return this.Kpair;
    }

    protected Cipher getAsymCipher() {
        return this.asymCipher;
    }

    protected PublicKey getServerPubKey() {
        return serverPubKey;
    }

    protected String getSymAlgorithm() {
        return this.symAlgorithm;
    }

    protected int getSymInit() {
        return this.symInit;
    }

    protected String getSymProvider() {
        return this.symProvider;
    }

    protected String getAsymAlgorithm() {
        return this.asymAlgorithm;
    }

    private String getSymVersion() {
        return this.symVersion;
    }

    private void setSymVersion(String symVersion) {
        this.symVersion = symVersion;
    }

    private SecretKey getSecretKey() {
        return this.secretKey;
    }

    private void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    protected String getKeyStoreName() {
        return this.keyStoreName;
    }

    protected Cipher getSymDecodingCipher() {
        return this.symDecodingCipher;
    }

    protected Cipher getSymEncodingCipher() {
        return this.symEncodingCipher;
    }

    protected Address getLocal_addr() {
        return this.local_addr;
    }

    protected void setLocal_addr(Address local_addr) {
        this.local_addr = local_addr;
    }

    protected Address getKeyServerAddr() {
        return this.keyServerAddr;
    }

    protected void setKeyServerAddr(Address keyServerAddr) {
        this.keyServerAddr = keyServerAddr;
    }

    public static class EncryptHeader
    extends Header
    implements Streamable {
        short type;
        public static final short ENCRYPT = 0;
        public static final short KEY_REQUEST = 1;
        public static final short SERVER_PUBKEY = 2;
        public static final short SECRETKEY = 3;
        public static final short SECRETKEY_READY = 4;
        static final String KEY = "encrypt";
        String version;

        public EncryptHeader() {
        }

        public EncryptHeader(short type) {
            this.type = type;
            this.version = "";
        }

        public EncryptHeader(short type, String version) {
            this.type = type;
            this.version = version;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.version);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.version = (String)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeString(this.version, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.version = Util.readString(in);
        }

        @Override
        public String toString() {
            return "ENCRYPT [type=" + this.type + " version=\"" + this.version + "\"]";
        }

        @Override
        public long size(short v) {
            long retval = 3L;
            if (this.version != null) {
                retval += (long)(this.version.length() + 2);
            }
            return retval;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncryptHeader) {
                boolean res = ((EncryptHeader)obj).getType() == this.type && ((EncryptHeader)obj).getVersion().equals(this.version);
                return res;
            }
            return false;
        }

        public int hashCode() {
            return 0;
        }

        protected short getType() {
            return this.type;
        }

        protected String getVersion() {
            return this.version;
        }
    }
}

