/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.util.BoundedLinkedHashMap;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.protocols.VERIFY_SUSPECT;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.BoundedList;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimerTask;
import java.util.Vector;

public class FD_SOCK
extends Protocol
implements Runnable {
    long get_cache_timeout = 3000L;
    static final long get_cache_retry_timeout = 500L;
    long suspect_msg_interval = 5000L;
    long lastPingSelectionSuspectProcessingTime = 0L;
    int num_tries = 20;
    final Vector members = new Vector(50);
    final List randomMembers = new ArrayList(50);
    volatile View currentView;
    boolean srv_sock_sent = false;
    final Vector pingable_mbrs = new Vector(11);
    final Promise get_cache_promise = new Promise();
    boolean got_cache_from_coord = false;
    Address local_addr = null;
    volatile ServerSocket srv_sock = null;
    InetAddress srv_sock_bind_addr = null;
    volatile ServerSocketHandler srv_sock_handler = null;
    volatile IpAddress srv_sock_addr = null;
    volatile Address ping_dest = null;
    volatile Socket ping_sock = null;
    InputStream ping_input = null;
    volatile Thread pinger_thread = null;
    final Hashtable cache = new Hashtable(11);
    int connectTimeout = 5000;
    int start_port = 1;
    int end_port = 65535;
    Random ran = new Random();
    final Map<Address, Promise> ping_addr_promises = new HashMap<Address, Promise>();
    final Object sock_mutex = new Object();
    boolean socket_closed_in_mutex;
    TimeScheduler timer = null;
    final BroadcastTask bcast_task = new BroadcastTask();
    volatile boolean regular_sock_close = false;
    int num_suspect_events = 0;
    private static final int NORMAL_TERMINATION = 9;
    private static final int PROBE_TERMINATION = 6;
    private static final int ABNORMAL_TERMINATION = -1;
    private static final String name = "FD_SOCK";
    private static final int SETUP_OK = 0;
    private static final int SETUP_FAILED = 1;
    private static final int SETUP_RESELECT = 2;
    BoundedList suspect_history = new BoundedList(20);
    public int normalDisconnectCount;
    public volatile boolean isConnectedToPingDest;
    private boolean isCoordinator;
    private volatile boolean disconnecting;
    private BoundedList sockNotFound = new BoundedList(100);

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 10;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public String getPingableMembers() {
        return this.pingable_mbrs != null ? this.pingable_mbrs.toString() : "null";
    }

    public String getPingDest() {
        return this.ping_dest != null ? this.ping_dest.toString() : "null";
    }

    public int getNumSuspectEventsGenerated() {
        return this.num_suspect_events;
    }

    public String printSuspectHistory() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        String str = props.getProperty("get_cache_timeout");
        if (str != null) {
            this.get_cache_timeout = Long.parseLong(str);
            props.remove("get_cache_timeout");
        }
        if ((str = props.getProperty("suspect_msg_interval")) != null) {
            this.suspect_msg_interval = Long.parseLong(str);
            props.remove("suspect_msg_interval");
        }
        if ((str = props.getProperty("num_tries")) != null) {
            this.num_tries = Integer.parseInt(str);
            props.remove("num_tries");
        }
        if ((str = props.getProperty("start_port")) != null) {
            this.start_port = Integer.parseInt(str);
            props.remove("start_port");
        }
        if ((str = props.getProperty("end_port")) != null) {
            this.end_port = Integer.parseInt(str);
            props.remove("end_port");
        }
        try {
            tmp = System.getProperty("bind.address");
            if (Util.isBindAddressPropertyIgnored()) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        str = tmp != null ? tmp : props.getProperty("srv_sock_bind_addr");
        if (str == null && (str = System.getProperty("gemfire.jg-bind-address")) != null && str.length() == 0) {
            str = null;
        }
        if (str != null) {
            try {
                this.srv_sock_bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal("(srv_sock_bind_addr): host " + str + " not known");
                }
                return false;
            }
            props.remove("srv_sock_bind_addr");
        } else {
            try {
                this.srv_sock_bind_addr = SocketCreator.getLocalHost();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        str = props.getProperty("connect_timeout");
        if (str != null) {
            this.connectTimeout = Integer.parseInt(str);
            props.remove("connect_timeout");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FD_SOCK_FD_SOCKSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void init() throws Exception {
        this.normalDisconnectCount = 0;
        this.srv_sock_handler = new ServerSocketHandler();
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("FD_SOCK.init(): timer == null");
        }
    }

    public static void loadEmergencyClasses() {
        ClientConnectionHandler.loadEmergencyClasses();
    }

    public void emergencyClose() {
        Socket sock;
        Thread thr;
        ServerSocketHandler ssh = this.srv_sock_handler;
        if (ssh != null) {
            ssh.emergencyClose();
        }
        if ((thr = this.pinger_thread) != null) {
            thr.interrupt();
        }
        if ((sock = this.ping_sock) != null) {
            try {
                sock.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        Exception e;
        this.bcast_task.removeAll();
        Thread t = this.pinger_thread;
        this.pinger_thread = null;
        if (t != null && t.isAlive()) {
            this.regular_sock_close = true;
            t.interrupt();
            this.sendPingTermination(true);
            this.teardownPingSocket();
        }
        boolean normalShutdown = (e = ((JChannel)this.stack.getChannel()).getCloseException()) == null;
        this.stopServerSocket(normalShutdown);
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 3: {
                this.passUp(evt);
                this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
                if (!this.got_cache_from_coord) {
                    this.getCacheFromCoordinator();
                    this.got_cache_from_coord = true;
                }
                if (this.stack.jgmm.getDistributionConfig().getDisableTcp() || Boolean.getBoolean("gemfire.disable-random-health-checks")) break;
                this.timer.add(new RandomPingTask());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                FdHeader hdr = (FdHeader)msg.removeHeader(name);
                if (hdr == null) break;
                switch (hdr.type) {
                    case 10: {
                        int i;
                        if (hdr.mbrs.contains(this.local_addr) && !this.srv_sock_handler.beSick) {
                            Message rsp = new Message(msg.getSrc(), this.local_addr, null);
                            rsp.putHeader("VERIFY_SUSPECT", new VERIFY_SUSPECT.VerifyHeader(2, this.local_addr));
                            this.passDown(new Event(1, rsp));
                            hdr.mbrs.remove(this.local_addr);
                            if (hdr.mbrs.size() == 0) {
                                return;
                            }
                        }
                        if (this.disconnecting || this.stack.getChannel().closing()) break;
                        View cur = this.currentView;
                        if (hdr.vid != null && cur != null && hdr.vid.compareTo(cur.getVid()) < 0 && !this.isInMembership(msg.getSrc())) {
                            Message notMbr = new Message();
                            this.log.getInternalLogWriter().info(JGroupsStrings.FD_SOCK_RECEIVED_SUSPECT_NOTIFICATION_FROM_NONMEMBER_0_USING_VIEW_ID_1_SENDING_NOT_MEMBER_RESPONSE, new Object[]{msg.getSrc(), hdr.vid});
                            FdHeader fhdr = new FdHeader(15);
                            notMbr.putHeader(this.getName(), fhdr);
                            notMbr.setDest(msg.getSrc());
                            this.passDown(new Event(1, notMbr));
                            break;
                        }
                        String reason = "";
                        ReasonHeader rhdr = (ReasonHeader)msg.getHeader("REASON");
                        if (rhdr != null) {
                            reason = " Reason=" + rhdr.cause;
                        }
                        boolean anyMembers = false;
                        for (i = 0; i < hdr.mbrs.size(); ++i) {
                            if (!this.members.contains(hdr.mbrs.elementAt(i)) || this.bcast_task.isSuspectedMember((Address)hdr.mbrs.elementAt(i))) continue;
                            anyMembers = true;
                            break;
                        }
                        if (anyMembers) {
                            this.log.getInternalLogWriter().info(JGroupsStrings.FD_RECEIVED_SUSPECT_NOTIFICATION_FOR_MEMBERS_0_FROM_1_2, new Object[]{hdr.mbrs, msg.getSrc(), reason});
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("[SUSPECT] hdr=" + hdr);
                        }
                        for (i = 0; i < hdr.mbrs.size(); ++i) {
                            Address mbr = (Address)hdr.mbrs.elementAt(i);
                            this.passUp(new Event(9, new SuspectMember(msg.getSrc(), mbr)));
                            this.passDown(new Event(9, new SuspectMember(msg.getSrc(), mbr)));
                            if (this.members.contains(mbr) || !((IpAddress)this.local_addr).splitBrainEnabled()) continue;
                            this.passUp(new Event(1006, mbr));
                        }
                        break;
                    }
                    case 20: {
                        Address suspectMbr = hdr.mbr;
                        this.checkSuspect(suspectMbr, null);
                        return;
                    }
                    case 11: {
                        if (this.local_addr != null && this.local_addr.equals(msg.getSrc())) {
                            return;
                        }
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.FD_SOCK_HDRMBR_IS_NULL);
                            }
                            return;
                        }
                        if (trace) {
                            this.log.trace("who-has-sock " + hdr.mbr);
                        }
                        if (this.local_addr != null && this.local_addr.equals(hdr.mbr) && this.srv_sock_addr != null) {
                            this.sendIHaveSockMessage(msg.getSrc(), this.local_addr, this.srv_sock_addr);
                            return;
                        }
                        if (!this.cache.containsKey(hdr.mbr)) break;
                        this.sendIHaveSockMessage(msg.getSrc(), hdr.mbr, (IpAddress)this.cache.get(hdr.mbr));
                        break;
                    }
                    case 12: {
                        Promise ping_addr_promise;
                        if (hdr.mbr == null || hdr.sock_addr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.FD_SOCK_I_HAVE_SOCK_HDRMBR_IS_NULL_OR_HDRSOCK_ADDR__NULL);
                            }
                            return;
                        }
                        this.cache.put(hdr.mbr, hdr.sock_addr);
                        BoundedList mbr = this.sockNotFound;
                        synchronized (mbr) {
                            this.sockNotFound.removeElement(hdr.mbr);
                        }
                        if (trace) {
                            this.log.trace("i-have-sock: " + hdr.mbr + " --> " + hdr.sock_addr + " (cache is " + this.cache + ')');
                        }
                        Map<Address, Promise> map = this.ping_addr_promises;
                        synchronized (map) {
                            ping_addr_promise = this.ping_addr_promises.get(hdr.mbr);
                        }
                        if (ping_addr_promise == null) break;
                        ping_addr_promise.setResult(hdr.sock_addr);
                        break;
                    }
                    case 13: {
                        if (hdr.mbr == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.FD_SOCK_GET_CACHE_HDRMBR__NULL);
                            }
                            return;
                        }
                        FdHeader rsphdr = new FdHeader(14);
                        rsphdr.cachedAddrs = (Hashtable)this.cache.clone();
                        if (trace) {
                            this.log.trace("FD_SOCK: sending cache to " + hdr.mbr);
                        }
                        msg = new Message(hdr.mbr, null, null);
                        msg.putHeader(name, rsphdr);
                        msg.isHighPriority = true;
                        this.passDown(new Event(1, msg));
                        break;
                    }
                    case 14: {
                        if (hdr.cachedAddrs == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.FD_SOCK_GET_CACHE_RSP_CACHE_IS_NULL);
                            }
                            return;
                        }
                        this.cache.putAll(hdr.cachedAddrs);
                        if (trace) {
                            this.log.trace("got cache from " + msg.getSrc() + ": cache is " + this.cache);
                        }
                        BoundedList boundedList = this.sockNotFound;
                        synchronized (boundedList) {
                            for (Object key2 : hdr.cachedAddrs.keySet()) {
                                this.sockNotFound.removeElement(key2);
                            }
                        }
                        this.get_cache_promise.setResult(hdr.cachedAddrs);
                        break;
                    }
                    case 15: {
                        this.passUp(new Event(46, new ForcedDisconnectException(JGroupsStrings.FD_SOCK_THIS_MEMBER_HAS_BEEN_FORCED_OUT_OF_THE_DISTRIBUTED_SYSTEM_BECAUSE_IT_DID_NOT_RESPOND_WITHIN_MEMBERTIMEOUT_MILLISECONDS_FD_SOCK.toLocalizedString())));
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                Address mbr = (Address)evt.getArg();
                this.log.getInternalLogWriter().info(JGroupsStrings.FD_SOCK_FAILURE_DETECTION_RECEIVED_NOTIFICATION_THAT_0_IS_NO_LONGER_SUSPECT, mbr);
                FD_SOCK fD_SOCK = this;
                synchronized (fD_SOCK) {
                    Cloneable cloneable = this.pingable_mbrs;
                    synchronized (cloneable) {
                        if (this.bcast_task.isSuspectedMember(mbr)) {
                            this.bcast_task.removeSuspectedMember((Address)evt.getArg());
                            Thread thr = this.pinger_thread;
                            if (thr != null && thr.isAlive()) {
                                this.interruptPingerThread();
                                this.startPingerThread();
                            } else {
                                this.startPingerThread();
                            }
                        }
                    }
                    cloneable = this.sockNotFound;
                    synchronized (cloneable) {
                        this.sockNotFound.removeElement(mbr);
                    }
                }
                this.passDown(evt);
                break;
            }
            case 1005: {
                if (this.stack.getChannel().closing()) break;
                List gmsSuspects = (List)evt.getArg();
                for (Address suspectMbr : gmsSuspects) {
                    this.checkSuspect(suspectMbr, "Did not respond to a view change");
                }
                return;
            }
            case 2: {
                this.disconnecting = false;
                this.srv_sock = Util.createServerSocket(this.srv_sock_bind_addr, this.start_port, this.end_port);
                this.srv_sock_addr = new IpAddress(this.srv_sock_bind_addr, this.srv_sock.getLocalPort());
                this.passDown(evt);
                this.startServerSocket();
                break;
            }
            case 3: {
                this.passDown(evt);
                break;
            }
            case 1007: {
                this.disconnecting = true;
                this.passDown(evt);
                break;
            }
            case 6: {
                this.passDown(evt);
                FD_SOCK fD_SOCK = this;
                synchronized (fD_SOCK) {
                    View v = (View)evt.getArg();
                    List suspectMbr = this.members;
                    synchronized (suspectMbr) {
                        this.currentView = v;
                        this.members.removeAllElements();
                        this.members.addAll(v.getMembers());
                    }
                    suspectMbr = this.randomMembers;
                    synchronized (suspectMbr) {
                        this.randomMembers.clear();
                        this.randomMembers.addAll(v.getMembers());
                        Collections.shuffle(this.randomMembers);
                    }
                    this.bcast_task.adjustSuspectedMembers(this.members);
                    suspectMbr = this.pingable_mbrs;
                    synchronized (suspectMbr) {
                        Address coord = v.getCreator();
                        this.isCoordinator = this.local_addr != null && coord != null && this.local_addr.equals(coord);
                        this.pingable_mbrs.removeAllElements();
                        this.pingable_mbrs.addAll(this.members);
                    }
                    Enumeration e = this.cache.keys();
                    while (e.hasMoreElements()) {
                        Address mbr = (Address)e.nextElement();
                        if (this.members.contains(mbr)) continue;
                        this.cache.remove(mbr);
                    }
                    if (this.members.size() > 1) {
                        FD_SOCK fD_SOCK2 = this;
                        synchronized (fD_SOCK2) {
                            Thread thr = this.pinger_thread;
                            if (thr != null && thr.isAlive()) {
                                Address tmp_ping_dest = this.determinePingDest();
                                if (this.ping_dest != null && tmp_ping_dest != null && !this.ping_dest.equals(tmp_ping_dest)) {
                                    this.interruptPingerThread();
                                    this.startPingerThread();
                                }
                            } else {
                                this.startPingerThread();
                            }
                        }
                    } else {
                        this.ping_dest = null;
                        this.interruptPingerThread();
                    }
                    break;
                }
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInMembership(Address sender) {
        if (this.pingable_mbrs != null) {
            Vector vector = this.pingable_mbrs;
            synchronized (vector) {
                if (this.isCoordinator) {
                    HashSet m = new HashSet(this.pingable_mbrs);
                    return m.contains(sender);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        log_addr = null;
        max_fetch_tries = this.connectTimeout * 2 / 4000;
        if (max_fetch_tries < 1) {
            max_fetch_tries = 1;
        }
        max_fetch_tries_reset = max_fetch_tries;
        if (FD_SOCK.trace) {
            this.log.trace("pinger_thread started");
        }
        if (!this.got_cache_from_coord) {
            this.getCacheFromCoordinator();
            this.got_cache_from_coord = true;
        }
        if (!this.srv_sock_sent && this.srv_sock_addr != null) {
            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
            this.srv_sock_sent = true;
        }
        block29: while (true) lbl-1000:
        // 13 sources

        {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) {
                if (!this.log.isDebugEnabled()) ** break;
                this.log.info("FD_SOCK interrupted - pinger thread exiting");
                ** break;
            }
            var6_6 = this;
            synchronized (var6_6) {
                if (this.pinger_thread == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.info("FD_SOCK pinger_thread is null - pinger thread exiting");
                    }
                    ** break;
                }
            }
            var6_6 = this.pingable_mbrs;
            synchronized (var6_6) {
                this.ping_dest = cached_ping_dest = this.determinePingDest();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("determinePingDest()=" + cached_ping_dest + ", pingable_mbrs=" + this.pingable_mbrs + ", suspects=" + this.bcast_task.suspected_mbrs);
                }
                if (log_addr != this.ping_dest && this.ping_dest != null) {
                    log_addr = this.ping_dest;
                    this.log.getInternalLogWriter().info(JGroupsStrings.FD_SOCK_WATCHING_0, log_addr);
                }
            }
            if (cached_ping_dest == null) {
                if (!this.log.isInfoEnabled()) ** break;
                this.log.info("FD_SOCK unable to determine new ping_dest - pinger thread exiting");
                ** break;
            }
            ping_addr = this.fetchPingAddress(cached_ping_dest);
            if (ping_addr == null) {
                if (this.log.isTraceEnabled() && this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.FD_SOCK_SOCKET_ADDRESS_FOR__0__COULD_NOT_BE_FETCHED_RETRYING, cached_ping_dest);
                }
                if (--max_fetch_tries <= 0) {
                    this.suspect(cached_ping_dest, false, "Unable to determine failure detection socket for this member");
                    max_fetch_tries = max_fetch_tries_reset;
                    continue;
                }
                try {
                    Util.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (!this.log.isInfoEnabled()) ** break;
                    this.log.info("FD_SOCK interrupted - pinger thread exiting");
                    ** break;
                }
            }
            if (Thread.currentThread().isInterrupted()) ** break;
            switch (this.setupPingSocket(ping_addr, cached_ping_dest)) {
                case 1: {
                    if (this.log.isDebugEnabled()) {
                        this.log.trace("ping setup failed.  member " + cached_ping_dest);
                    }
                    if (this.stack.getChannel().closing()) break;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("could not create socket to " + this.ping_dest + "; suspecting " + this.ping_dest);
                    }
                    this.suspect(cached_ping_dest, false, JGroupsStrings.FD_SOCK_COULD_NOT_SET_UP_PING_SOCKET.toLocalizedString());
                    continue block29;
                }
                case 2: {
                    continue block29;
                }
                case 0: {
                    this.isConnectedToPingDest = true;
                }
            }
            if (this.stack.getChannel().closing()) ** break;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ping_dest=" + cached_ping_dest + ", ping_sock=" + this.ping_sock + ", cache=" + this.cache);
            }
            try {
                if (this.ping_input == null) ** GOTO lbl-1000
                c = this.ping_input.read();
                switch (c) {
                    case 9: {
                        ++this.normalDisconnectCount;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("peer closed socket normally");
                        }
                        this.bcast_task.addDepartedMember(cached_ping_dest);
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "Member " + cached_ping_dest + " shut down with normal termination.");
                        this.passUp(new Event(1009, cached_ping_dest));
                        this.teardownPingSocket();
                    }
                    case 6: {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("peer closed socket with probe notification");
                        }
                        this.teardownPingSocket();
                        ++this.normalDisconnectCount;
                        this.ping_sock.getOutputStream().flush();
                        this.ping_sock.shutdownOutput();
                    }
                    case -1: {
                        this.handleSocketClose(null);
                    }
                    ** default:
lbl104:
                    // 1 sources

                }
            }
            catch (IOException ex) {
                this.handleSocketClose(ex);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable catch_all_the_rest) {
                SystemFailure.checkFailure();
                this.log.error(JGroupsStrings.FD_SOCK_EXCEPTION, catch_all_the_rest);
            }
            finally {
                this.isConnectedToPingDest = false;
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
lbl119:
        // 9 sources

        if (this.log.isDebugEnabled()) {
            this.log.debug("pinger thread terminated");
        }
        var6_12 = this;
        synchronized (var6_12) {
            this.pinger_thread = null;
        }
    }

    public void clearAddressCache() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSuspect(Address suspectMbr, String reason) {
        if (this.bcast_task.isDepartedMember(suspectMbr)) {
            return true;
        }
        if (this.bcast_task.isSuspectedMember(suspectMbr)) {
            return false;
        }
        IpAddress sockAddr = this.fetchPingAddress(suspectMbr);
        boolean isFdSockServer = true;
        if (sockAddr == null) {
            boolean notFound;
            BoundedList boundedList = this.sockNotFound;
            synchronized (boundedList) {
                notFound = this.sockNotFound.contains(suspectMbr);
            }
            if (notFound) {
                if (!this.disconnecting && !this.stack.getChannel().closing()) {
                    this.suspect(suspectMbr, false, JGroupsStrings.FD_SOCK_UNABLE_TO_CHECK_STATE_OF_UNRESPONSIVE_MEMBER_0.toLocalizedString(suspectMbr));
                }
            } else {
                this.log.getInternalLogWriter().warning(JGroupsStrings.FD_SOCK_UNABLE_TO_CHECK_STATE_OF_UNRESPONSIVE_MEMBER_0, suspectMbr);
                boundedList = this.sockNotFound;
                synchronized (boundedList) {
                    this.sockNotFound.add(suspectMbr);
                }
            }
            return true;
        }
        return this.checkSuspect(suspectMbr, sockAddr, reason, isFdSockServer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkSuspect(Address mbr, IpAddress dest, String reason, boolean isFdSockServer, boolean initiateSuspectProcessing) {
        boolean noProbeResponse;
        boolean connectSucceeded;
        Socket sock;
        block40: {
            if (this.disconnecting || this.stack.getChannel().closing()) {
                return true;
            }
            if (this.bcast_task.isDepartedMember(mbr)) {
                return true;
            }
            if (this.bcast_task.isSuspectedMember(mbr)) {
                return false;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Attempting to connect to member " + mbr + " at address " + dest + " reason: " + reason);
            }
            sock = null;
            connectSucceeded = false;
            noProbeResponse = false;
            try {
                SocketCreator sc = SocketCreator.getDefaultInstance();
                boolean useSSL = !isFdSockServer && sc.useSSL();
                sock = sc.connect(dest.getIpAddress(), dest.getPort(), this.connectTimeout, new ConnectTimerTask(), false, -1, useSSL);
                if (sock == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt to connect to " + mbr + " at address " + dest + " failed.  connect() returned null");
                    }
                    connectSucceeded = false;
                    break block40;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Attempt to connect to " + mbr + " at address " + dest + " succeeded.");
                }
                connectSucceeded = true;
                noProbeResponse = false;
                if (isFdSockServer) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Attempt to read probe response from " + mbr);
                    }
                    sock.setSoLinger(true, this.connectTimeout);
                    sock.getOutputStream().write(6);
                    sock.getOutputStream().flush();
                    sock.shutdownOutput();
                    sock.setSoTimeout(this.connectTimeout);
                    try {
                        int response = sock.getInputStream().read();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Attempt to read probe response from " + mbr + " returned " + response);
                        }
                        noProbeResponse = response != 6;
                    }
                    catch (SocketTimeoutException e) {
                        noProbeResponse = true;
                    }
                    if (noProbeResponse) {
                        noProbeResponse = false;
                        if (mbr.getVersionObject() != null && mbr.getVersionObject().compareTo(Version.GFE_81) >= 0) {
                            noProbeResponse = true;
                        }
                    }
                }
                sock.close();
            }
            catch (IOException e) {
                if (sock != null && !sock.isClosed()) {
                    try {
                        sock.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if ((!connectSucceeded || noProbeResponse) && initiateSuspectProcessing) {
                    this.suspect(mbr, false, reason == null ? JGroupsStrings.FD_SOCK_UNABLE_TO_CONNECT_TO_THIS_MEMBER.toLocalizedString() : reason);
                }
            }
            catch (IllegalStateException e2) {
                if (sock != null && !sock.isClosed()) {
                    try {
                        sock.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if ((!connectSucceeded || noProbeResponse) && initiateSuspectProcessing) {
                    this.suspect(mbr, false, reason == null ? JGroupsStrings.FD_SOCK_UNABLE_TO_CONNECT_TO_THIS_MEMBER.toLocalizedString() : reason);
                }
                {
                    catch (Throwable throwable) {
                        if (sock != null && !sock.isClosed()) {
                            try {
                                sock.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        if ((!connectSucceeded || noProbeResponse) && initiateSuspectProcessing) {
                            this.suspect(mbr, false, reason == null ? JGroupsStrings.FD_SOCK_UNABLE_TO_CONNECT_TO_THIS_MEMBER.toLocalizedString() : reason);
                        }
                        throw throwable;
                    }
                }
            }
        }
        if (sock != null && !sock.isClosed()) {
            try {
                sock.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if ((!connectSucceeded || noProbeResponse) && initiateSuspectProcessing) {
            this.suspect(mbr, false, reason == null ? JGroupsStrings.FD_SOCK_UNABLE_TO_CONNECT_TO_THIS_MEMBER.toLocalizedString() : reason);
        }
        if (this.log.isDebugEnabled()) {
            if (isFdSockServer && noProbeResponse) {
                this.log.debug("FD_SOCK found that " + mbr + " is accepting connections on " + dest.getIpAddress() + ":" + dest.getPort() + " but did not return a probe response");
            } else {
                this.log.debug("FD_SOCK found that " + mbr + (connectSucceeded ? " is " : " is not ") + "accepting connections on " + dest.getIpAddress() + ":" + dest.getPort());
            }
        }
        if (isFdSockServer && noProbeResponse) {
            return false;
        }
        return connectSucceeded;
    }

    void handleSocketClose(Exception ex) {
        this.teardownPingSocket();
        if (!this.regular_sock_close) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("peer " + this.ping_dest + " closed socket (" + (ex != null ? ex.getClass().getName() : "eof") + ')');
            }
            this.suspect(this.ping_dest, true, "Socket was not closed nicely");
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("socket to " + this.ping_dest + " was reset");
            }
            this.regular_sock_close = false;
        }
    }

    synchronized void startPingerThread() {
        Thread t = this.pinger_thread;
        if (t == null || !t.isAlive()) {
            t = new Thread(GemFireTracer.GROUP, this, "FD_SOCK Ping thread");
            t.setDaemon(true);
            t.start();
            this.pinger_thread = t;
        }
    }

    synchronized void sendPingTermination(boolean stopping) {
        block6: {
            Socket ps = this.ping_sock;
            if (ps != null && !ps.isClosed()) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.trace("sending normal FD_SOCK ping termination");
                    }
                    if (stopping) {
                        ps.getOutputStream().write(9);
                    } else {
                        ps.getOutputStream().write(6);
                    }
                    ps.getOutputStream().flush();
                }
                catch (IOException ie) {
                    if (!trace) break block6;
                    this.log.trace("FD_SOCK io exception sending ping termination", ie);
                }
            }
        }
    }

    synchronized void interruptPingerThread() {
        Thread pt = this.pinger_thread;
        if (pt != null && pt.isAlive()) {
            this.regular_sock_close = true;
            this.sendPingTermination(false);
            this.teardownPingSocket();
            if (this.log.isDebugEnabled()) {
                this.log.debug("'Interrupted' pinger thread");
            }
        }
    }

    void startServerSocket() {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.start();
        }
    }

    void stopServerSocket(boolean normalTermination) {
        if (this.srv_sock_handler != null) {
            this.srv_sock_handler.stop(normalTermination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setupPingSocket(IpAddress dest, Address mbr) {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.socket_closed_in_mutex) {
                this.socket_closed_in_mutex = false;
                return 2;
            }
            if (dest == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.FD_SOCK_DESTINATION_ADDRESS_IS_NULL);
                }
                return 2;
            }
            try {
                this.ping_sock = new Socket();
                InetSocketAddress address = new InetSocketAddress(dest.getIpAddress(), dest.getPort());
                this.ping_sock.connect(address, this.connectTimeout);
                this.ping_sock.setSoLinger(true, this.connectTimeout);
                this.ping_input = this.ping_sock.getInputStream();
                return 0;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                return 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void teardownPingSocket() {
        Object object = this.sock_mutex;
        synchronized (object) {
            if (this.ping_sock != null) {
                final Socket old_ping_sock = this.ping_sock;
                final InputStream old_ping_input = this.ping_input;
                new Thread(GemFireTracer.GROUP, "GemFire FD_SOCK Ping Socket Teardown Thread"){

                    @Override
                    public void run() {
                        try {
                            FD_SOCK.this.socket_closed_in_mutex = true;
                            old_ping_sock.shutdownInput();
                            old_ping_sock.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (old_ping_input != null) {
                            try {
                                old_ping_input.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }.start();
                this.ping_sock = null;
                this.ping_input = null;
            }
        }
    }

    void getCacheFromCoordinator() {
        Thread cacheThread = new Thread(GemFireTracer.GROUP, "FD_SOCK cache initialization"){

            @Override
            public void run() {
                Hashtable result = null;
                FD_SOCK.this.get_cache_promise.reset();
                for (int attempts = FD_SOCK.this.num_tries; attempts > 0; --attempts) {
                    Address coord = FD_SOCK.this.determineCoordinator();
                    if (coord != null) {
                        if (coord.equals(FD_SOCK.this.local_addr)) {
                            if (FD_SOCK.this.members.size() > 1) {
                                coord = (Address)FD_SOCK.this.members.elementAt(1);
                            } else {
                                if (FD_SOCK.this.log.isDebugEnabled()) {
                                    FD_SOCK.this.log.debug("first member; cache is empty");
                                }
                                return;
                            }
                        }
                        if (Protocol.trace) {
                            FD_SOCK.this.log.trace("FD_SOCK requesting cache from " + coord);
                        }
                        FdHeader hdr = new FdHeader(13);
                        hdr.mbr = FD_SOCK.this.local_addr;
                        Message msg = new Message(coord, null, null);
                        msg.putHeader(FD_SOCK.name, hdr);
                        msg.isHighPriority = true;
                        FD_SOCK.this.passDown(new Event(1, msg));
                        result = (Hashtable)FD_SOCK.this.get_cache_promise.getResult(FD_SOCK.this.get_cache_timeout);
                        if (result != null) {
                            return;
                        }
                    }
                    try {
                        Util.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            }
        };
        cacheThread.setDaemon(true);
        cacheThread.start();
    }

    public boolean isDisconnecting() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        return sys == null || sys.isDisconnecting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Address suspected_mbr, boolean abnormalTermination, String reason) {
        if (suspected_mbr == null) {
            return;
        }
        if (this.disconnecting || this.stack.getChannel().closing()) {
            return;
        }
        if (suspected_mbr.equals(this.local_addr)) {
            return;
        }
        if (this.bcast_task.isSuspectedMember(suspected_mbr)) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("not resuspecting suspected member " + suspected_mbr);
            }
            return;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if ((long)suspected_mbr.getBirthViewId() < this.currentView.getVid().getId() && !this.members.contains(suspected_mbr)) {
                if (this.log.getInternalLogWriter().fineEnabled()) {
                    this.log.getInternalLogWriter().fine("not suspecting departed member " + suspected_mbr);
                }
                return;
            }
        }
        if (this.bcast_task.isDepartedMember(suspected_mbr)) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("not suspecting departed member " + suspected_mbr);
            }
            return;
        }
        if (!this.checkSuspect(this.local_addr, "checking that this process can connect to itself")) {
            return;
        }
        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "suspecting member " + suspected_mbr);
        FdHeader hdr = new FdHeader(10);
        hdr.abnormalTermination = abnormalTermination;
        hdr.mbrs = new Vector(1);
        hdr.mbrs.addElement(suspected_mbr);
        View cur = this.currentView;
        if (cur == null) {
            return;
        }
        hdr.vid = cur.getVid();
        this.sendSuspectMessage(hdr, reason);
        this.bcast_task.addSuspectedMember(suspected_mbr);
        if (this.stats) {
            ++this.num_suspect_events;
            this.suspect_history.add(suspected_mbr);
        }
    }

    void sendSuspectMessage(FdHeader hdr, String reason) {
        View cur = this.currentView;
        ReasonHeader rhdr = new ReasonHeader(reason);
        if (this.isDisconnecting()) {
            return;
        }
        Message suspect_msg = new Message();
        suspect_msg.putHeader(name, hdr);
        suspect_msg.putHeader("REASON", rhdr);
        if (cur.getMembers().size() < 5) {
            if (trace) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "sending suspect message with view " + cur);
            }
            this.passDown(new Event(1, suspect_msg));
        } else {
            if (trace) {
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "sending suspect message to eligible coordinators and one random member");
            }
            int count = 0;
            Vector mbrs = cur.getMembers();
            Vector<Address> notSentTo = new Vector<Address>(mbrs.size());
            for (Address target : mbrs) {
                boolean isMe = target.equals(this.local_addr);
                if (isMe || target.preferredForCoordinator()) {
                    suspect_msg.setDest(target);
                    this.passDown(new Event(1, suspect_msg));
                    ++count;
                    suspect_msg = new Message();
                    suspect_msg.putHeader(name, hdr);
                    suspect_msg.putHeader("REASON", rhdr);
                    continue;
                }
                notSentTo.add(target);
            }
            if (notSentTo.size() > 0) {
                int mbrIdx = this.ran.nextInt(notSentTo.size());
                Address mbr = (Address)notSentTo.elementAt(mbrIdx);
                suspect_msg.setDest(mbr);
                this.passDown(new Event(1, suspect_msg));
            }
        }
    }

    void broadcastWhoHasSockMessage(Address mbr) {
        if (this.local_addr != null && mbr != null && this.log.isDebugEnabled()) {
            this.log.debug("[" + this.local_addr + "]: who-has " + mbr);
        }
        Message msg = new Message();
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        msg.putHeader(name, hdr);
        this.passDown(new Event(1, msg));
    }

    void sendIHaveSockMessage(Address dst, Address mbr, IpAddress addr) {
        Message msg = new Message(dst, null, null);
        FdHeader hdr = new FdHeader(12);
        hdr.mbr = mbr;
        hdr.sock_addr = addr;
        msg.putHeader(name, hdr);
        msg.isHighPriority = true;
        if (trace) {
            this.log.trace("hdr=" + hdr);
        }
        this.passDown(new Event(1, msg));
    }

    IpAddress fetchPingAddress(Address mbr) {
        return this.fetchPingAddress(mbr, this.connectTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpAddress fetchPingAddress(Address mbr, long timeout) {
        Promise ping_addr_promise;
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.FD_SOCK_MBR__NULL);
            }
            return null;
        }
        IpAddress ret = (IpAddress)this.cache.get(mbr);
        if (ret != null || timeout == 0L) {
            return ret;
        }
        try {
            Util.sleep(300L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        ret = (IpAddress)this.cache.get(mbr);
        if (ret != null) {
            return ret;
        }
        Map<Address, Promise> map = this.ping_addr_promises;
        synchronized (map) {
            ping_addr_promise = this.ping_addr_promises.get(mbr);
            if (ping_addr_promise == null) {
                ping_addr_promise = new Promise();
                this.ping_addr_promises.put(mbr, ping_addr_promise);
            }
        }
        ping_addr_promise.reset();
        Message ping_addr_req = new Message(mbr, null, null);
        FdHeader hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.passDown(new Event(1, ping_addr_req));
        ping_addr_req = new Message(null, null, null);
        hdr = new FdHeader(11);
        hdr.mbr = mbr;
        ping_addr_req.putHeader(name, hdr);
        this.passDown(new Event(1, ping_addr_req));
        ret = (IpAddress)ping_addr_promise.getResult(timeout);
        this.ping_addr_promises.remove(mbr);
        if (ret != null) {
            this.cache.put(mbr, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determinePingDest() {
        boolean departedMember;
        boolean suspectMbr;
        ArrayList mbrs = null;
        Vector vector = this.pingable_mbrs;
        synchronized (vector) {
            mbrs = new ArrayList(this.pingable_mbrs);
        }
        if (mbrs.size() < 2 || this.local_addr == null) {
            return null;
        }
        int myIndex = mbrs.indexOf(this.local_addr);
        if (myIndex < 0) {
            return null;
        }
        int neighborIndex = myIndex;
        boolean wrapped = false;
        Address neighborAddr = null;
        Vector<Address> skippedMbrs = null;
        do {
            suspectMbr = false;
            if (++neighborIndex > mbrs.size() - 1) {
                neighborIndex = 0;
                wrapped = true;
            }
            if (wrapped && neighborIndex == myIndex) {
                neighborAddr = null;
                break;
            }
            neighborAddr = (Address)mbrs.get(neighborIndex);
            suspectMbr = this.bcast_task.isSuspectedMember(neighborAddr);
            departedMember = this.bcast_task.isDepartedMember(neighborAddr);
            if (!suspectMbr) continue;
            if (skippedMbrs == null) {
                skippedMbrs = new Vector<Address>();
            }
            skippedMbrs.add(neighborAddr);
        } while (suspectMbr || departedMember);
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastPingSelectionSuspectProcessingTime + this.suspect_msg_interval) {
            this.lastPingSelectionSuspectProcessingTime = currentTime;
            if (skippedMbrs != null && !this.disconnecting && !this.stack.getChannel().closing()) {
                FdHeader hdr = new FdHeader(10);
                hdr.mbrs = skippedMbrs;
                if (this.currentView != null) {
                    hdr.vid = this.currentView.getVid();
                }
                for (IpAddress dest : mbrs) {
                    if (!dest.preferredForCoordinator()) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("determinePingDest sending suspect message to " + dest + " suspects: " + skippedMbrs);
                    }
                    Message suspect_msg = new Message();
                    suspect_msg.setDest(dest);
                    suspect_msg.putHeader(name, hdr);
                    this.passDown(new Event(1, suspect_msg));
                }
            }
        }
        return neighborAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address determineCoordinator() {
        Vector vector = this.members;
        synchronized (vector) {
            View cur = this.currentView;
            if (cur == null) {
                return null;
            }
            return cur.getCoordinator();
        }
    }

    public void beSick() {
        if (!this.srv_sock_handler.beSick) {
            this.srv_sock_handler.beSick = true;
            this.stopServerSocket(false);
            FdHeader hdr = new FdHeader(10);
            hdr.mbrs = new Vector();
            hdr.mbrs.add(this.local_addr);
            if (this.currentView != null) {
                hdr.vid = this.currentView.getVid();
            }
            Message suspect_msg = new Message();
            suspect_msg.putHeader(name, hdr);
            this.passDown(new Event(1, suspect_msg));
        }
    }

    public void beHealthy() {
        this.srv_sock_handler.beSick = false;
        this.srv_sock = Util.createServerSocket(this.srv_sock_addr.getIpAddress(), this.srv_sock_addr.getPort(), 65535);
        if (this.srv_sock_addr.getPort() != this.srv_sock.getLocalPort()) {
            this.sendIHaveSockMessage(null, this.local_addr, this.srv_sock_addr);
        }
        this.srv_sock_addr = new IpAddress(this.srv_sock_bind_addr, this.srv_sock.getLocalPort());
        this.startServerSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address getRandomPingDest() {
        int resultIndex;
        ArrayList mbrs;
        Address current_dest = this.ping_dest;
        List list = this.randomMembers;
        synchronized (list) {
            mbrs = new ArrayList(this.randomMembers);
        }
        if (mbrs.size() < 5 || this.local_addr == null) {
            return null;
        }
        int myIndex = mbrs.indexOf(this.local_addr);
        if (myIndex < 0) {
            return null;
        }
        mbrs.remove(myIndex);
        int startIndex = resultIndex = new Random().nextInt(mbrs.size());
        boolean wrapped = false;
        Address resultAddr = null;
        do {
            if (++resultIndex > mbrs.size() - 1) {
                resultIndex = 0;
                wrapped = true;
            }
            if (!wrapped || resultIndex <= startIndex) continue;
            resultAddr = null;
            break;
        } while (this.bcast_task.isSuspectedMember(resultAddr = (Address)mbrs.get(resultIndex)) || this.bcast_task.isDepartedMember(resultAddr));
        return resultAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address getSequentialPingDest(Address fromPd) {
        int lastIndex;
        ArrayList mbrs;
        Vector vector = this.pingable_mbrs;
        synchronized (vector) {
            mbrs = new ArrayList(this.pingable_mbrs);
        }
        mbrs.remove(this.local_addr);
        if (mbrs.size() < 2) {
            return null;
        }
        int neighborIndex = lastIndex = mbrs.indexOf(fromPd);
        boolean wrapped = false;
        Address neighborAddr = null;
        do {
            if (++neighborIndex > mbrs.size() - 1) {
                neighborIndex = 0;
                wrapped = true;
            }
            if (!wrapped || neighborIndex != lastIndex) continue;
            neighborAddr = null;
            break;
        } while (this.bcast_task.isSuspectedMember(neighborAddr = (Address)mbrs.get(neighborIndex)) || this.bcast_task.isDepartedMember(neighborAddr));
        return neighborAddr;
    }

    class ConnectTimerTask
    extends TimerTask
    implements SocketCreator.ConnectionWatcher {
        Socket watchedSocket;
        volatile boolean cancelled;

        ConnectTimerTask() {
        }

        @Override
        public void beforeConnect(Socket sock) {
            this.watchedSocket = sock;
            FD_SOCK.this.stack.jgmm.getTimer().schedule((TimerTask)this, FD_SOCK.this.connectTimeout);
        }

        @Override
        public void afterConnect(Socket sock) {
            this.cancelled = true;
            this.cancel();
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                this.cancel();
                try {
                    this.watchedSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class BroadcastTask
    implements TimeScheduler.Task {
        final Vector suspected_mbrs = new Vector(7);
        final Map departedMembers = new BoundedLinkedHashMap(1000);
        boolean stopped = false;
        boolean added = false;

        protected BroadcastTask() {
        }

        public synchronized void addDepartedMember(Address mbr) {
            long now = System.currentTimeMillis();
            Iterator it = this.departedMembers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Long birthtime = (Long)entry.getValue();
                if (birthtime + (long)FD_SOCK.this.stack.jgmm.getShunnedMemberTimeout() >= now) continue;
                it.remove();
            }
            this.departedMembers.put(mbr, now);
        }

        public boolean isDepartedMember(Address addr) {
            boolean stillDeparted;
            Long birthtime = (Long)this.departedMembers.get(addr);
            if (birthtime == null) {
                return false;
            }
            long departedExpiryTime = birthtime + (long)FD_SOCK.this.stack.jgmm.getDistributionConfig().getMemberTimeout();
            boolean bl = stillDeparted = departedExpiryTime > System.currentTimeMillis();
            if (!stillDeparted) {
                this.departedMembers.remove(addr);
            }
            return stillDeparted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSuspectedMember(Address mbr) {
            if (mbr == null) {
                return;
            }
            BroadcastTask broadcastTask = this;
            synchronized (broadcastTask) {
                Vector vector = FD_SOCK.this.members;
                synchronized (vector) {
                    if (!FD_SOCK.this.members.contains(mbr)) {
                        return;
                    }
                }
                vector = this.suspected_mbrs;
                synchronized (vector) {
                    if (!this.suspected_mbrs.contains(mbr)) {
                        this.suspected_mbrs.addElement(mbr);
                    }
                    if (!this.added) {
                        this.stopped = false;
                        this.added = true;
                        FD_SOCK.this.timer.add(this, true);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSuspectedMember(Address mbr) {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                return this.suspected_mbrs.contains(mbr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeSuspectedMember(Address suspected_mbr) {
            boolean result;
            if (suspected_mbr == null) {
                return false;
            }
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug("member is " + suspected_mbr);
            }
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.removeElement(suspected_mbr)) {
                    if (this.suspected_mbrs.size() == 0) {
                        this.stopped = true;
                    }
                    result = true;
                } else {
                    result = false;
                }
            }
            if (result) {
                vector = FD_SOCK.this.pingable_mbrs;
                synchronized (vector) {
                    FD_SOCK.this.pingable_mbrs.clear();
                    FD_SOCK.this.pingable_mbrs.addAll(FD_SOCK.this.members);
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                this.suspected_mbrs.removeAllElements();
                this.stopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustSuspectedMembers(Vector new_mbrship) {
            Iterator<Object> it;
            if (new_mbrship == null || new_mbrship.size() == 0) {
                return;
            }
            Object object = this.suspected_mbrs;
            synchronized (object) {
                it = this.suspected_mbrs.iterator();
                while (it.hasNext()) {
                    Address suspected_mbr = (Address)it.next();
                    if (new_mbrship.contains(suspected_mbr)) continue;
                    it.remove();
                    if (!FD_SOCK.this.log.isDebugEnabled()) continue;
                    FD_SOCK.this.log.debug("removed " + suspected_mbr + " (size=" + this.suspected_mbrs.size() + ')');
                }
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                }
            }
            object = this;
            synchronized (object) {
                it = this.departedMembers.keySet().iterator();
                while (it.hasNext()) {
                    Address mbr = (Address)it.next();
                    if (!new_mbrship.contains(mbr)) continue;
                    it.remove();
                }
            }
        }

        @Override
        public boolean cancelled() {
            return false;
        }

        @Override
        public long nextInterval() {
            return FD_SOCK.this.suspect_msg_interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            Vector vector = this.suspected_mbrs;
            synchronized (vector) {
                if (this.suspected_mbrs.size() == 0) {
                    this.stopped = true;
                    return;
                }
                FD_SOCK.this.log.getInternalLogWriter().info(JGroupsStrings.FD_SOCK_BROADCASTING_SUSPECT_MESSAGE_SUSPECTED_MBRS_0_TO_GROUP, this.suspected_mbrs);
                hdr = new FdHeader(10);
                hdr.mbrs = (Vector)this.suspected_mbrs.clone();
                if (FD_SOCK.this.currentView != null) {
                    hdr.vid = FD_SOCK.this.currentView.getVid();
                }
            }
            FD_SOCK.this.sendSuspectMessage(hdr, "still being suspected");
            if (FD_SOCK.this.log.isDebugEnabled()) {
                FD_SOCK.this.log.debug("task done");
            }
        }
    }

    private class RandomPingTask
    implements TimeScheduler.Task {
        Address lastPd = null;

        private RandomPingTask() {
        }

        @Override
        public boolean cancelled() {
            return FD_SOCK.this.disconnecting;
        }

        @Override
        public long nextInterval() {
            return FD_SOCK.this.connectTimeout * 10;
        }

        @Override
        public void run() {
            Address pd = this.lastPd == null ? FD_SOCK.this.getRandomPingDest() : FD_SOCK.this.getSequentialPingDest(this.lastPd);
            if (pd == null) {
                this.lastPd = null;
            } else {
                while (pd != null) {
                    this.lastPd = pd;
                    if (Protocol.trace) {
                        FD_SOCK.this.log.trace("" + FD_SOCK.this.local_addr + " is performing random health check on " + pd);
                    }
                    if (FD_SOCK.this.checkSuspect(pd, FD_SOCK.this.getName() + " tcp/ip health check")) {
                        return;
                    }
                    FD_SOCK.this.bcast_task.addSuspectedMember(pd);
                    pd = FD_SOCK.this.getSequentialPingDest(pd);
                }
            }
        }
    }

    private static class ClientConnectionHandler
    extends Thread {
        volatile Socket client_sock = null;
        final Object mutex = new Object();
        final ServerSocketHandler myHandler;

        ClientConnectionHandler(Socket client_sock, ServerSocketHandler h) {
            this.setName("FD_SOCK ClientConnectionHandler");
            this.setDaemon(true);
            this.client_sock = client_sock;
            this.myHandler = h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread(boolean normalTermination) {
            Object object = this.mutex;
            synchronized (object) {
                if (normalTermination && this.client_sock != null) {
                    try {
                        OutputStream out = this.client_sock.getOutputStream();
                        out.write(9);
                        out.flush();
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                    }
                }
            }
            this.interrupt();
            this.closeClientSocket();
        }

        static void loadEmergencyClasses() {
        }

        void emergencyClose() {
            Socket s = this.client_sock;
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeClientSocket() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.client_sock != null) {
                    try {
                        this.client_sock.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                do {
                    InputStream in;
                    SystemFailure.checkFailure();
                    Object object = this.mutex;
                    synchronized (object) {
                        if (this.client_sock == null) {
                            break;
                        }
                        in = this.client_sock.getInputStream();
                    }
                    int b = in.read();
                    if (b == 6) {
                        this.client_sock.getOutputStream().write(6);
                        this.client_sock.getOutputStream().flush();
                        this.client_sock.shutdownOutput();
                    }
                    if (b == -1 || b == 9) break;
                    if (b != 6) continue;
                    break;
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (IOException io_ex1) {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                Object object = this.myHandler.clientsMutex;
                synchronized (object) {
                    for (int i = 0; i < this.myHandler.clients.length; ++i) {
                        if (this.myHandler.clients[i] != this) continue;
                        this.myHandler.clients = (ClientConnectionHandler[])ArrayUtils.remove(this.myHandler.clients, i);
                        break;
                    }
                }
            }
            finally {
                Socket sock = this.client_sock;
                if (sock != null && !sock.isClosed()) {
                    this.closeClientSocket();
                }
                Object object = this.myHandler.clientsMutex;
                synchronized (object) {
                    for (int i = 0; i < this.myHandler.clients.length; ++i) {
                        if (this.myHandler.clients[i] != this) continue;
                        this.myHandler.clients = (ClientConnectionHandler[])ArrayUtils.remove(this.myHandler.clients, i);
                        break;
                    }
                }
            }
        }
    }

    private class ServerSocketHandler
    implements Runnable {
        volatile Thread acceptor = null;
        volatile boolean beSick;
        Object sicknessGuard = new Object();
        final Object clientsMutex = new Object();
        volatile ClientConnectionHandler[] clients = new ClientConnectionHandler[0];

        ServerSocketHandler() {
        }

        synchronized void start() {
            if (this.acceptor == null || !this.acceptor.isAlive()) {
                this.acceptor = new Thread(GemFireTracer.GROUP, this, "FD_SOCK listener thread");
                this.acceptor.setDaemon(true);
                this.acceptor.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop(boolean normalTermination) {
            if (this.acceptor != null && this.acceptor.isAlive()) {
                this.acceptor.interrupt();
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Object object = this.clientsMutex;
            synchronized (object) {
                for (int i = 0; i < this.clients.length; ++i) {
                    ClientConnectionHandler handler = this.clients[i];
                    handler.stopThread(normalTermination);
                }
                this.clients = new ClientConnectionHandler[0];
            }
            this.acceptor = null;
        }

        void emergencyClose() {
            Thread thr = this.acceptor;
            if (thr != null && thr.isAlive()) {
                this.acceptor.interrupt();
            }
            this.acceptor = null;
            ServerSocket ss = FD_SOCK.this.srv_sock;
            if (ss != null) {
                try {
                    FD_SOCK.this.srv_sock.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            ClientConnectionHandler[] snap = this.clients;
            for (int i = 0; i < snap.length; ++i) {
                ClientConnectionHandler handler = snap[i];
                handler.emergencyClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (Thread.currentThread().isInterrupted()) break;
                try {
                    if (Protocol.trace) {
                        FD_SOCK.this.log.trace("waiting for client connections on " + FD_SOCK.this.srv_sock.getInetAddress() + ":" + FD_SOCK.this.srv_sock.getLocalPort());
                    }
                    Object object = this.sicknessGuard;
                    synchronized (object) {
                        if (this.beSick) {
                            try {
                                FD_SOCK.this.log.getInternalLogWriter().info(JGroupsStrings.ONE_ARG, "FD_SOCK protocol will begin acting sick");
                                this.sicknessGuard.wait();
                            }
                            catch (InterruptedException ie) {
                                return;
                            }
                            FD_SOCK.this.log.getInternalLogWriter().info(JGroupsStrings.ONE_ARG, "FD_SOCK protocol is done acting sick");
                        }
                    }
                    Socket client_sock = FD_SOCK.this.srv_sock.accept();
                    if (Protocol.trace) {
                        FD_SOCK.this.log.trace("accepted connection from " + client_sock.getInetAddress() + ':' + client_sock.getPort());
                    }
                    ClientConnectionHandler client_conn_handler = new ClientConnectionHandler(client_sock, this);
                    Object object2 = this.clientsMutex;
                    synchronized (object2) {
                        this.clients = (ClientConnectionHandler[])ArrayUtils.insert(this.clients, this.clients.length, client_conn_handler);
                    }
                    client_conn_handler.start();
                }
                catch (IOException io_ex2) {
                    break;
                }
            }
        }
    }

    public static class FdHeader
    extends Header
    implements Streamable {
        public boolean abnormalTermination;
        public static final byte SUSPECT = 10;
        public static final byte WHO_HAS_SOCK = 11;
        public static final byte I_HAVE_SOCK = 12;
        public static final byte GET_CACHE = 13;
        public static final byte GET_CACHE_RSP = 14;
        public static final byte NOT_MEMBER = 15;
        public static final byte FD_SUSPECT = 20;
        byte type = (byte)10;
        Address mbr = null;
        IpAddress sock_addr;
        Hashtable cachedAddrs = null;
        Vector mbrs = null;
        ViewId vid;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        public FdHeader(byte type, Address mbr) {
            this.type = type;
            this.mbr = mbr;
        }

        public FdHeader(byte type, Hashtable cachedAddrs) {
            this.type = type;
            this.cachedAddrs = cachedAddrs;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(FdHeader.type2String(this.type));
            if (this.mbr != null) {
                sb.append(", mbr=").append(this.mbr);
            }
            if (this.sock_addr != null) {
                sb.append(", sock_addr=").append(this.sock_addr);
            }
            if (this.cachedAddrs != null) {
                sb.append(", cache=").append(this.cachedAddrs);
            }
            if (this.mbrs != null) {
                sb.append(", mbrs=").append(this.mbrs);
            }
            sb.append(", abnormal=").append(this.abnormalTermination);
            return sb.toString();
        }

        public static String type2String(byte type) {
            switch (type) {
                case 10: {
                    return "SUSPECT";
                }
                case 11: {
                    return "WHO_HAS_SOCK";
                }
                case 12: {
                    return "I_HAVE_SOCK";
                }
                case 13: {
                    return "GET_CACHE";
                }
                case 14: {
                    return "GET_CACHE_RSP";
                }
                case 20: {
                    return "FD_SUSPECT";
                }
            }
            return "unknown type (" + type + ')';
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.mbr);
            out.writeObject(this.sock_addr);
            out.writeObject(this.cachedAddrs);
            out.writeObject(this.mbrs);
            out.writeBoolean(this.abnormalTermination);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.mbr = (Address)in.readObject();
            this.sock_addr = (IpAddress)in.readObject();
            this.cachedAddrs = (Hashtable)in.readObject();
            this.mbrs = (Vector)in.readObject();
            this.abnormalTermination = in.readBoolean();
        }

        @Override
        public long size(short version) {
            long retval = 1L;
            retval += (long)Util.size(this.mbr, version);
            retval += (long)Util.size(this.sock_addr, version);
            retval += 4L;
            if (this.cachedAddrs != null) {
                for (Map.Entry entry : this.cachedAddrs.entrySet()) {
                    Address key2 = (Address)entry.getKey();
                    if (key2 != null) {
                        retval += (long)Util.size(key2, version);
                    }
                    ++retval;
                    IpAddress val = (IpAddress)entry.getValue();
                    if (val == null) continue;
                    retval += (long)val.size(version);
                }
            }
            retval += 4L;
            if (this.mbrs != null) {
                for (int i = 0; i < this.mbrs.size(); ++i) {
                    retval += (long)Util.size((Address)this.mbrs.elementAt(i), version);
                }
            }
            return ++retval;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.mbr, out);
            Util.writeStreamable(this.sock_addr, out);
            int size2 = this.cachedAddrs != null ? this.cachedAddrs.size() : 0;
            out.writeInt(size2);
            if (size2 > 0) {
                for (Map.Entry entry : this.cachedAddrs.entrySet()) {
                    Address key2 = (Address)entry.getKey();
                    IpAddress val = (IpAddress)entry.getValue();
                    Util.writeAddress(key2, out);
                    Util.writeStreamable(val, out);
                }
            }
            size2 = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size2);
            if (size2 > 0) {
                for (Address address : this.mbrs) {
                    Util.writeAddress(address, out);
                }
            }
            out.writeBoolean(this.abnormalTermination);
            Util.writeStreamable(this.vid, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            int i;
            this.type = in.readByte();
            this.mbr = Util.readAddress(in);
            this.sock_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
            int size2 = in.readInt();
            if (size2 > 0) {
                if (this.cachedAddrs == null) {
                    this.cachedAddrs = new Hashtable();
                }
                for (i = 0; i < size2; ++i) {
                    Address key2 = Util.readAddress(in);
                    IpAddress val = (IpAddress)Util.readStreamable(IpAddress.class, in);
                    this.cachedAddrs.put(key2, val);
                }
            }
            if ((size2 = in.readInt()) > 0) {
                if (this.mbrs == null) {
                    this.mbrs = new Vector();
                }
                for (i = 0; i < size2; ++i) {
                    Address addr = Util.readAddress(in);
                    this.mbrs.add(addr);
                }
            }
            this.abnormalTermination = in.readBoolean();
            this.vid = (ViewId)Util.readStreamable(ViewId.class, in);
        }
    }

    public static class ReasonHeader
    extends Header
    implements Streamable {
        protected String cause;

        public ReasonHeader() {
        }

        ReasonHeader(String reason) {
            this.cause = reason;
        }

        @Override
        public long size(short version) {
            return this.cause.getBytes().length;
        }

        @Override
        public String toString() {
            return this.cause;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.cause);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.cause = in.readUTF();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeUTF(this.cause);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.cause = in.readUTF();
        }
    }
}

