/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.Protocol;
import java.util.Vector;

public class FLOWCONTROL
extends Protocol {
    final Vector queuedMsgs = new Vector();
    int sentMsgs = 0;
    static final int MAXSENTMSGS = 1;
    Address myAddr;

    @Override
    public String getName() {
        return "FLOWCONTROL";
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.myAddr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message received");
                }
                if (!msg.getSrc().equals(this.myAddr)) break;
                if (this.queuedMsgs.size() > 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Message from me received - Queue size was " + this.queuedMsgs.size());
                    }
                    this.passDown((Event)this.queuedMsgs.remove(0));
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message from me received - No messages in queue");
                }
                --this.sentMsgs;
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        Message msg;
        if (evt.getType() == 1 && ((msg = (Message)evt.getArg()).getDest() == null || msg.getDest().equals(this.myAddr))) {
            if (this.sentMsgs < 1) {
                ++this.sentMsgs;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Message " + this.sentMsgs + " sent");
                }
            } else {
                this.queuedMsgs.add(evt);
                return;
            }
        }
        this.passDown(evt);
    }
}

