/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.MethodCall;
import com.gemstone.org.jgroups.protocols.Digest;
import com.gemstone.org.jgroups.protocols.FlushRsp;
import com.gemstone.org.jgroups.stack.RpcProtocol;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class FLUSH
extends RpcProtocol {
    final Vector mbrs = new Vector();
    boolean is_server = false;
    final Object block_mutex = new Object();
    long block_timeout = 5000L;
    Address local_addr = null;
    boolean blocked = false;
    final Object digest_mutex = new Object();
    long digest_timeout = 2000L;
    final Object highest_delivered_mutex = new Object();
    long[] highest_delivered_msgs;
    Digest digest = null;
    final Object get_msgs_mutex = new Object();
    static final long get_msgs_timeout = 4000L;
    List get_msgs = null;

    @Override
    public String getName() {
        return "FLUSH";
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(27);
        return retval;
    }

    @Override
    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(35);
        retval.addElement(31);
        retval.addElement(37);
        return retval;
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this._corr == null) {
            throw new Exception("FLUSH.start(): cannot set deadlock detection in corr, as it is null !");
        }
        this._corr.setDeadlockDetection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlushRsp flush(Vector dests) {
        int i;
        FlushRsp retval = new FlushRsp();
        List unstable_msgs = new List();
        boolean get_lower_msgs = false;
        this.highest_delivered_msgs = new long[this.members.size()];
        long[] min = new long[this.members.size()];
        long[] max = new long[this.members.size()];
        this.getHighestDeliveredSeqnos();
        for (int i2 = 0; i2 < this.highest_delivered_msgs.length; ++i2) {
            min[i2] = max[i2] = this.highest_delivered_msgs[i2];
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FLUSH_CALLING_HANDLEFLUSH_0, dests);
        }
        this.passDown(new Event(26));
        MethodCall call = new MethodCall("handleFlush", new Object[]{dests, this.highest_delivered_msgs.clone()}, new String[]{Vector.class.getName(), long[].class.getName()});
        RspList rsp_list = this.callRemoteMethods(dests, call, 2, 0L);
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FLUSH_FLUSH_DONE);
        }
        for (i = 0; i < rsp_list.size(); ++i) {
            Digest digest;
            Rsp rsp = (Rsp)rsp_list.elementAt(i);
            if (!rsp.wasReceived() || (digest = (Digest)rsp.getValue()) == null) continue;
            for (int j = 0; j < digest.highest_seqnos.length && j < min.length; ++j) {
                min[j] = Math.min(min[j], digest.highest_seqnos[j]);
                max[j] = Math.max(max[j], digest.highest_seqnos[j]);
            }
            if (digest.msgs.size() <= 0) continue;
            Enumeration e = digest.msgs.elements();
            while (e.hasMoreElements()) {
                unstable_msgs.add(e.nextElement());
            }
        }
        long[][] lower = new long[min.length][];
        for (i = 0; i < min.length; ++i) {
            if (min[i] >= this.highest_delivered_msgs[i]) continue;
            lower[i] = new long[2];
            lower[i][0] = min[i];
            lower[i][1] = this.highest_delivered_msgs[i];
            get_lower_msgs = true;
        }
        if (get_lower_msgs) {
            this.get_msgs = null;
            Object i3 = this.get_msgs_mutex;
            synchronized (i3) {
                this.passDown(new Event(37, lower));
                try {
                    this.get_msgs_mutex.wait(4000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.get_msgs != null) {
                Enumeration e = this.get_msgs.elements();
                while (e.hasMoreElements()) {
                    unstable_msgs.add(e.nextElement());
                }
            }
        }
        retval.unstable_msgs = unstable_msgs.getContents();
        if (rsp_list.numSuspectedMembers() > 0) {
            retval.result = false;
            retval.failed_mbrs = rsp_list.getSuspectedMembers();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Digest handleFlush(Vector flush_dests, long[] highest_seqnos) {
        this.digest = null;
        if (this.log.isInfoEnabled()) {
            this.log.info("flush_dests=" + flush_dests + " , highest_seqnos=" + Util.array2String(highest_seqnos));
        }
        if (!this.is_server) {
            return this.digest;
        }
        if (flush_dests == null) {
            if (this.warn) {
                this.log.warn("flush dest is null, ignoring flush !");
            }
            return this.digest;
        }
        if (flush_dests.size() == 0) {
            if (this.warn) {
                this.log.warn("flush dest is empty, ignoring flush !");
            }
            return this.digest;
        }
        if (!flush_dests.contains(this.local_addr)) {
            if (this.warn) {
                this.log.warn("am not in the flush dests, ignoring flush");
            }
            return this.digest;
        }
        if (!this.blocked) {
            this.blocked = true;
            Object object = this.block_mutex;
            synchronized (object) {
                this.passUp(new Event(10));
                try {
                    this.block_mutex.wait(this.block_timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.getMessageDigest(highest_seqnos);
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.FLUSH_RETURNING_DIGEST___0, this.digest);
        }
        return this.digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getHighestDeliveredSeqnos() {
        Object object = this.highest_delivered_mutex;
        synchronized (object) {
            this.passDown(new Event(35));
            try {
                this.highest_delivered_mutex.wait(4000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMessageDigest(long[] highest_seqnos) {
        Object object = this.digest_mutex;
        synchronized (object) {
            this.passDown(new Event(31, highest_seqnos));
            try {
                this.digest_mutex.wait(this.digest_timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 32: {
                Object object = this.digest_mutex;
                synchronized (object) {
                    this.digest = (Digest)evt.getArg();
                    this.digest_mutex.notifyAll();
                }
                return false;
            }
            case 36: {
                long[] tmp = (long[])evt.getArg();
                if (tmp != null) {
                    System.arraycopy(tmp, 0, this.highest_delivered_msgs, 0, tmp.length);
                }
                Object object = this.highest_delivered_mutex;
                synchronized (object) {
                    this.highest_delivered_mutex.notifyAll();
                }
                return false;
            }
            case 38: {
                Object object = this.get_msgs_mutex;
                synchronized (object) {
                    this.get_msgs = (List)evt.getArg();
                    this.get_msgs_mutex.notifyAll();
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 27: {
                Vector dests = (Vector)evt.getArg();
                if (dests == null) {
                    dests = new Vector();
                }
                FlushRsp rsp = this.flush(dests);
                this.passUp(new Event(28, rsp));
                return false;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 6: {
                this.blocked = false;
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp == null) break;
                this.mbrs.removeAllElements();
                for (int i = 0; i < tmp.size(); ++i) {
                    this.mbrs.addElement(tmp.elementAt(i));
                }
                break;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveDownEvent(Event evt) {
        if (evt.getType() == 11) {
            Object object = this.down_queue;
            synchronized (object) {
                try {
                    while (this.down_queue.size() > 0) {
                        Event event = (Event)this.down_queue.remove(10L);
                        this.down(event);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            object = this.block_mutex;
            synchronized (object) {
                this.block_mutex.notifyAll();
            }
            return;
        }
        super.receiveDownEvent(evt);
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("block_timeout");
        if (str != null) {
            this.block_timeout = Long.parseLong(str);
            props.remove("block_timeout");
        }
        if ((str = props.getProperty("digest_timeout")) != null) {
            this.digest_timeout = Long.parseLong(str);
            props.remove("digest_timeout");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.FLUSH_EXAMPLESETPROPERTIES_THESE_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }
}

