/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;

public class HTOTAL
extends Protocol {
    Address coord = null;
    Address neighbor = null;
    Address local_addr = null;
    Vector mbrs = new Vector();
    private boolean use_multipoint_forwarding = false;

    @Override
    public final String getName() {
        return "HTOTAL";
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("use_multipoint_forwarding");
        if (str != null) {
            this.use_multipoint_forwarding = Boolean.valueOf(str);
            props.remove("use_multipoint_forwarding");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.HTOTAL_TCPSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.determineCoordinatorAndNextMember((View)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress()) break;
                if (this.coord == null) {
                    this.log.error(JGroupsStrings.HTOTAL_COORDINATOR_IS_NULL_CANNOT_SEND_MESSAGE_TO_COORDINATOR);
                } else {
                    msg.setSrc(this.local_addr);
                    this.forwardTo(this.coord, msg);
                }
                return;
            }
        }
        this.passDown(evt);
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.determineCoordinatorAndNextMember((View)evt.getArg());
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                HTotalHeader hdr = (HTotalHeader)msg.getHeader(this.getName());
                if (hdr == null) break;
                Message copy = msg.copy(false);
                if (this.use_multipoint_forwarding) {
                    copy.setDest(null);
                    this.passDown(new Event(1, copy));
                } else if (this.neighbor != null) {
                    this.forwardTo(this.neighbor, copy);
                }
                msg.setDest(hdr.dest);
                msg.setSrc(hdr.src);
                this.passUp(evt);
                return;
            }
        }
        this.passUp(evt);
    }

    private void forwardTo(Address destination, Message msg) {
        HTotalHeader hdr = (HTotalHeader)msg.getHeader(this.getName());
        if (hdr == null) {
            hdr = new HTotalHeader(msg.getDest(), msg.getSrc());
            msg.putHeader(this.getName(), hdr);
        }
        msg.setDest(destination);
        if (trace) {
            this.log.trace("forwarding message to " + destination + ", hdr=" + hdr);
        }
        this.passDown(new Event(1, msg));
    }

    private void determineCoordinatorAndNextMember(View v) {
        Address retval = null;
        this.mbrs.clear();
        this.mbrs.addAll(v.getMembers());
        this.coord = this.mbrs.size() > 0 ? this.mbrs.firstElement() : null;
        if (this.mbrs.size() < 2 || this.local_addr == null) {
            this.neighbor = null;
        } else {
            for (int i = 0; i < this.mbrs.size(); ++i) {
                Object tmp = this.mbrs.elementAt(i);
                if (!this.local_addr.equals(tmp)) continue;
                if (i + 1 >= this.mbrs.size()) break;
                retval = (Address)this.mbrs.elementAt(i + 1);
                break;
            }
        }
        this.neighbor = retval;
        if (trace) {
            this.log.trace("coord=" + this.coord + ", neighbor=" + this.neighbor);
        }
    }

    public static class HTotalHeader
    extends Header
    implements Streamable {
        Address dest;
        Address src;

        public HTotalHeader() {
        }

        public HTotalHeader(Address dest, Address src) {
            this.dest = dest;
            this.src = src;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.dest);
            out.writeObject(this.src);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.dest = (Address)in.readObject();
            this.src = (Address)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            Util.writeAddress(this.dest, out);
            Util.writeAddress(this.src, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.dest = Util.readAddress(in);
            this.src = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return "dest=" + this.dest + ", src=" + this.src;
        }
    }
}

