/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Util;

public class LOOPBACK
extends Protocol {
    private Address local_addr = null;
    private String group_addr = null;

    public String toString() {
        return "Protocol LOOPBACK(local address: " + this.local_addr + ')';
    }

    @Override
    public String getName() {
        return "LOOPBACK";
    }

    @Override
    public void init() throws Exception {
        this.local_addr = new IpAddress(12345);
    }

    @Override
    public void start() throws Exception {
        this.passUp(new Event(8, this.local_addr));
    }

    @Override
    public void down(Event evt) {
        if (trace) {
            this.log.trace("event is " + evt + ", group_addr=" + this.group_addr + ", time is " + System.currentTimeMillis() + ", hdrs: " + Util.printEvent(evt));
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Message rsp = msg.copy();
                if (rsp.getSrc() == null) {
                    rsp.setSrc(this.local_addr);
                }
                this.up(new Event(1, rsp));
                break;
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passUp(new Event(3));
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 47: {
                this.passUp(evt);
            }
        }
    }
}

