/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Promise;
import com.gemstone.org.jgroups.util.Util;
import java.util.Properties;
import java.util.Vector;

public class MERGE2
extends Protocol {
    Address local_addr = null;
    FindSubgroups task = null;
    private final Object task_lock = new Object();
    long min_interval = 5000L;
    long max_interval = 20000L;
    boolean is_coord = false;
    final Promise find_promise = new Promise();
    boolean use_separate_thread = false;

    @Override
    public String getName() {
        return "MERGE2";
    }

    public long getMinInterval() {
        return this.min_interval;
    }

    public void setMinInterval(long i) {
        this.min_interval = i;
    }

    public long getMaxInterval() {
        return this.max_interval;
    }

    public void setMaxInterval(long l) {
        this.max_interval = l;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("min_interval");
        if (str != null) {
            this.min_interval = Long.parseLong(str);
            props.remove("min_interval");
        }
        if ((str = props.getProperty("max_interval")) != null) {
            this.max_interval = Long.parseLong(str);
            props.remove("max_interval");
        }
        if (this.min_interval <= 0L || this.max_interval <= 0L) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MERGE2_MIN_INTERVAL_AND_MAX_INTERVAL_HAVE_TO_BE__0);
            }
            return false;
        }
        if (this.max_interval <= this.min_interval) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MERGE2_MAX_INTERVAL_HAS_TO_BE_GREATER_THAN_MIN_INTERVAL);
            }
            return false;
        }
        str = props.getProperty("use_separate_thread");
        if (str != null) {
            this.use_separate_thread = Boolean.valueOf(str);
            props.remove("use_separate_thread");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.MERGE2_MERGE2SETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>(1);
        retval.addElement(12);
        return retval;
    }

    @Override
    public void stop() {
        this.is_coord = false;
        this.stopTask();
    }

    @Override
    public void startUpHandler() {
    }

    @Override
    public void startDownHandler() {
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.passUp(evt);
                break;
            }
            case 13: {
                this.find_promise.setResult(evt.getArg());
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.passDown(evt);
                Vector mbrs = ((View)evt.getArg()).getMembers();
                if (mbrs == null || mbrs.size() == 0 || this.local_addr == null) {
                    this.stopTask();
                    break;
                }
                Address coord = (Address)mbrs.elementAt(0);
                if (coord.equals(this.local_addr)) {
                    this.is_coord = true;
                    this.startTask();
                    break;
                }
                if (this.is_coord) {
                    this.is_coord = false;
                }
                this.stopTask();
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTask() {
        Object object = this.task_lock;
        synchronized (object) {
            if (this.task == null) {
                this.task = new FindSubgroups();
            }
            this.task.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTask() {
        Object object = this.task_lock;
        synchronized (object) {
            if (this.task != null) {
                this.task.stop();
                this.task = null;
            }
        }
    }

    protected class FindSubgroups
    implements Runnable {
        Thread thread = null;

        protected FindSubgroups() {
        }

        public synchronized void start() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new Thread((Runnable)this, "MERGE2.FindSubgroups thread");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        public synchronized void stop() {
            if (this.thread != null) {
                Thread tmp = this.thread;
                this.thread = null;
                tmp.interrupt();
                MERGE2.this.find_promise.reset();
            }
            this.thread = null;
        }

        @Override
        public void run() {
            while (true) {
                Vector coords;
                SystemFailure.checkFailure();
                long interval = this.computeInterval();
                try {
                    Util.sleep(interval);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (Thread.currentThread().isInterrupted()) break;
                Vector initial_mbrs = this.findInitialMembers();
                if (Thread.currentThread().isInterrupted()) break;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug("initial_mbrs=" + initial_mbrs);
                }
                if ((coords = this.detectMultipleCoordinators(initial_mbrs)) == null || coords.size() <= 1) continue;
                if (MERGE2.this.log.isDebugEnabled()) {
                    MERGE2.this.log.debug("found multiple coordinators: " + coords + "; sending up MERGE event");
                }
                final Event evt = new Event(14, coords);
                if (MERGE2.this.use_separate_thread) {
                    Thread merge_notifier = new Thread(){

                        @Override
                        public void run() {
                            MERGE2.this.passUp(evt);
                        }
                    };
                    merge_notifier.setDaemon(true);
                    merge_notifier.setName("merge notifier thread");
                    merge_notifier.start();
                    continue;
                }
                MERGE2.this.passUp(evt);
            }
            if (Protocol.trace) {
                MERGE2.this.log.trace("MERGE2.FindSubgroups thread terminated (local_addr=" + MERGE2.this.local_addr + ")");
            }
        }

        long computeInterval() {
            return MERGE2.this.min_interval + Util.random(MERGE2.this.max_interval - MERGE2.this.min_interval);
        }

        Vector findInitialMembers() {
            PingRsp tmp = new PingRsp(MERGE2.this.local_addr, MERGE2.this.local_addr, true);
            MERGE2.this.find_promise.reset();
            MERGE2.this.passDown(Event.FIND_INITIAL_MBRS_EVT);
            Vector retval = (Vector)MERGE2.this.find_promise.getResult(0L);
            if (retval != null && MERGE2.this.is_coord && MERGE2.this.local_addr != null && !retval.contains(tmp)) {
                retval.add(tmp);
            }
            return retval;
        }

        Vector detectMultipleCoordinators(Vector initial_mbrs) {
            Vector<Address> ret = new Vector<Address>(11);
            if (initial_mbrs == null) {
                return null;
            }
            for (int i = 0; i < initial_mbrs.size(); ++i) {
                Address coord;
                PingRsp rsp = (PingRsp)initial_mbrs.elementAt(i);
                if (!rsp.is_server || ret.contains(coord = rsp.getCoordAddress())) continue;
                ret.addElement(coord);
            }
            return ret;
        }
    }
}

