/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.PING;
import com.gemstone.org.jgroups.util.Buffer;
import com.gemstone.org.jgroups.util.ExposedByteArrayOutputStream;
import com.gemstone.org.jgroups.util.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class MPING
extends PING
implements Runnable {
    MulticastSocket mcast_sock = null;
    Thread receiver = null;
    InetAddress bind_addr = null;
    boolean bind_to_all_interfaces = true;
    int ip_ttl = 16;
    InetAddress mcast_addr = null;
    int mcast_port = 7555;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(512);
    byte[] receive_buf = new byte[1024];
    static final String IGNORE_BIND_ADDRESS_PROPERTY = "ignore.bind.address";

    @Override
    public String getName() {
        return "MPING";
    }

    public InetAddress getBindAddr() {
        return this.bind_addr;
    }

    public void setBindAddr(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public boolean isBindToAllInterfaces() {
        return this.bind_to_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean bind_to_all_interfaces) {
        this.bind_to_all_interfaces = bind_to_all_interfaces;
    }

    public int getTTL() {
        return this.ip_ttl;
    }

    public void setTTL(int ip_ttl) {
        this.ip_ttl = ip_ttl;
    }

    public InetAddress getMcastAddr() {
        return this.mcast_addr;
    }

    public void setMcastAddr(InetAddress mcast_addr) {
        this.mcast_addr = mcast_addr;
    }

    public int getMcastPort() {
        return this.mcast_port;
    }

    public void setMcastPort(int mcast_port) {
        this.mcast_port = mcast_port;
    }

    @Override
    public boolean setProperties(Properties props) {
        String tmp = null;
        try {
            tmp = System.getProperty("bind.address");
            if (Boolean.getBoolean(IGNORE_BIND_ADDRESS_PROPERTY)) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal("(bind_addr): host " + str + " not known");
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("mcast_addr")) != null) {
            try {
                this.mcast_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException e) {
                this.log.error(JGroupsStrings.MPING_COULD_NOT_RESOLVE__0, str, (Throwable)e);
                return false;
            }
            props.remove("mcast_addr");
        }
        if ((str = props.getProperty("mcast_port")) != null) {
            this.mcast_port = Integer.parseInt(str);
            props.remove("mcast_port");
        }
        if ((str = props.getProperty("ip_ttl")) != null) {
            this.ip_ttl = Integer.parseInt(str);
            props.remove("ip_ttl");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.bind_to_all_interfaces = Boolean.valueOf(str);
            props.remove("bind_to_all_interfaces");
        }
        if (this.mcast_addr == null) {
            try {
                this.mcast_addr = InetAddress.getByName("230.5.6.7");
            }
            catch (UnknownHostException e) {
                this.log.error(JGroupsStrings.MPING_FAILED_GETTING_DEFAULT_MCAST_ADDRESS, (Throwable)e);
                return false;
            }
        }
        return super.setProperties(props);
    }

    @Override
    public void start() throws Exception {
        this.mcast_sock = new MulticastSocket(this.mcast_port);
        this.mcast_sock.setTimeToLive(this.ip_ttl);
        if (this.bind_to_all_interfaces) {
            this.bindToAllInterfaces();
            if (this.bind_addr != null) {
                this.mcast_sock.setNetworkInterface(NetworkInterface.getByInetAddress(this.bind_addr));
            }
        } else {
            InetAddress[] interfaces;
            if (this.bind_addr == null && (interfaces = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress())) != null && interfaces.length > 0) {
                this.bind_addr = interfaces[0];
            }
            if (this.bind_addr == null) {
                this.bind_addr = InetAddress.getLocalHost();
            }
            if (this.bind_addr != null && this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.MPING_SOCKETS_WILL_USE_INTERFACE__0, this.bind_addr.getHostAddress());
            }
            if (this.bind_addr != null) {
                this.mcast_sock.setInterface(this.bind_addr);
            }
            this.mcast_sock.joinGroup(this.mcast_addr);
        }
        this.startReceiver();
        super.start();
    }

    private void bindToAllInterfaces() throws IOException {
        InetSocketAddress tmp_mcast_addr = new InetSocketAddress(this.mcast_addr, this.mcast_port);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            if (!en2.hasMoreElements()) continue;
            InetAddress addr = en2.nextElement();
            this.mcast_sock.joinGroup(tmp_mcast_addr, i);
            if (!trace) continue;
            this.log.trace("joined " + tmp_mcast_addr + " on interface " + i.getName() + " (" + addr + ")");
        }
    }

    private synchronized void startReceiver() {
        if (this.receiver == null || !this.receiver.isAlive()) {
            this.receiver = new Thread((Runnable)this, "ReceiverThread");
            this.receiver.setDaemon(true);
            this.receiver.start();
            if (trace) {
                this.log.trace("receiver thread started");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.mcast_sock.close();
        MPING mPING = this;
        synchronized (mPING) {
            if (this.receiver != null) {
                this.receiver.interrupt();
            }
            this.receiver = null;
        }
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void sendMcastDiscoveryRequest(Message msg) {
        DataOutputStream out = null;
        try {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            this.out_stream.reset();
            out = new DataOutputStream(this.out_stream);
            msg.writeTo(out);
            out.flush();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            DatagramPacket packet = new DatagramPacket(buf.getBuf(), buf.getOffset(), buf.getLength(), this.mcast_addr, this.mcast_port);
            this.mcast_sock.send(packet);
            Util.closeOutputStream(out);
        }
        catch (IOException ex) {
            this.log.error(JGroupsStrings.MPING_FAILED_SENDING_DISCOVERY_REQUEST, (Throwable)ex);
        }
        finally {
            Util.closeOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        DatagramPacket packet = new DatagramPacket(this.receive_buf, this.receive_buf.length);
        ByteArrayInputStream inp_stream = null;
        DataInputStream inp = null;
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted()) break;
            packet.setData(this.receive_buf, 0, this.receive_buf.length);
            try {
                this.mcast_sock.receive(packet);
                byte[] data = packet.getData();
                inp_stream = new ByteArrayInputStream(data, 0, data.length);
                inp = new DataInputStream(inp_stream);
                Message msg = new Message();
                msg.readFrom(inp);
                this.up(new Event(1, msg));
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
                continue;
            }
            catch (SocketException socketEx) {
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
            }
            catch (Exception ex) {
                if (Thread.currentThread().isInterrupted()) continue;
                this.log.error(JGroupsStrings.MPING_FAILED_RECEIVING_PACKET, (Throwable)ex);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeInputStream(inp);
                this.closeInputStream(inp_stream);
                continue;
            }
            break;
        }
        if (trace) {
            this.log.trace("receiver thread terminated");
        }
    }

    private void closeInputStream(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

