/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.SavedMessages;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.util.Vector;

class MessageAcks {
    final GemFireTracer log = GemFireTracer.getLog(MessageAcks.class);
    private final Vector acks = new Vector();
    private final SavedMessages message_history = new SavedMessages();

    MessageAcks(Vector members) {
        this.reset(members);
    }

    public synchronized void reset(Vector members) {
        this.clear();
        int num_members = members.size();
        for (int i = 0; i < num_members; ++i) {
            Object temp_obj = members.elementAt(i);
            if (!(temp_obj instanceof Address)) {
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLD_MESSAGEACKSRESET__COULD_NOT_CAST_ELEMENT_OF_MEMBERS_TO_AN_ADDRESS_OBJECT);
                return;
            }
            this.acks.addElement(new Entry((Address)temp_obj));
        }
    }

    private void clear() {
        this.acks.removeAllElements();
        this.message_history.clearMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(Address addr) {
        Vector vector = this.acks;
        synchronized (vector) {
            int size2 = this.acks.size();
            for (int i = 0; i < size2; ++i) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    Entry this_entry = (Entry)temp_obj;
                    if (!this_entry.addr.equals(addr)) continue;
                    return this_entry;
                }
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLD_MESSAGEACKSGETENTRY__COULD_NOT_CAST_ELEMENT_OF_ACKS_TO_AN_ENTRY);
            }
            return null;
        }
    }

    public void setSeq(Address addr, long seq) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry != null && this_entry.seq < seq) {
            this_entry.seq = seq;
            this.truncateHistory();
        }
    }

    public long getSeq(Address addr) {
        Entry this_entry = this.getEntry(addr);
        if (this_entry == null) {
            return -2L;
        }
        return this_entry.seq;
    }

    public Message getMessage(long seq) {
        return this.message_history.peekMessage(seq);
    }

    public void addMessage(Message msg, long seq) {
        this.message_history.insertMessage(msg, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLowestSeqAck() {
        Vector vector = this.acks;
        synchronized (vector) {
            long ret_val = -10L;
            int size2 = this.acks.size();
            for (int i = 0; i < size2; ++i) {
                Object temp_obj = this.acks.elementAt(i);
                if (temp_obj instanceof Entry) {
                    long this_seq = ((Entry)temp_obj).seq;
                    if (this_seq >= ret_val) continue;
                    ret_val = this_seq;
                    continue;
                }
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLD_MESSAGEACKSGETLOWESTSEQACK__COULD_NOT_CAST_ELEMENT_OF_ACKS_TO_AN_ENTRY_INDEX_0, i);
                return -1L;
            }
            return ret_val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void truncateHistory() {
        long lowest_ack_seq = this.getLowestSeqAck();
        if (lowest_ack_seq < 0L) {
            return;
        }
        SavedMessages savedMessages = this.message_history;
        synchronized (savedMessages) {
            long lowest_stored_seq;
            while ((lowest_stored_seq = this.message_history.getFirstSeq()) >= 0L && lowest_stored_seq > lowest_ack_seq) {
                this.message_history.getFirstMessage();
            }
        }
    }

    static class Entry {
        public final Address addr;
        public long seq;

        Entry(Address addr, long seq) {
            this.addr = addr;
            this.seq = seq;
        }

        Entry(Address addr) {
            this.addr = addr;
            this.seq = -1L;
        }
    }
}

