/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;

public class PERF_TP
extends Protocol {
    private Address local_addr = null;
    static PERF_TP instance = null;
    long stop;
    long start;
    long num_msgs = 0L;
    long expected_msgs = 0L;
    boolean done = false;

    public static PERF_TP getInstance() {
        return instance;
    }

    public PERF_TP() {
        if (instance == null) {
            instance = this;
        }
    }

    public String toString() {
        return "Protocol PERF_TP (local address: " + this.local_addr + ')';
    }

    public boolean done() {
        return this.done;
    }

    public long getNumMessages() {
        return this.num_msgs;
    }

    public void setExpectedMessages(long m) {
        this.expected_msgs = m;
        this.num_msgs = 0L;
        this.done = false;
        this.start = System.currentTimeMillis();
    }

    public void reset() {
        this.start = 0L;
        this.stop = 0L;
        this.expected_msgs = 0L;
        this.num_msgs = 0L;
        this.done = false;
    }

    public long getTotalTime() {
        return this.stop - this.start;
    }

    @Override
    public String getName() {
        return "PERF_TP";
    }

    @Override
    public void init() throws Exception {
        this.local_addr = new IpAddress("localhost", 10000);
    }

    @Override
    public void start() throws Exception {
        this.passUp(new Event(8, this.local_addr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.done) break;
                Message msg = (Message)evt.getArg();
                Address dest_addr = msg.getDest();
                if (dest_addr == null) {
                    ++this.num_msgs;
                }
                if (this.num_msgs < this.expected_msgs) break;
                this.stop = System.currentTimeMillis();
                PERF_TP pERF_TP = this;
                synchronized (pERF_TP) {
                    this.done = true;
                    this.notifyAll();
                }
                if (!this.log.isInfoEnabled()) break;
                this.log.info(JGroupsStrings.PERF_TP_ALL_DONE_NUM_MSGS_0__EXPECTED_MSGS_1, new Object[]{this.num_msgs, this.expected_msgs});
                break;
            }
            case 2: {
                this.passUp(new Event(3));
                return;
            }
            case 4: {
                this.passUp(new Event(5));
                return;
            }
        }
        if (this.down_prot != null) {
            this.passDown(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.done) {
                    if (!this.warn) break;
                    this.log.warn("all done (discarding msg)");
                    break;
                }
                Message msg = (Message)evt.getArg();
                Address dest_addr = msg.getDest();
                if (dest_addr == null) {
                    ++this.num_msgs;
                }
                if (this.num_msgs >= this.expected_msgs) {
                    this.stop = System.currentTimeMillis();
                    PERF_TP pERF_TP = this;
                    synchronized (pERF_TP) {
                        this.done = true;
                        this.notifyAll();
                    }
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.PERF_TP_ALL_DONE_NUM_MSGS_0__EXPECTED_MSGS_1, new Object[]{this.num_msgs, this.expected_msgs});
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }
}

