/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.Discovery;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.stack.GossipClient;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Util;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class PING
extends Discovery {
    String gossip_host = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    int port_range = 1;
    List initial_hosts = null;
    public static final String name = "PING";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getProtocolEnum() {
        return 2;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("gossip_host");
        if (str != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = Integer.parseInt(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = Long.parseLong(str);
            props.remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.PING_CREATION_OF_GOSSIPCLIENT_FAILED_EXCEPTION_0, (Throwable)e);
                }
                return false;
            }
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        return super.setProperties(props);
    }

    @Override
    public void stop() {
        super.stop();
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && this.local_addr != null) {
            List hlist;
            boolean inInitialHosts = false;
            Enumeration en = this.initial_hosts.elements();
            while (en.hasMoreElements() && !inInitialHosts) {
                hlist = (List)en.nextElement();
                if (!hlist.contains(this.local_addr)) continue;
                inInitialHosts = true;
            }
            if (!inInitialHosts) {
                hlist = new List();
                hlist.add(this.local_addr);
                this.initial_hosts.add(hlist);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("adding my address (" + this.local_addr + ") to initial_hosts; initial_hosts=" + this.initial_hosts);
                }
            }
        }
    }

    @Override
    public void handleConnect() {
        if (this.client != null) {
            this.client.register(this.group_addr, this.local_addr, 0L, false);
        }
    }

    @Override
    public void handleDisconnect() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Override
    public void sendGetMembersRequest(AtomicBoolean waiter_sync) {
        this.wakeWaiter(waiter_sync);
        if (this.client != null) {
            Vector gossip_rsps = this.client.getMembers(this.group_addr, this.local_addr, true, 0L);
            if (gossip_rsps == null || gossip_rsps.size() <= 0) {
                this.passUp(new Event(13, null));
                return;
            }
            Event view_event = new Event(15, this.makeView(gossip_rsps));
            this.passDown(view_event);
            if (gossip_rsps.size() > 0) {
                for (int i = 0; i < gossip_rsps.size(); ++i) {
                    Address dest = (Address)gossip_rsps.elementAt(i);
                    Message msg = new Message(dest, null, null);
                    msg.putHeader(this.getName(), new PingHeader(1, null));
                    this.passDown(new Event(1, msg));
                }
            }
            try {
                Util.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else if (this.initial_hosts != null && this.initial_hosts.size() > 0) {
            Message msg = new Message(null, null, null);
            msg.putHeader(this.getName(), new PingHeader(1, null));
            Enumeration en = this.initial_hosts.elements();
            while (en.hasMoreElements()) {
                List hlist = (List)en.nextElement();
                boolean isMember = false;
                Enumeration hen = hlist.elements();
                while (hen.hasMoreElements() && !isMember) {
                    IpAddress h = (IpAddress)hen.nextElement();
                    msg.setDest(h);
                    if (trace) {
                        this.log.trace("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                    }
                    this.passDown(new Event(1, msg.copy()));
                }
            }
        } else {
            this.ping_waiter.clearResponses();
            PingHeader hdr = new PingHeader(1, null);
            Message msg = new Message(null, null, null);
            msg.putHeader(this.getName(), hdr);
            try {
                this.sendMcastDiscoveryRequest(msg);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    void sendMcastDiscoveryRequest(Message discovery_request) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long waitTime = new Random(this.hashCode()).nextInt(150);
        if (waitTime > 0L) {
            Thread.sleep(waitTime);
        }
        this.passDown(new Event(1, discovery_request));
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                List hosts = new List();
                for (int i = port; i < port + this.port_range; ++i) {
                    hosts.add(new IpAddress(host, i));
                }
                tmp.add(hosts);
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error(JGroupsStrings.PING_EXEPTION_IS__0, (Throwable)e);
            }
        }
        return tmp;
    }
}

