/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.PerfEntry;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

@SuppressFBWarnings(value={"SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION"}, justification="GemFire does not use the PERF protocol")
public class PerfHeader
extends Header {
    Object sender = null;
    Object receiver = null;
    long start_time = 0L;
    long end_time = 0L;
    long network_send = 0L;
    long network_recv = 0L;
    long network_time = 0L;
    HashMap down = new HashMap();
    HashMap up = new HashMap();
    static final int UP = 1;
    static final int DOWN = 2;
    static final String classname = "org.jgroups.protocols.PerfHeader";
    static long size = 0L;
    private static Message msg2;
    static GemFireTracer log;

    public PerfHeader() {
    }

    public PerfHeader(Object sender, Object receiver) {
        this.sender = sender;
        this.receiver = receiver;
        this.start_time = System.currentTimeMillis();
    }

    @Override
    public String toString() {
        return "[PerfHeader]";
    }

    public String printContents(boolean detailed) {
        return this.printContents(detailed, null);
    }

    public String printContents(boolean detailed, Vector prots) {
        PerfEntry val;
        String key22;
        Protocol p;
        int i;
        StringBuffer sb = new StringBuffer();
        if (this.sender != null) {
            sb.append("sender=").append(this.sender).append('\n');
        }
        if (this.receiver != null) {
            sb.append("receiver=").append(this.receiver).append('\n');
        }
        if (detailed) {
            sb.append("start_time=").append(this.start_time).append("\nend_time=").append(this.end_time).append('\n');
        }
        if (this.end_time >= this.start_time) {
            sb.append("total time=").append(this.end_time - this.start_time).append('\n');
        } else {
            sb.append("total time=n/a\n");
        }
        if (detailed) {
            if (this.network_send > 0L) {
                sb.append("network_send=").append(this.network_send).append('\n');
            }
            if (this.network_recv > 0L) {
                sb.append("network_recv=").append(this.network_recv).append('\n');
            }
        }
        if (this.network_time > 0L) {
            sb.append("network=").append(this.network_time).append('\n');
        }
        sb.append("\nDOWN\n-----\n");
        if (prots != null) {
            for (i = 0; i < prots.size(); ++i) {
                p = (Protocol)prots.elementAt(i);
                key22 = p.getName();
                val = (PerfEntry)this.down.get(key22);
                sb.append(key22).append(':').append('\t').append(val.printContents(detailed)).append('\n');
            }
        } else {
            for (String key22 : this.down.keySet()) {
                val = (PerfEntry)this.down.get(key22);
                sb.append(key22).append(':').append('\t').append(val.printContents(detailed)).append('\n');
            }
        }
        sb.append("\nUP\n-----\n");
        if (prots != null) {
            for (i = prots.size() - 1; i >= 0; --i) {
                p = (Protocol)prots.elementAt(i);
                key22 = p.getName();
                val = (PerfEntry)this.up.get(key22);
                sb.append(key22).append(':').append('\t').append(val.printContents(detailed)).append('\n');
            }
        } else {
            for (String key22 : this.up.keySet()) {
                val = (PerfEntry)this.up.get(key22);
                sb.append(key22).append(':').append('\t').append(val.printContents(detailed)).append('\n');
            }
        }
        return sb.toString();
    }

    public void setEndTime() {
        this.end_time = System.currentTimeMillis();
    }

    public void setReceived(String prot_name, int type) {
        PerfEntry entry = this.getEntry(prot_name, type);
        long t = System.currentTimeMillis();
        if (entry != null) {
            entry.setReceived(t);
        }
    }

    public void setDone(String prot_name, int type) {
        PerfEntry entry = this.getEntry(prot_name, type);
        long t = System.currentTimeMillis();
        if (entry != null) {
            entry.setDone(t);
        }
    }

    public void setNetworkSent() {
        this.network_send = System.currentTimeMillis();
    }

    public void setNetworkReceived() {
        this.network_recv = System.currentTimeMillis();
        if (this.network_send > 0L && this.network_recv > this.network_send) {
            this.network_time = this.network_recv - this.network_send;
        }
    }

    public void addEntry(String prot_name) {
        this.up.put(prot_name, new PerfEntry());
        this.down.put(prot_name, new PerfEntry());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sender);
        out.writeObject(this.receiver);
        out.writeLong(this.start_time);
        out.writeLong(this.end_time);
        out.writeLong(this.network_send);
        out.writeLong(this.network_recv);
        out.writeLong(this.network_time);
        this.writeHashtable(this.down, out);
        this.writeHashtable(this.up, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sender = in.readObject();
        this.receiver = in.readObject();
        this.start_time = in.readLong();
        this.end_time = in.readLong();
        this.network_send = in.readLong();
        this.network_recv = in.readLong();
        this.network_time = in.readLong();
        this.down = this.readHashtable(in);
        this.up = this.readHashtable(in);
    }

    @Override
    public long size(short version) {
        return size;
    }

    void writeHashtable(HashMap h, ObjectOutput out) {
        try {
            if (h == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(h.size());
            for (Map.Entry entry : h.entrySet()) {
                String key2 = (String)entry.getKey();
                PerfEntry val = (PerfEntry)entry.getValue();
                if (key2 == null || val == null) {
                    System.err.println("PerfHeader.writeHashtable(): key or val is null");
                    continue;
                }
                out.writeObject(key2);
                out.writeObject(val);
            }
        }
        catch (Exception ex) {
            System.err.println("PerfHeader.writeHashtable(): " + ex);
        }
    }

    HashMap readHashtable(ObjectInput in) {
        HashMap<String, PerfEntry> h = new HashMap<String, PerfEntry>();
        int num = 0;
        try {
            num = in.readInt();
            if (num == 0) {
                return h;
            }
            for (int i = 0; i < num; ++i) {
                String key2 = (String)in.readObject();
                PerfEntry val = (PerfEntry)in.readObject();
                h.put(key2, val);
            }
        }
        catch (Exception ex) {
            System.err.println("PerfHeader.readHashtable(): " + ex);
        }
        return h;
    }

    PerfEntry getEntry(String prot_name, int type) {
        HashMap tmp = null;
        PerfEntry entry = null;
        if (prot_name == null) {
            return null;
        }
        if (type == 1) {
            tmp = this.up;
        } else if (type == 2) {
            tmp = this.down;
        }
        if (tmp == null) {
            return null;
        }
        entry = (PerfEntry)tmp.get(prot_name);
        if (entry == null) {
            log.error(JGroupsStrings.PerfHeader_PERFHEADERGETENTRY_PROTOCOL__0__NOT_FOUND, prot_name);
        }
        return entry;
    }

    public static void main(String[] args) {
        PerfHeader hdr = new PerfHeader();
        hdr.addEntry("GMS");
        hdr.addEntry("GMS");
        hdr.addEntry("FRAG");
        hdr.addEntry("FRAG");
        hdr.addEntry("UDP");
        hdr.addEntry("UDP");
        Message msg = new Message();
        msg.putHeader("PERF", hdr);
        try {
            hdr.setReceived("GMS", 2);
            Util.sleep(2L);
            hdr.setDone("GMS", 2);
            hdr.setReceived("FRAG", 2);
            Util.sleep(20L);
            hdr.setDone("FRAG", 2);
            long len = msg.size();
            System.out.println("Size is " + len);
            hdr.setReceived("UDP", 2);
            Util.sleep(12L);
            hdr.setDone("UDP", 2);
            Util.sleep(30L);
            hdr.setReceived("UDP", 1);
            hdr.setDone("UDP", 1);
            hdr.setReceived("FRAG", 1);
            Util.sleep(23L);
            hdr.setDone("FRAG", 1);
            hdr.setReceived("GMS", 1);
            Util.sleep(3L);
            hdr.setDone("GMS", 1);
            hdr.setEndTime();
            System.out.println(hdr.printContents(true));
            try {
                System.out.println("Saving hdr to byte buffer");
                ByteArrayOutputStream out_stream = new ByteArrayOutputStream(256);
                ObjectOutputStream out = new ObjectOutputStream(out_stream);
                out.writeObject(msg);
                byte[] out_buf = out_stream.toByteArray();
                System.out.println("Constructing hdr2 from byte buffer");
                byte[] in_buf = out_buf;
                ByteArrayInputStream in_stream = new ByteArrayInputStream(in_buf);
                ObjectInputStream in = new ObjectInputStream(in_stream);
                msg2 = (Message)in.readObject();
                PerfHeader hdr2 = (PerfHeader)msg2.removeHeader("PERF");
                System.out.println(hdr2.printContents(true));
            }
            catch (Exception ex) {
                log.error(ex);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    static {
        log = GemFireTracer.getLog(PerfHeader.class);
        size = Util.sizeOf(classname);
        if (size <= 0L) {
            size = 400L;
        }
    }
}

