/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.protocols.PingRsp;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PingHeader
extends Header
implements Streamable {
    public static final byte GET_MBRS_REQ = 1;
    public static final byte GET_MBRS_RSP = 2;
    public byte type = 0;
    public PingRsp arg = null;

    public PingHeader() {
    }

    public PingHeader(byte type, PingRsp arg) {
        this.type = type;
        this.arg = arg;
    }

    @Override
    public long size(short version) {
        long retval = 2L;
        if (this.arg != null) {
            retval += (long)this.arg.size(version);
        }
        return retval;
    }

    @Override
    public String toString() {
        return "[PING: type=" + this.type2Str(this.type) + ", arg=" + this.arg + ']';
    }

    String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "GET_MBRS_REQ";
            }
            case 2: {
                return "GET_MBRS_RSP";
            }
        }
        return "<unknown type (" + t + ")>";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeObject(this.arg);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readByte();
        this.arg = (PingRsp)in.readObject();
    }

    @Override
    public void writeTo(DataOutputStream outstream) throws IOException {
        outstream.writeByte(this.type);
        Util.writeStreamable(this.arg, outstream);
    }

    @Override
    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.type = instream.readByte();
        this.arg = (PingRsp)Util.readStreamable(PingRsp.class, instream);
    }
}

