/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class PingRsp
implements Serializable,
Streamable {
    public Address own_addr = null;
    public Address coord_addr = null;
    public boolean is_server = false;
    private static final long serialVersionUID = 3634334590904551586L;

    public PingRsp() {
    }

    public PingRsp(Address own_addr, Address coord_addr, boolean is_server) {
        this.own_addr = own_addr;
        this.coord_addr = coord_addr;
        this.is_server = is_server;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PingRsp)) {
            return false;
        }
        PingRsp other = (PingRsp)obj;
        return this.own_addr != null && other.own_addr != null && this.own_addr.equals(other.own_addr);
    }

    public int hashCode() {
        int result = 0;
        if (this.own_addr != null) {
            result += this.own_addr.hashCode();
        }
        return result;
    }

    public boolean isCoord() {
        if (!this.is_server) {
            return false;
        }
        if (this.own_addr != null && this.coord_addr != null) {
            return this.own_addr.equals(this.coord_addr);
        }
        return false;
    }

    public int size(short version) {
        int retval = 3;
        retval += 2;
        if (this.own_addr != null) {
            retval += this.own_addr.size(version);
        }
        if (this.coord_addr != null) {
            retval += this.coord_addr.size(version);
        }
        return retval;
    }

    public Address getAddress() {
        return this.own_addr;
    }

    public Address getCoordAddress() {
        return this.coord_addr;
    }

    public boolean isServer() {
        return this.is_server;
    }

    public String toString() {
        return new StringBuffer("[own_addr=").append(this.own_addr).append(", coord_addr=").append(this.coord_addr).append(", is_server=").append(this.is_server).append(']').toString();
    }

    @Override
    public void writeTo(DataOutputStream outstream) throws IOException {
        Util.writeAddress(this.own_addr, outstream);
        Util.writeAddress(this.coord_addr, outstream);
        outstream.writeBoolean(this.is_server);
    }

    @Override
    public void readFrom(DataInputStream instream) throws IOException, IllegalAccessException, InstantiationException {
        this.own_addr = Util.readAddress(instream);
        this.coord_addr = Util.readAddress(instream);
        this.is_server = instream.readBoolean();
    }
}

