/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Util;
import java.util.Vector;

public class QUEUE
extends Protocol {
    final Vector up_vec = new Vector();
    final Vector dn_vec = new Vector();
    boolean queueing_up = false;
    boolean queueing_dn = false;
    Observer my_observer = null;

    public void setObserver(Observer observer) {
        this.my_observer = observer;
    }

    public Vector getUpVector() {
        return this.up_vec;
    }

    public Vector getDownVector() {
        return this.dn_vec;
    }

    public boolean getQueueingUp() {
        return this.queueing_up;
    }

    public boolean getQueueingDown() {
        return this.queueing_dn;
    }

    @Override
    public String getName() {
        return "QUEUE";
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(22);
        ret.addElement(23);
        return ret;
    }

    @Override
    public Vector providedDownServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(22);
        ret.addElement(23);
        return ret;
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 22: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.QUEUE_RECEIVED_START_QUEUEING);
                }
                this.queueing_up = true;
                return;
            }
            case 23: {
                int i;
                Vector event_list = (Vector)evt.getArg();
                if (event_list != null) {
                    for (i = 0; i < event_list.size(); ++i) {
                        this.passUp((Event)event_list.elementAt(i));
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.QUEUE_REPLAYING_UP_EVENTS);
                }
                for (i = 0; i < this.up_vec.size(); ++i) {
                    Event e = (Event)this.up_vec.elementAt(i);
                    this.passUp(e);
                }
                this.up_vec.removeAllElements();
                this.queueing_up = false;
                return;
            }
        }
        if (this.queueing_up) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.QUEUE_QUEUED_UP_EVENT__0, evt);
            }
            if (this.my_observer != null && !this.my_observer.addingToUpVector(evt, this.up_vec.size())) {
                return;
            }
            this.up_vec.addElement(evt);
        } else {
            this.passUp(evt);
        }
    }

    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 22: {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.QUEUE_RECEIVED_START_QUEUEING);
                }
                this.queueing_dn = true;
                return;
            }
            case 23: {
                int i;
                Vector event_list;
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.QUEUE_RECEIVED_STOP_QUEUEING);
                }
                if ((event_list = (Vector)evt.getArg()) != null) {
                    for (i = 0; i < event_list.size(); ++i) {
                        this.passDown((Event)event_list.elementAt(i));
                    }
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.QUEUE_REPLAYING_DOWN_EVENTS__0, this.dn_vec.size());
                }
                for (i = 0; i < this.dn_vec.size(); ++i) {
                    this.passDown((Event)this.dn_vec.elementAt(i));
                }
                this.dn_vec.removeAllElements();
                this.queueing_dn = false;
                return;
            }
        }
        if (this.queueing_dn) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.QUEUE_QUEUED_DOWN_EVENT__0, Util.printEvent(evt));
            }
            if (this.my_observer != null && !this.my_observer.addingToDownVector(evt, this.dn_vec.size())) {
                return;
            }
            this.dn_vec.addElement(evt);
        } else {
            this.passDown(evt);
        }
    }

    public static interface Observer {
        public boolean addingToUpVector(Event var1, int var2);

        public boolean addingToDownVector(Event var1, int var2);
    }
}

