/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SIZE
extends Protocol {
    final Vector members = new Vector();
    boolean print_msg = false;
    boolean raw_buffer = false;
    long min_size = 0L;
    final ByteArrayOutputStream out_stream = new ByteArrayOutputStream(65535);

    @Override
    public String getName() {
        return "SIZE";
    }

    @Override
    public void init() {
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("print_msg");
        if (str != null) {
            this.print_msg = Boolean.valueOf(str);
            props.remove("print_msg");
        }
        if ((str = props.getProperty("raw_buffer")) != null) {
            this.raw_buffer = Boolean.valueOf(str);
            props.remove("raw_buffer");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Integer.parseInt(str);
            props.remove("min_size");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.SIZE_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    @Override
    public void up(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (trace) {
                        this.log.trace("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers");
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && trace) {
                        this.log.trace("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers");
                    }
                }
                if (!this.print_msg || !trace) break;
                this.log.trace("headers are " + msg.getHeaders() + ", payload size=" + payload_size);
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        int payload_size = 0;
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                payload_size = msg.getLength();
                if (this.raw_buffer) {
                    if (trace) {
                        this.log.trace("size of message buffer is " + payload_size + ", " + this.numHeaders(msg) + " headers");
                    }
                } else {
                    int serialized_size = this.sizeOf(msg);
                    if ((long)serialized_size > this.min_size && trace) {
                        this.log.trace("size of serialized message is " + serialized_size + ", " + this.numHeaders(msg) + " headers");
                    }
                }
                if (!this.print_msg || !trace) break;
                this.log.trace("headers are " + msg.getHeaders() + ", payload size=" + payload_size);
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sizeOf(Message msg) {
        DataOutputStream out = null;
        ByteArrayOutputStream byteArrayOutputStream = this.out_stream;
        synchronized (byteArrayOutputStream) {
            int n;
            try {
                this.out_stream.reset();
                out = new DataOutputStream(this.out_stream);
                msg.writeTo(out);
                out.flush();
                n = this.out_stream.size();
            }
            catch (Exception e) {
                int n2;
                try {
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    Util.closeOutputStream(out);
                    throw throwable;
                }
                Util.closeOutputStream(out);
                return n2;
            }
            Util.closeOutputStream(out);
            return n;
        }
    }

    int numHeaders(Message msg) {
        if (msg == null) {
            return 0;
        }
        Map hdrs = msg.getHeaders();
        return hdrs != null ? hdrs.size() : 0;
    }
}

