/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.org.jgroups.blocks.ConnectionTable;
import com.gemstone.org.jgroups.blocks.ConnectionTableNIO;
import com.gemstone.org.jgroups.protocols.TCP;
import java.net.InetAddress;
import java.util.Properties;

public class TCP_NIO
extends TCP {
    private int m_reader_threads = 8;
    private int m_writer_threads = 8;
    private int m_processor_threads = 10;
    private int m_processor_minThreads = 10;
    private int m_processor_maxThreads = 10;
    private int m_processor_queueSize = 100;
    private int m_processor_keepAliveTime = -1;

    @Override
    protected ConnectionTable getConnectionTable(long ri, long cet, InetAddress b_addr, InetAddress bc_addr, int s_port, int e_port) throws Exception {
        ConnectionTableNIO ct = null;
        if (ri == 0L && cet == 0L) {
            ct = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port);
        } else {
            if (ri == 0L) {
                ri = 5000L;
                if (this.warn) {
                    this.log.warn("reaper_interval was 0, set it to " + ri);
                }
            }
            if (cet == 0L) {
                cet = 300000L;
                if (this.warn) {
                    this.log.warn("conn_expire_time was 0, set it to " + cet);
                }
            }
            ct = new ConnectionTableNIO(this, b_addr, bc_addr, s_port, e_port, ri, cet);
        }
        return ct;
    }

    @Override
    public String getName() {
        return "TCP_NIO";
    }

    public int getReaderThreads() {
        return this.m_reader_threads;
    }

    public int getWriterThreads() {
        return this.m_writer_threads;
    }

    public int getProcessorThreads() {
        return this.m_processor_threads;
    }

    public int getProcessorMinThreads() {
        return this.m_processor_minThreads;
    }

    public int getProcessorMaxThreads() {
        return this.m_processor_maxThreads;
    }

    public int getProcessorQueueSize() {
        return this.m_processor_queueSize;
    }

    public int getProcessorKeepAliveTime() {
        return this.m_processor_keepAliveTime;
    }

    @Override
    public boolean setProperties(Properties props) {
        String str = props.getProperty("reader_threads");
        if (str != null) {
            this.m_reader_threads = Integer.parseInt(str);
            props.remove("reader_threads");
        }
        if ((str = props.getProperty("writer_threads")) != null) {
            this.m_writer_threads = Integer.parseInt(str);
            props.remove("writer_threads");
        }
        if ((str = props.getProperty("processor_threads")) != null) {
            this.m_processor_threads = Integer.parseInt(str);
            props.remove("processor_threads");
        }
        if ((str = props.getProperty("processor_minThreads")) != null) {
            this.m_processor_minThreads = Integer.parseInt(str);
            props.remove("processor_minThreads");
        }
        if ((str = props.getProperty("processor_maxThreads")) != null) {
            this.m_processor_maxThreads = Integer.parseInt(str);
            props.remove("processor_maxThreads");
        }
        if ((str = props.getProperty("processor_queueSize")) != null) {
            this.m_processor_queueSize = Integer.parseInt(str);
            props.remove("processor_queueSize");
        }
        if ((str = props.getProperty("processor_keepAliveTime")) != null) {
            this.m_processor_keepAliveTime = Integer.parseInt(str);
            props.remove("processor_keepAliveTime");
        }
        return super.setProperties(props);
    }
}

