/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.MessageAcks;
import com.gemstone.org.jgroups.protocols.SavedMessages;
import com.gemstone.org.jgroups.protocols.TotalRetransmissionThread;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public class TOTAL_OLD
extends Protocol {
    private static final String PROTOCOL_NAME = "TOTAL_OLD";
    private Address local_addr = null;
    private Vector members = new Vector();
    private long next_seq_id = -1L;
    private long next_seq_id_to_assign = -1L;
    private static final long INIT_SEQ_ID = 10L;
    private final SavedMessages queued_messages = new SavedMessages();
    private MessageAcks ack_history = null;
    private final TotalRetransmissionThread retrans_thread = new TotalRetransmissionThread(this);
    final GemFireTracer log = GemFireTracer.getLog(TOTAL_OLD.class);

    @Override
    public String getName() {
        return PROTOCOL_NAME;
    }

    @Override
    public void start() throws Exception {
        this.retrans_thread.start();
    }

    @Override
    public void stop() {
        this.retrans_thread.stopResendRequests();
    }

    public void reset() {
        this.next_seq_id = -1L;
        this.queued_messages.clearMessages();
        this.retrans_thread.reset();
    }

    protected long getNextSeqID() {
        return this.next_seq_id;
    }

    protected long getFirstQueuedSeqID() {
        return this.queued_messages.getFirstSeq();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                Object t = evt.getArg();
                if (t instanceof Address) {
                    this.local_addr = (Address)t;
                    break;
                }
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTALUP__COULD_NOT_CAST_LOCAL_ADDRESS_TO_AN_ADDRESS_OBJECT);
                break;
            }
            case 1: {
                Object t = evt.getArg();
                if (t instanceof Message) {
                    Message msg = (Message)t;
                    Header header = msg.removeHeader(this.getName());
                    if (header instanceof TotalHeader) {
                        TotalHeader hdr = (TotalHeader)header;
                        switch (hdr.total_header_type) {
                            case 0: {
                                this.passUp(evt);
                                return;
                            }
                            case 1: {
                                this.handleBCastMessage(msg, hdr.seq_id);
                                return;
                            }
                            case 2: {
                                if (!this.isSequencer()) return;
                                this.handleRequestMessage(msg);
                                return;
                            }
                            case 3: {
                                this.next_seq_id = hdr.seq_id;
                                return;
                            }
                            case 5: {
                                if (!this.isSequencer()) return;
                                Address address = msg.getSrc();
                                this.ack_history.setSeq(address, hdr.seq_id);
                                return;
                            }
                            case 7: {
                                if (!this.isSequencer()) return;
                                this.handleResendRequest(msg, hdr.seq_id);
                                return;
                            }
                            default: {
                                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDUP__UNRECOGNIZED_TOTALHEADER_IN_MESSAGE___0, hdr.toString());
                                return;
                            }
                        }
                    } else {
                        this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDUP__COULD_NOT_CAST_MESSAGE_HEADER_TO_TOTALHEADER_CASE_EVENTMSG);
                    }
                    return;
                } else {
                    this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDUP__COULD_NOT_CAST_ARGUMENT_OF_EVENT_TO_A_MESSAGE_CASE_EVENTMSG);
                }
                return;
            }
            case 6: 
            case 15: {
                System.out.println("View Change event passed up to TOTAL_OLD (debug - mms21)");
                View new_view = (View)evt.getArg();
                this.members = new_view.getMembers();
                System.out.println("New view members (printed in TOTAL_OLD):");
                int view_size = this.members.size();
                for (int i = 0; i < view_size; ++i) {
                    System.out.println("  " + this.members.elementAt(i).toString());
                }
                this.reset();
                if (!this.isSequencer()) break;
                this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDUP__I_AM_THE_SEQUENCER_OF_THIS_NEW_VIEW);
                this.ack_history = new MessageAcks(this.members);
                this.next_seq_id_to_assign = 10L;
                Message new_view_msg = new Message(null, this.local_addr, null);
                new_view_msg.putHeader(this.getName(), new TotalHeader(3, this.next_seq_id_to_assign));
                this.passDown(new Event(1, new_view_msg));
                break;
            }
        }
        this.passUp(evt);
    }

    private synchronized int passUpMessages() {
        if (this.next_seq_id < 0L) {
            return 0;
        }
        long lowest_seq_stored = this.queued_messages.getFirstSeq();
        if (lowest_seq_stored < 0L) {
            return 0;
        }
        if (lowest_seq_stored < this.next_seq_id) {
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDPASSUPMESSAGES__NEXT_EXPECTED_SEQUENCE_ID__0__IS_GREATER_THAN_THE_SEQUENCE_ID_OF_A_STORED_MESSAGE__1, new Object[]{this.next_seq_id, lowest_seq_stored});
            return 0;
        }
        if (this.next_seq_id == lowest_seq_stored) {
            Message msg = this.queued_messages.getFirstMessage();
            if (msg == null) {
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDPASSUPMESSAGES__UNEXPECTED_NULL_MESSAGE_RETRIEVED_FROM_STORED_MESSAGES);
                return 0;
            }
            this.passUp(new Event(1, msg));
            ++this.next_seq_id;
            return 1 + this.passUpMessages();
        }
        return 0;
    }

    private synchronized void handleBCastMessage(Message msg, long seq) {
        if (seq < this.next_seq_id) {
            return;
        }
        this.queued_messages.insertMessage(msg, seq);
        int num_passed = this.passUpMessages();
        if (num_passed > 1) {
            this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDHANDLEBCASTMESSAGE___0__MESSAGES_PASSED_UP_THE_PROTOCOL_STACK, num_passed);
        }
    }

    private synchronized void handleRequestMessage(Message msg) {
        if (this.next_seq_id_to_assign < 0L) {
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDHANDLEREQUESTMESSAGE__CANNOT_HANDLE_REQUEST_DO_NOT_KNOW_WHAT_SEQUENCE_ID_TO_ASSIGN);
            return;
        }
        msg.setDest(null);
        msg.setSrc(this.local_addr);
        msg.putHeader(this.getName(), new TotalHeader(1, this.next_seq_id_to_assign));
        Message msg_copy = msg.copy();
        this.ack_history.addMessage(msg_copy, this.next_seq_id_to_assign);
        Object header = msg_copy.getHeader(this.getName());
        if (!(header instanceof TotalHeader)) {
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDHANDLEREQUESTMESSAGE__BAD_STORED_MESSAGE_THAT_DID_NOT_CONTAIN_A_TOTALHEADER___0, this.next_seq_id_to_assign);
        }
        ++this.next_seq_id_to_assign;
        this.passDown(new Event(1, msg));
    }

    private synchronized void handleResendRequest(Message msg, long seq) {
        this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDHANDLEREQUESTMESSAGE__RECEIVED_RESEND_REQUEST_FOR_MESSAGE__0, seq);
        Address requester = null;
        Message resend_msg = this.ack_history.getMessage(seq);
        if (resend_msg == null) {
            this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDHANDLERESENDREQUEST__COULD_NOT_FIND_THE_MESSAGE__0__IN_THE_HISTORY_TO_RESEND, seq);
            return;
        }
        resend_msg.setDest(requester);
        Object header = resend_msg.getHeader(this.getName());
        if (!(header instanceof TotalHeader)) {
            this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLD_RESEND_MSG_BAD_HEADER_IS_NOT_A_TOTALHEADER___0, seq);
        }
        this.passDown(new Event(1, resend_msg));
        this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDHANDLERESENDREQUEST__RESPONDED_TO_RESEND_REQUEST_FOR_MESSAGE__0, seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.log.error(JGroupsStrings.TOTAL_OLD_NOTE_VIEW_CHANGE_EVENT_GOING_DOWN_THROUGH__0, PROTOCOL_NAME);
                Vector new_members = ((View)evt.getArg()).getMembers();
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int i = 0; i < new_members.size(); ++i) {
                            this.members.addElement(new_members.elementAt(i));
                        }
                    }
                    break;
                }
            }
            case 1: {
                Object temp_obj = evt.getArg();
                if (temp_obj instanceof Message) {
                    Message msg = (Message)temp_obj;
                    if (msg.getDest() == null) {
                        Address sequencer = this.getSequencer();
                        if (sequencer != null) {
                            msg.setDest(sequencer);
                        }
                        msg.putHeader(this.getName(), new TotalHeader(2, -1L));
                        break;
                    }
                    msg.putHeader(this.getName(), new TotalHeader(0, -1L));
                    break;
                }
                this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDDOWN__COULD_NOT_CAST_ARGUMENT_OF_EVENT_TO_A_MESSAGE_CASE_EVENTMSG);
                break;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSequencer() {
        if (this.local_addr == null) {
            this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDISSEQUENCER__LOCAL_ADDRESS_UNKNOWN);
            return false;
        }
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDISSEQUENCER__NO_MEMBERS);
                return false;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                Address seq_addr = (Address)temp_obj;
                return this.local_addr.equals(seq_addr);
            }
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDISSEQUENCER__COULD_NOT_CAST_ELEMENT_OF_MEMBERS_TO_AN_ADDRESS);
            return false;
        }
    }

    protected Address getLocalAddr() {
        return this.local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address getSequencer() {
        Vector vector = this.members;
        synchronized (vector) {
            if (this.members.size() == 0) {
                this.log.error(JGroupsStrings.TOTAL_OLD_TOTAL_OLDGETSEQUENCER__NO_MEMBERS);
                return null;
            }
            Object temp_obj = this.members.elementAt(0);
            if (temp_obj instanceof Address) {
                return (Address)temp_obj;
            }
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTAL_OLDGETSEQUENCER__COULD_NOT_CAST_FIRST_ELEMENT_OF_MEMBERS_TO_AN_ADDRESS);
            return null;
        }
    }

    public static class TotalHeader
    extends Header {
        public static final int TOTAL_UNICAST = 0;
        public static final int TOTAL_BCAST = 1;
        public static final int TOTAL_REQUEST = 2;
        public static final int TOTAL_NEW_VIEW = 3;
        public static final int TOTAL_NEW_VIEW_ACK = 4;
        public static final int TOTAL_CUM_SEQ_ACK = 5;
        public static final int TOTAL_SEQ_ACK = 6;
        public static final int TOTAL_RESEND = 7;
        public int total_header_type;
        final GemFireTracer log = GemFireTracer.getLog(TotalHeader.class);
        public long seq_id;

        public TotalHeader() {
        }

        public TotalHeader(int type, long seq) {
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.total_header_type = type;
                    break;
                }
                default: {
                    this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTALHEADERTOTALHEADER__UNKNOWN_TOTALHEADER_TYPE_GIVEN__0, type);
                    this.total_header_type = -1;
                }
            }
            this.seq_id = seq;
        }

        @Override
        public String toString() {
            String type = "";
            switch (this.total_header_type) {
                case 0: {
                    type = "TOTAL_UNICAST";
                    break;
                }
                case 1: {
                    type = "TOTAL_BCAST";
                    break;
                }
                case 2: {
                    type = "TOTAL_REQUEST";
                    break;
                }
                case 3: {
                    type = "NEW_VIEW";
                    break;
                }
                case 4: {
                    type = "NEW_VIEW_ACK";
                    break;
                }
                case 5: {
                    type = "TOTAL_CUM_SEQ_ACK";
                    break;
                }
                case 6: {
                    type = "TOTAL_SEQ_ACK";
                    break;
                }
                case 7: {
                    type = "TOTAL_RESEND";
                    break;
                }
                default: {
                    type = "UNKNOWN TYPE (" + this.total_header_type + ')';
                }
            }
            return "[ TOTAL_OLD: type=" + type + ", seq=" + this.seq_id + " ]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.total_header_type);
            out.writeLong(this.seq_id);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.total_header_type = in.readInt();
            this.seq_id = in.readLong();
        }
    }
}

