/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.protocols.pbcast.Digest;
import com.gemstone.org.jgroups.protocols.ring.RingNodeFlowControl;
import com.gemstone.org.jgroups.protocols.ring.RingToken;
import com.gemstone.org.jgroups.protocols.ring.TokenLostException;
import com.gemstone.org.jgroups.protocols.ring.UdpRingNode;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.RpcProtocol;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class TOTAL_TOKEN
extends RpcProtocol {
    private static final int OPERATIONAL_STATE = 0;
    private static final int RECOVERY_STATE = 1;
    UdpRingNode node;
    RingNodeFlowControl flowControl;
    Address localAddress;
    final TokenTransmitter tokenRetransmitter = new TokenTransmitter();
    List newMessagesQueue;
    SortedSet liveMembersInRecovery;
    SortedSet suspects;
    final Object mutex = new Object();
    TreeMap receivedMessagesQueue;
    long myAru = 0L;
    final Object threadCoordinationMutex = new Object();
    static final boolean tokenInStack = false;
    static final boolean threadDeliveringMessage = false;
    boolean tokenSeen = false;
    volatile boolean isRecoveryLeader = false;
    volatile int state;
    volatile int sleepTime = 10;
    long highestSeenSeq = 0L;
    long lastRoundTokensAru = 0L;
    int lastRoundTransmitCount;
    int blockSendingBacklogThreshold = Integer.MAX_VALUE;
    int unblockSendingBacklogThreshold = Integer.MIN_VALUE;
    boolean tokenCirculating = false;
    boolean senderBlocked = false;
    public static final String prot_name = "TOTAL_TOKEN";

    @Override
    public String getName() {
        return prot_name;
    }

    private String getState() {
        if (this.state == 0) {
            return "OPERATIONAL";
        }
        return "RECOVERY";
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.newMessagesQueue = Collections.synchronizedList(new ArrayList());
        this.receivedMessagesQueue = new TreeMap();
        this.tokenRetransmitter.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.tokenRetransmitter.shutDown();
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("block_sending");
        if (str != null) {
            this.blockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("block_sending");
        }
        if ((str = props.getProperty("unblock_sending")) != null) {
            this.unblockSendingBacklogThreshold = Integer.parseInt(str);
            props.remove("unblock_sending");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.TOTAL_TOKEN_UDPSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        return true;
    }

    public IpAddress getTokenReceiverAddress() {
        return this.node != null ? this.node.getTokenReceiverAddress() : null;
    }

    @Override
    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(39);
        retval.addElement(42);
        retval.addElement(41);
        return retval;
    }

    @Override
    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.localAddress = (Address)evt.getArg();
                this.node = new UdpRingNode(this, this.localAddress);
                this.flowControl = new RingNodeFlowControl();
                break;
            }
            case 9: {
                Address suspect = ((SuspectMember)evt.getArg()).suspectedMember;
                this.onSuspectMessage(suspect);
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header h = (Header)msg.getHeader(this.getName());
                if (h instanceof TotalTokenHeader) {
                    this.messageArrived(msg);
                    return false;
                }
                if (!(h instanceof RingTokenHeader)) break;
                if (this.node != null) {
                    Object tmp = msg.getObject();
                    this.node.tokenArrived(tmp);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 39: 
            case 42: {
                Digest d = new Digest(this.members.size());
                Address sender = null;
                for (int j = 0; j < this.members.size(); ++j) {
                    sender = (Address)this.members.elementAt(j);
                    d.add(sender, this.highestSeenSeq, this.highestSeenSeq);
                }
                this.passUp(new Event(40, d));
                return false;
            }
            case 41: {
                Digest receivedDigest = (Digest)evt.getArg();
                this.myAru = receivedDigest.highSeqnoAt(this.localAddress);
                return false;
            }
            case 6: {
                this.onViewChange();
                return true;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg == null) {
                    return false;
                }
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.newMessagesQueue.add(msg);
                return false;
            }
        }
        return true;
    }

    private void onViewChange() {
        this.isRecoveryLeader = false;
        if (this.suspects != null) {
            this.suspects.clear();
            this.suspects = null;
        }
        if (this.liveMembersInRecovery != null) {
            this.liveMembersInRecovery.clear();
            this.liveMembersInRecovery = null;
        }
    }

    private void onSuspectMessage(Address suspect) {
        this.state = 1;
        if (this.suspects == null || this.suspects.size() == 0) {
            this.suspects = Collections.synchronizedSortedSet(new TreeSet());
            this.liveMembersInRecovery = Collections.synchronizedSortedSet(new TreeSet(this.members));
        }
        this.suspects.add(suspect);
        this.liveMembersInRecovery.removeAll(this.suspects);
        this.isRecoveryLeader = this.isRecoveryLeader(this.liveMembersInRecovery);
    }

    private boolean isRecoveryLeader(SortedSet liveMembers) {
        boolean recoveryLeader = false;
        if (liveMembers.size() > 0) {
            recoveryLeader = this.localAddress.equals(liveMembers.first());
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.TOTAL_TOKEN_LIVE_MEMEBERS_ARE__0, liveMembers);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.TOTAL_TOKEN_I_AM_RECOVERY_LEADER_0, recoveryLeader);
        }
        return recoveryLeader;
    }

    public long getAllReceivedUpTo() {
        return this.myAru;
    }

    public void installTransitionalView(Vector members) {
        if (this.node != null) {
            this.node.reconfigure(members);
        }
    }

    protected void recover() {
        if (this.isRecoveryLeader && this.state == 1) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_I_AM_STARTING_RECOVERY_NOW);
            }
            Vector m = new Vector(this.liveMembersInRecovery);
            RspList list = this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
            Vector myAllReceivedUpTos = list.getResults();
            this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
            Vector myAllReceivedUpTosConfirm = list.getResults();
            while (!myAllReceivedUpTos.equals(myAllReceivedUpTosConfirm)) {
                myAllReceivedUpTos = myAllReceivedUpTosConfirm;
                this.callRemoteMethods(m, "getAllReceivedUpTo", new Object[0], new Class[0], 2, 0L);
                myAllReceivedUpTosConfirm = list.getResults();
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.TOTAL_TOKEN_MYALLRECEIVEDUPTO_VALUES_ARE_0, myAllReceivedUpTos);
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info(JGroupsStrings.TOTAL_TOKEN_MYALLRECEIVEDUPTO_CONFIRM_VALUES_ARE__0, myAllReceivedUpTosConfirm);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_MYALLRECEIVEDUPTO_STABILIZED_VALUES_ARE_0, myAllReceivedUpTos);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_INSTALLING_TRANSITIONAL_VIEW_TO_REPAIR_THE_RING);
            }
            this.callRemoteMethods(m, "installTransitionalView", new Object[]{m}, new String[]{Vector.class.getName()}, 2, 0L);
            Vector xmits = this.prepareRecoveryRetransmissionList(myAllReceivedUpTos);
            RingToken injectToken = null;
            if (xmits.size() > 1) {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.TOTAL_TOKEN_VS_NOT_SATISFIED_INJECTING_RECOVERY_TOKEN);
                }
                long aru = (Long)xmits.firstElement();
                long highest = (Long)xmits.lastElement();
                injectToken = new RingToken(1);
                injectToken.setHighestSequence(highest);
                injectToken.setAllReceivedUpto(aru);
                Collection rtr = injectToken.getRetransmissionRequests();
                rtr.addAll(xmits);
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info(JGroupsStrings.TOTAL_TOKEN_VS_SATISFIED_INJECTING_OPERATIONAL_TOKEN);
                }
                injectToken = new RingToken();
                long sequence = (Long)xmits.firstElement();
                injectToken.setHighestSequence(sequence);
                injectToken.setAllReceivedUpto(sequence);
            }
            if (this.node != null) {
                this.node.passToken(injectToken);
            }
            this.tokenRetransmitter.resetTimeout();
        }
    }

    private Vector prepareRecoveryRetransmissionList(Vector sequences) {
        Collections.sort(sequences);
        Long first = (Long)sequences.firstElement();
        Long last = (Long)sequences.lastElement();
        Vector<Long> retransmissions = new Vector<Long>();
        if (first.equals(last)) {
            retransmissions.add(first);
        } else {
            for (long j = first + 1L; j <= last; ++j) {
                retransmissions.add(j);
            }
        }
        return retransmissions;
    }

    @Override
    protected void updateView(View newMembers) {
        super.updateView(newMembers);
        Vector newViewMembers = newMembers.getMembers();
        this.flowControl.viewChanged(newViewMembers.size());
        if (this.node != null) {
            this.node.reconfigure(newViewMembers);
        }
        boolean isCoordinator = this.localAddress.equals(newViewMembers.firstElement());
        int memberSize = newViewMembers.size();
        if (memberSize == 1 && isCoordinator && !this.tokenCirculating) {
            this.tokenCirculating = true;
            RingToken token = new RingToken();
            if (this.node != null) {
                this.node.passToken(token);
            }
            this.tokenRetransmitter.resetTimeout();
        }
        this.sleepTime = 20 / memberSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageArrived(Message m) {
        TotalTokenHeader h = (TotalTokenHeader)m.getHeader(this.getName());
        long seq = h.getSeq();
        Object object = this.mutex;
        synchronized (object) {
            if (this.myAru + 1L <= seq) {
                if (seq > this.highestSeenSeq) {
                    this.highestSeenSeq = seq;
                }
                this.receivedMessagesQueue.put(seq, m);
                if (this.myAru + 1L == seq) {
                    this.myAru = seq;
                    this.passUp(new Event(1, m));
                }
                if (this.isReceiveQueueHolePlugged()) {
                    this.myAru = this.deliverMissingMessages();
                }
            }
        }
    }

    private boolean isReceiveQueueHolePlugged() {
        return this.myAru < this.highestSeenSeq && this.receivedMessagesQueue.containsKey(this.myAru + 1L);
    }

    private long deliverMissingMessages() {
        Map.Entry entry = null;
        boolean inOrder = true;
        long lastDelivered = this.myAru;
        Set deliverySet = this.receivedMessagesQueue.tailMap(this.myAru + 1L).entrySet();
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.TOTAL_TOKEN_HOLE_GETTING_PLUGGED_PRIOR_MUARU__0, this.myAru);
        }
        Iterator iterator = deliverySet.iterator();
        while (inOrder && iterator.hasNext()) {
            entry = iterator.next();
            long nextInQueue = entry.getKey();
            if (lastDelivered + 1L == nextInQueue) {
                Message m = (Message)entry.getValue();
                this.passUp(new Event(1, m));
                ++lastDelivered;
                continue;
            }
            inOrder = false;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(JGroupsStrings.TOTAL_TOKEN_HOLE_GETTING_PLUGGED_POST_MUARU__0, lastDelivered);
        }
        return lastDelivered;
    }

    private void updateTokenRtR(RingToken token) {
        long holeLowerBound = 0L;
        long holeUpperBound = 0L;
        Long missingSequence = null;
        Collection retransmissionList = null;
        if (this.myAru < token.getHighestSequence()) {
            retransmissionList = token.getRetransmissionRequests();
            Set<Long> received = this.receivedMessagesQueue.tailMap(this.myAru + 1L).keySet();
            Iterator<Long> nonMissing = received.iterator();
            holeLowerBound = this.myAru;
            if (this.log.isDebugEnabled()) {
                this.log.debug("retransmission request prior" + retransmissionList);
            }
            while (nonMissing.hasNext()) {
                Long seq = nonMissing.next();
                holeUpperBound = seq;
                while (holeLowerBound < holeUpperBound) {
                    missingSequence = ++holeLowerBound;
                    retransmissionList.add(missingSequence);
                }
                holeLowerBound = holeUpperBound;
            }
            holeUpperBound = token.getHighestSequence();
            while (holeLowerBound < holeUpperBound) {
                missingSequence = ++holeLowerBound;
                retransmissionList.add(missingSequence);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("retransmission request after" + retransmissionList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int broadcastMessages(int allowedCount, RingToken token) {
        ArrayList sendList = null;
        List list = this.newMessagesQueue;
        synchronized (list) {
            int queueSize = this.newMessagesQueue.size();
            if (queueSize <= 0) {
                return 0;
            }
            if (queueSize > allowedCount) {
                sendList = new ArrayList(this.newMessagesQueue.subList(0, allowedCount));
                this.newMessagesQueue.removeAll(sendList);
            } else {
                sendList = new ArrayList();
                sendList.addAll(this.newMessagesQueue);
                this.newMessagesQueue.clear();
            }
        }
        long tokenSeq = token.getHighestSequence();
        for (Message m : sendList) {
            m.setSrc(this.localAddress);
            m.setDest(null);
            m.putHeader(this.getName(), new TotalTokenHeader(++tokenSeq));
            this.receivedMessagesQueue.put(tokenSeq, m);
            this.passDown(new Event(1, m));
        }
        if (token.getHighestSequence() == token.getAllReceivedUpto()) {
            token.setAllReceivedUpto(tokenSeq);
        }
        token.setHighestSequence(tokenSeq);
        return sendList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tokenReceived(RingToken token) {
        if (this.log.isInfoEnabled()) {
            this.log.info(token.toString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getState());
        }
        this.flowControl.setBacklog(this.newMessagesQueue.size());
        this.flowControl.updateWindow(token);
        this.blockSenderIfRequired();
        this.unBlockSenderIfAcceptable();
        long tokensAru = 0L;
        int broadcastCount = 0;
        int rebroadcastCount = 0;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.tokenSeen) {
                long lastRoundAru = token.getHighestSequence() - (long)token.getLastRoundBroadcastCount();
                if (this.myAru < token.getAllReceivedUpto()) {
                    this.myAru = lastRoundAru;
                }
                this.tokenSeen = true;
            }
            if (token.getType() == 1) {
                this.highestSeenSeq = token.getHighestSequence();
                if (this.highestSeenSeq == this.myAru) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info(JGroupsStrings.TOTAL_TOKEN_MEMBER_NODE_RECOVERED);
                    }
                    token.addRecoveredMember(this.localAddress);
                }
            }
            this.updateTokenRtR(token);
            int allowedToBroadcast = this.flowControl.getAllowedToBroadcast(token);
            rebroadcastCount = this.rebroadcastMessages(token);
            allowedToBroadcast -= rebroadcastCount;
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_MYALLRECEIVEDUPTO_0, this.myAru);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_ALLOWEDTOBROADCAST_0, allowedToBroadcast);
            }
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_NEWMESSAGESQUEUESIZE_0, this.newMessagesQueue.size());
            }
            if (this.myAru < (tokensAru = token.getAllReceivedUpto()) || this.localAddress.equals(token.getAruId()) || token.getAruId() == null) {
                token.setAllReceivedUpto(this.myAru);
                if (token.getAllReceivedUpto() == token.getHighestSequence()) {
                    token.setAruId(null);
                } else {
                    token.setAruId(this.localAddress);
                }
            }
            if (allowedToBroadcast > 0 && token.getType() == 0) {
                broadcastCount = this.broadcastMessages(allowedToBroadcast, token);
            }
            if (tokensAru > this.lastRoundTokensAru) {
                this.removeStableMessages(this.receivedMessagesQueue, this.lastRoundTokensAru);
            }
        }
        try {
            Util.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        token.incrementTokenSequence();
        token.addLastRoundBroadcastCount(broadcastCount - this.lastRoundTransmitCount);
        token.addBacklog(this.flowControl.getBacklogDifference());
        this.flowControl.setPreviousBacklog();
        this.lastRoundTransmitCount = broadcastCount;
        this.lastRoundTokensAru = tokensAru;
    }

    private int rebroadcastMessages(RingToken token) {
        Collection rbl;
        int rebroadCastCount = 0;
        Collection rexmitRequests = token.getRetransmissionRequests();
        if (rexmitRequests.size() > 0 && (rebroadCastCount = (rbl = this.getRebroadcastList(rexmitRequests)).size()) > 0) {
            if (this.log.isInfoEnabled()) {
                this.log.info(JGroupsStrings.TOTAL_TOKEN_REBROADCASTING__0, rbl);
            }
            Long s2 = null;
            for (Long s2 : rbl) {
                Message m = (Message)this.receivedMessagesQueue.get(s2);
                this.passDown(new Event(1, m));
            }
        }
        return rebroadCastCount;
    }

    protected void invalidateOnTokenloss() {
        this.lastRoundTransmitCount = 0;
        this.flowControl.invalidate();
    }

    private void blockSenderIfRequired() {
        if (!this.senderBlocked && this.flowControl.getBacklog() > this.blockSendingBacklogThreshold) {
            this.passUp(new Event(54));
            this.senderBlocked = true;
        }
    }

    private void unBlockSenderIfAcceptable() {
        if (this.senderBlocked && this.flowControl.getBacklog() < this.unblockSendingBacklogThreshold) {
            this.passUp(new Event(55));
            this.senderBlocked = false;
        }
    }

    private void removeStableMessages(TreeMap m, long upToSeq) {
        if (m.size() > 0) {
            long first = (Long)m.firstKey();
            if (first > upToSeq) {
                upToSeq = first;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("cutting queue first key " + m.firstKey() + " cut at " + upToSeq + " last key " + m.lastKey());
            }
            SortedMap stable = m.headMap(upToSeq);
            stable.clear();
        }
    }

    private Collection getRebroadcastList(Collection rtr) {
        ArrayList rebroadcastList = new ArrayList(rtr);
        rebroadcastList.retainAll(this.receivedMessagesQueue.keySet());
        rtr.removeAll(rebroadcastList);
        Collections.sort(rebroadcastList);
        return rebroadcastList;
    }

    protected class TokenTransmitter
    extends Thread {
        long rtt;
        long timer;
        double srtt;
        static final double a = 0.09;
        static final int timeoutFactor = 10;
        volatile boolean running;

        TokenTransmitter() {
            super("TokenTransmitter");
            this.rtt = 0L;
            this.srtt = 1000.0;
            this.running = false;
            this.resetTimeout();
            this.running = true;
        }

        protected void shutDown() {
            this.running = false;
        }

        private void recalculateTimeout() {
            long now = System.currentTimeMillis();
            if (this.timer > 0L) {
                this.rtt = now - this.timer;
                this.srtt = 0.91 * this.srtt + 0.09 * (double)this.rtt;
            }
        }

        private double getTimeout() {
            return this.srtt * 10.0;
        }

        protected void resetTimeout() {
            this.timer = System.currentTimeMillis();
        }

        private boolean isRecoveryCompleted(RingToken token) {
            return TOTAL_TOKEN.this.liveMembersInRecovery.equals(token.getRecoveredMembers());
        }

        @Override
        public void run() {
            while (this.running) {
                SystemFailure.checkFailure();
                RingToken token = null;
                int timeout = 0;
                if (TOTAL_TOKEN.this.node == null) {
                    try {
                        Util.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                try {
                    timeout = (int)this.getTimeout();
                    if (TOTAL_TOKEN.this.log.isInfoEnabled()) {
                        TOTAL_TOKEN.this.log.info(JGroupsStrings.TOTAL_TOKEN_TIMEOUTMS_0, timeout);
                    }
                    if ((token = (RingToken)TOTAL_TOKEN.this.node.receiveToken(timeout)).getType() == 0 && TOTAL_TOKEN.this.state == 1) {
                        TOTAL_TOKEN.this.state = 0;
                    }
                    TOTAL_TOKEN.this.tokenReceived(token);
                    this.recalculateTimeout();
                    if (token.getType() == 1 && this.isRecoveryCompleted(token)) {
                        if (TOTAL_TOKEN.this.log.isInfoEnabled()) {
                            TOTAL_TOKEN.this.log.info(JGroupsStrings.TOTAL_TOKEN_ALL_MEMBERS_RECOVERED_INJECTING_OPERATIONAL_TOKEN);
                        }
                        token.setType(0);
                    }
                    TOTAL_TOKEN.this.node.passToken(token);
                    this.resetTimeout();
                }
                catch (TokenLostException tle) {
                    TOTAL_TOKEN.this.invalidateOnTokenloss();
                    TOTAL_TOKEN.this.state = 1;
                    TOTAL_TOKEN.this.recover();
                }
            }
        }
    }

    public static class RingTokenHeader
    extends Header {
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public long size(short version) {
            return 110L;
        }
    }

    public static class TotalTokenHeader
    extends Header {
        private long seq;

        public TotalTokenHeader() {
        }

        public TotalTokenHeader(long seq) {
            this.seq = seq;
        }

        public TotalTokenHeader(Long seq) {
            this.seq = seq;
        }

        public long getSeq() {
            return this.seq;
        }

        @Override
        public long size(short version) {
            return 121L;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.seq);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.seq = in.readLong();
        }

        @Override
        public String toString() {
            return "[TotalTokenHeader=" + this.seq + ']';
        }
    }
}

