/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.JGroupsVersion;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.BoundedLinkedQueue;
import com.gemstone.org.jgroups.protocols.AUTOCONF;
import com.gemstone.org.jgroups.protocols.TpHeader;
import com.gemstone.org.jgroups.protocols.pbcast.NAKACK;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Buffer;
import com.gemstone.org.jgroups.util.ExposedBufferedInputStream;
import com.gemstone.org.jgroups.util.ExposedBufferedOutputStream;
import com.gemstone.org.jgroups.util.ExposedByteArrayInputStream;
import com.gemstone.org.jgroups.util.ExposedByteArrayOutputStream;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.logging.log4j.Logger;

public abstract class TP
extends Protocol {
    private static final Logger logger = LogService.getLogger();
    public static final boolean VERBOSE = Boolean.getBoolean("TP.VERBOSE") || Boolean.getBoolean("DistributionManager.DEBUG_JAVAGROUPS");
    Address local_addr = null;
    String channel_name = null;
    InetAddress bind_addr = null;
    boolean receive_on_all_interfaces = false;
    List receive_interfaces = null;
    boolean send_on_all_interfaces = false;
    List send_interfaces = null;
    int bind_port = 0;
    int port_range = 1;
    final Vector members = new Vector(11);
    View view = null;
    final ExposedByteArrayInputStream in_stream = new ExposedByteArrayInputStream(new byte[]{48});
    final ExposedBufferedInputStream buf_in_stream = new ExposedBufferedInputStream(this.in_stream);
    final DataInputStream dis = new DataInputStream(this.buf_in_stream);
    boolean loopback = false;
    boolean discard_incompatible_packets = false;
    boolean use_incoming_packet_handler = false;
    Queue incoming_packet_queue = null;
    IncomingPacketHandler incoming_packet_handler = null;
    Queue incoming_msg_queue = null;
    IncomingMessageHandler incoming_msg_handler;
    boolean use_outgoing_packet_handler = false;
    BoundedLinkedQueue outgoing_queue = null;
    int outgoing_queue_max_size = 2000;
    OutgoingPacketHandler outgoing_packet_handler = null;
    byte[] additional_data = null;
    int max_bundle_size = AUTOCONF.senseMaxFragSizeStatic();
    long max_bundle_timeout = 20L;
    boolean enable_bundling = false;
    Bundler bundler = null;
    TimeScheduler timer = null;
    DiagnosticsHandler diag_handler = null;
    boolean enable_diagnostics = true;
    String diagnostics_addr = "224.0.0.75";
    int diagnostics_port = 7500;
    TpHeader header;
    final String name = this.getName();
    static final byte LIST = 1;
    static final byte MULTICAST = 2;
    long num_msgs_sent = 0L;
    long num_msgs_received = 0L;
    long num_bytes_sent = 0L;
    long num_bytes_received = 0L;
    static transient NumberFormat f = NumberFormat.getNumberInstance();
    private boolean pongReceived;
    private final Object pongSync = new Object();
    private short multicastVersion = Version.GFE_71.ordinal();

    public static void loadEmergencyClasses() {
    }

    public void emergencyClose() {
        DiagnosticsHandler ds = this.diag_handler;
        if (ds != null) {
            Thread thr;
            MulticastSocket ms = ds.diag_sock;
            if (ms != null) {
                ms.close();
            }
            if ((thr = ds.t) != null) {
                thr.interrupt();
            }
        }
    }

    protected TP() {
    }

    public String toString() {
        return this.name + "(local address: " + this.local_addr + ')';
    }

    @Override
    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public String getBindAddress() {
        return this.bind_addr != null ? this.bind_addr.toString() : "null";
    }

    public InetAddress getInetBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(String bind_addr) throws UnknownHostException {
        this.bind_addr = InetAddress.getByName(bind_addr);
    }

    @Deprecated
    public boolean getBindToAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public boolean isSendOnAllInterfaces() {
        return this.send_on_all_interfaces;
    }

    public List getSendInterfaces() {
        return this.send_interfaces;
    }

    public boolean isDiscardIncompatiblePackets() {
        return this.discard_incompatible_packets;
    }

    public void setDiscardIncompatiblePackets(boolean flag) {
        this.discard_incompatible_packets = flag;
    }

    public boolean isEnableBundling() {
        return this.enable_bundling;
    }

    public void setEnableBundling(boolean flag) {
        this.enable_bundling = flag;
    }

    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    public void setMaxBundleSize(int size2) {
        this.max_bundle_size = size2;
    }

    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    public void setMaxBundleTimeout(long timeout) {
        this.max_bundle_timeout = timeout;
    }

    public int getOutgoingQueueSize() {
        return this.outgoing_queue != null ? this.outgoing_queue.size() : 0;
    }

    public int getIncomingQueueSize() {
        return this.incoming_packet_queue != null ? this.incoming_packet_queue.size() : 0;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public String getChannelName() {
        return this.channel_name;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean b) {
        this.loopback = b;
    }

    public boolean isUseIncomingPacketHandler() {
        return this.use_incoming_packet_handler;
    }

    public boolean isUseOutgoingPacketHandler() {
        return this.use_outgoing_packet_handler;
    }

    public int getOutgoingQueueMaxSize() {
        return this.outgoing_queue != null ? this.outgoing_queue_max_size : 0;
    }

    public void setOutgoingQueueMaxSize(int new_size) {
        if (this.outgoing_queue != null) {
            this.outgoing_queue.setCapacity(new_size);
            this.outgoing_queue_max_size = new_size;
        }
    }

    @Override
    public Map dumpStats() {
        HashMap<String, Long> retval = super.dumpStats();
        if (retval == null) {
            retval = new HashMap<String, Long>();
        }
        retval.put("num_msgs_sent", this.num_msgs_sent);
        retval.put("num_msgs_received", this.num_msgs_received);
        retval.put("num_bytes_sent", this.num_bytes_sent);
        retval.put("num_bytes_received", this.num_bytes_received);
        return retval;
    }

    public abstract void sendToAllMembers(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendToSingleMember(Address var1, boolean var2, byte[] var3, int var4, int var5) throws Exception;

    public abstract String getInfo();

    public abstract void postUnmarshalling(Message var1, Address var2, Address var3, boolean var4);

    public abstract void postUnmarshallingList(Message var1, Address var2, boolean var3);

    private String _getInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.local_addr).append(" (").append(this.channel_name).append(") ").append("\n");
        sb.append("local_addr=").append(this.local_addr).append("\n");
        sb.append("group_name=").append(this.channel_name).append("\n");
        sb.append("Version=").append("2.2.9.1.3").append(", cvs=\"").append("$Id: Version.java,v 1.27 2005/12/27 14:52:48 belaban Exp $").append("\"\n");
        sb.append("view: ").append(this.view).append('\n');
        sb.append(this.getInfo());
        return sb.toString();
    }

    protected void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
        block11: {
            try {
                StringTokenizer tok = new StringTokenizer(request);
                String req = tok.nextToken();
                String info = "n/a";
                if (req.trim().toLowerCase().startsWith("query")) {
                    ArrayList<String> l = new ArrayList<String>(tok.countTokens());
                    while (tok.hasMoreTokens()) {
                        l.add(tok.nextToken().trim().toLowerCase());
                    }
                    info = this._getInfo();
                    if (l.contains("jmx")) {
                        Channel ch;
                        if (info == null) {
                            info = "";
                        }
                        if ((ch = this.stack.getChannel()) != null) {
                            Map m = ch.dumpStats();
                            StringBuffer sb = new StringBuffer();
                            sb.append("stats:\n");
                            Iterator it = m.entrySet().iterator();
                            while (it.hasNext()) {
                                sb.append(it.next()).append("\n");
                            }
                            info = info + sb.toString();
                        }
                    }
                    if (l.contains("props")) {
                        String p = this.stack.printProtocolSpecAsXML();
                        info = info + "\nprops:\n" + p;
                    }
                }
                byte[] diag_rsp = info.getBytes();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("sending diag response to " + sender);
                }
                this.sendResponse(sock, sender, diag_rsp);
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block11;
                this.log.error(JGroupsStrings.TP_FAILED_SENDING_DIAG_RSP_TO__0, sender, t);
            }
        }
    }

    private void sendPingResponse(Address asender) {
        block3: {
            byte[] msgbuf = new byte[]{112, 111, 110, 103};
            IpAddress sender = (IpAddress)asender;
            sender.setName("");
            if (logger.isDebugEnabled()) {
                logger.debug("Responding to ping-pong request from {}", sender);
            }
            try {
                this.doSend(new Buffer(msgbuf, 0, msgbuf.length), false, sender, false);
            }
            catch (Exception e) {
                if (!this.log.getInternalLogWriter().fineEnabled()) break block3;
                this.log.getInternalLogWriter().fine("exception sending ping response to " + sender, e);
            }
        }
    }

    private void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) throws IOException {
        DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
        sock.send(p);
    }

    @Override
    public void start() throws Exception {
        this.timer = this.stack.timer;
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.enable_diagnostics) {
            this.diag_handler = new DiagnosticsHandler();
            this.diag_handler.start();
        }
        if (this.use_incoming_packet_handler) {
            this.incoming_packet_queue = new Queue();
            this.incoming_packet_handler = new IncomingPacketHandler();
            this.incoming_packet_handler.start();
        }
        if (this.loopback) {
            this.incoming_msg_queue = new Queue();
            this.incoming_msg_handler = new IncomingMessageHandler();
            this.incoming_msg_handler.start();
        }
        if (this.use_outgoing_packet_handler) {
            this.outgoing_queue = new BoundedLinkedQueue(this.outgoing_queue_max_size);
            this.outgoing_packet_handler = new OutgoingPacketHandler();
            this.outgoing_packet_handler.start();
        }
        if (this.enable_bundling) {
            this.bundler = new Bundler();
        }
        this.passUp(new Event(8, this.local_addr));
    }

    @Override
    public void stop() {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
            this.diag_handler = null;
        }
        if (this.outgoing_packet_handler != null) {
            this.outgoing_packet_handler.stop();
        }
        if (this.incoming_packet_handler != null) {
            this.incoming_packet_handler.stop();
        }
        if (this.incoming_msg_handler != null) {
            this.incoming_msg_handler.stop();
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        String tmp = null;
        super.setProperties(props);
        try {
            tmp = System.getProperty("bind.address");
            if (Util.isBindAddressPropertyIgnored()) {
                tmp = null;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String str = tmp != null ? tmp : props.getProperty("bind_addr");
        if (str != null) {
            try {
                this.bind_addr = InetAddress.getByName(str);
            }
            catch (UnknownHostException unknown) {
                if (this.log.isFatalEnabled()) {
                    this.log.fatal("(bind_addr): host " + str + " not known");
                }
                return false;
            }
            props.remove("bind_addr");
        }
        if ((str = props.getProperty("use_local_host")) != null) {
            props.remove("use_local_host");
        }
        if ((str = props.getProperty("bind_to_all_interfaces")) != null) {
            this.receive_on_all_interfaces = Boolean.valueOf(str);
            props.remove("bind_to_all_interfaces");
            this.log.warn("bind_to_all_interfaces has been deprecated; use receive_on_all_interfaces instead");
        }
        if ((str = props.getProperty("receive_on_all_interfaces")) != null) {
            this.receive_on_all_interfaces = Boolean.valueOf(str);
            props.remove("receive_on_all_interfaces");
        }
        if ((str = props.getProperty("receive_interfaces")) != null) {
            try {
                this.receive_interfaces = this.parseInterfaceList(str);
                props.remove("receive_interfaces");
            }
            catch (Exception e) {
                this.log.error(JGroupsStrings.TP_ERROR_DETERMINING_INTERFACES__0_, str, (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("send_on_all_interfaces")) != null) {
            this.send_on_all_interfaces = Boolean.valueOf(str);
            props.remove("send_on_all_interfaces");
        }
        if ((str = props.getProperty("send_interfaces")) != null) {
            try {
                this.send_interfaces = this.parseInterfaceList(str);
                props.remove("send_interfaces");
            }
            catch (Exception e) {
                this.log.error(JGroupsStrings.TP_ERROR_DETERMINING_INTERFACES__0_, str, (Throwable)e);
                return false;
            }
        }
        if ((str = props.getProperty("bind_port")) != null) {
            this.bind_port = Integer.parseInt(str);
            props.remove("bind_port");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("loopback")) != null) {
            this.loopback = Boolean.valueOf(str);
            props.remove("loopback");
        }
        if ((str = props.getProperty("discard_incompatible_packets")) != null) {
            this.discard_incompatible_packets = Boolean.valueOf(str);
            props.remove("discard_incompatible_packets");
        }
        if ((str = props.getProperty("use_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_packet_handler");
            if (this.warn) {
                this.log.warn("'use_packet_handler' is deprecated; use 'use_incoming_packet_handler' instead");
            }
        }
        if ((str = props.getProperty("use_incoming_packet_handler")) != null) {
            this.use_incoming_packet_handler = Boolean.valueOf(str);
            props.remove("use_incoming_packet_handler");
        }
        if ((str = props.getProperty("use_outgoing_packet_handler")) != null) {
            this.use_outgoing_packet_handler = Boolean.valueOf(str);
            props.remove("use_outgoing_packet_handler");
        }
        if ((str = props.getProperty("outgoing_queue_max_size")) != null) {
            this.outgoing_queue_max_size = Integer.parseInt(str);
            props.remove("outgoing_queue_max_size");
            if (this.outgoing_queue_max_size <= 0) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("outgoing_queue_max_size of " + this.outgoing_queue_max_size + " is invalid, setting it to 1");
                }
                this.outgoing_queue_max_size = 1;
            }
        }
        if ((str = props.getProperty("max_bundle_size")) != null) {
            int bundle_size = Integer.parseInt(str);
            if (bundle_size > this.max_bundle_size && this.log.isWarnEnabled()) {
                this.log.warn("auto sensed max datagram size (" + bundle_size + ") is greater than udp_fragment_size setting plus overhead (" + this.max_bundle_size + ')');
            }
            if (bundle_size <= 0) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.TP_MAX_BUNDLE_SIZE__0__IS__0, bundle_size);
                }
                return false;
            }
            this.max_bundle_size = bundle_size;
            props.remove("max_bundle_size");
        }
        if ((str = props.getProperty("max_bundle_timeout")) != null) {
            this.max_bundle_timeout = Long.parseLong(str);
            if (this.max_bundle_timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error(JGroupsStrings.TP_MAX_BUNDLE_TIMEOUT_OF__0__IS_INVALID, this.max_bundle_timeout);
                }
                return false;
            }
            props.remove("max_bundle_timeout");
        }
        if ((str = props.getProperty("enable_bundling")) != null) {
            this.enable_bundling = Boolean.valueOf(str);
            props.remove("enable_bundling");
        }
        if ((str = props.getProperty("use_addr_translation")) != null) {
            props.remove("use_addr_translation");
        }
        if ((str = props.getProperty("enable_diagnostics")) != null) {
            this.enable_diagnostics = Boolean.valueOf(str);
            props.remove("enable_diagnostics");
        }
        if ((str = props.getProperty("diagnostics_addr")) != null) {
            this.diagnostics_addr = str;
            props.remove("diagnostics_addr");
        }
        if ((str = props.getProperty("diagnostics_port")) != null) {
            this.diagnostics_port = Integer.parseInt(str);
            props.remove("diagnostics_port");
        }
        if (this.enable_bundling) {
            // empty if block
        }
        return true;
    }

    @Override
    public void startUpHandler() {
    }

    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
        }
        this.passUp(evt);
    }

    @Override
    public void down(Event evt) {
        block22: {
            Address dest;
            boolean multicast;
            if (evt.getType() != 1) {
                this.handleDownEvent(evt);
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Message msg = (Message)evt.getArg();
            if (this.header != null) {
                msg.putHeader(this.name, this.header);
            }
            if (this.observer != null) {
                this.observer.passDown(evt);
            }
            this.setSourceAddress(msg);
            if (msg.bundleable && msg.isHighPriority) {
                msg.bundleable = false;
            }
            if (VERBOSE || GemFireTracer.DEBUG) {
                StringBuffer sb = new StringBuffer("sending msg ");
                sb.append(msg.toString());
                if (!msg.isHighPriority && this.enable_bundling && msg.bundleable) {
                    sb.append(" bundled");
                }
                this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, sb);
            }
            boolean bl = multicast = (dest = msg.getDest()) == null || dest.isMulticastAddress();
            if (this.loopback && (multicast || dest.equals(this.local_addr))) {
                Message copy = msg.copy(true);
                copy.setSrc(this.local_addr);
                if (trace) {
                    this.log.trace("looping back message");
                }
                try {
                    this.incoming_msg_queue.add(copy);
                    if (this.stack.gemfireStats != null) {
                        this.stack.gemfireStats.setJgQueuedMessagesSize(this.incoming_msg_queue.size());
                    }
                }
                catch (QueueClosedException e) {
                    // empty catch block
                }
                if (!multicast) {
                    return;
                }
            }
            try {
                if (this.use_outgoing_packet_handler) {
                    this.outgoing_queue.put(msg);
                } else {
                    this.send(msg, dest, multicast);
                }
            }
            catch (QueueClosedException closed_ex) {
            }
            catch (InterruptedException interruptedEx) {
                Thread.currentThread().interrupt();
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (NAKACK.RetransmissionTooLargeException e) {
                throw e;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (e instanceof Exception && e.getCause() != null && "No buffer space available".equals(e.getCause().getMessage())) {
                    this.log.getInternalLogWriter().warning(JGroupsStrings.TP_OUT_OF_SOCKET_BUFFER_SPACE_INCREASE_0, multicast ? " DistributionConfig.MCAST_SEND_BUFFER_SIZE_NAME" : "udp-send-buffer-size");
                }
                if (Thread.currentThread().isInterrupted() || !VERBOSE && !GemFireTracer.DEBUG) break block22;
                this.log.getInternalLogWriter().fine("failed sending message", e);
            }
        }
    }

    private void setSourceAddress(Message msg) {
        if (msg.getSrc() == null) {
            msg.setSrc(this.local_addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testMulticast(long timeout) {
        byte[] buffer = new byte[]{112, 105, 110, 103};
        this.pongReceived = false;
        try {
            this.sendToAllMembers(buffer, 0, 4);
        }
        catch (Exception e) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("exception sending ping request", e);
            }
            return false;
        }
        long waitEnd = System.currentTimeMillis() + timeout;
        long remainingMs = timeout;
        Object object = this.pongSync;
        synchronized (object) {
            try {
                while (!this.pongReceived && remainingMs > 0L) {
                    this.pongSync.wait(remainingMs);
                    remainingMs = waitEnd - System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return this.pongReceived;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void receive(Address dest, Address sender, byte[] data, int offset, int length) {
        block14: {
            boolean mcast;
            if (data == null) {
                return;
            }
            long start = 0L;
            if (this.stack != null && this.stack.enableClockStats) {
                start = this.nanoTime();
            }
            boolean bl = mcast = dest == null || dest.isMulticastAddress();
            if (length == 4) {
                if (data[offset] == 112 && data[offset + 1] == 105 && data[offset + 2] == 110 && data[offset + 3] == 103) {
                    this.sendPingResponse(sender);
                    return;
                }
                if (data[offset] == 112 && data[offset + 1] == 111 && data[offset + 2] == 110 && data[offset + 3] == 103) {
                    Object object = this.pongSync;
                    synchronized (object) {
                        this.pongReceived = true;
                        this.pongSync.notifyAll();
                    }
                    if (this.stack.jgmm.getQuorumCheckerImpl() != null) {
                        this.stack.jgmm.getQuorumCheckerImpl().pongReceived(((IpAddress)sender).getSocketAddress());
                    }
                    return;
                }
            }
            try {
                if (this.use_incoming_packet_handler) {
                    byte[] tmp = new byte[length];
                    System.arraycopy(data, offset, tmp, 0, length);
                    this.incoming_packet_queue.add(new IncomingQueueEntry(dest, sender, tmp, offset, length, start));
                } else {
                    this.handleIncomingPacket(dest, sender, data, offset, length, start);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (!this.log.isErrorEnabled()) break block14;
                this.log.error(JGroupsStrings.TP_FAILED_HANDLING_DATA_FROM_0, sender, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleIncomingPacket(Address dest, Address sender, byte[] data, int offset, int length, long startTime) {
        Message msg = null;
        com.gemstone.org.jgroups.util.List l = null;
        try {
            boolean multicast;
            boolean is_message_list;
            ExposedByteArrayInputStream exposedByteArrayInputStream = this.in_stream;
            synchronized (exposedByteArrayInputStream) {
                byte flags;
                this.in_stream.setData(data, offset, length);
                this.buf_in_stream.reset(length);
                short version = this.dis.readShort();
                if (!JGroupsVersion.compareTo(version)) {
                    if (this.warn) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("packet from ").append(sender).append(" has different version (").append(version);
                        sb.append(") from ours (").append(JGroupsVersion.printVersion()).append("). ");
                        if (this.discard_incompatible_packets) {
                            sb.append("Packet is discarded");
                        } else {
                            sb.append("This may cause problems");
                        }
                        this.log.warn(sb);
                    }
                    if (this.discard_incompatible_packets) {
                        return;
                    }
                }
                is_message_list = ((flags = this.dis.readByte()) & 1) == 1;
                boolean bl = multicast = (flags & 2) == 2;
                if (is_message_list) {
                    l = this.bufferToList(this.dis, dest, sender, multicast);
                    if (l == null) {
                        return;
                    }
                } else {
                    msg = this.bufferToMessage(this.dis, dest, sender, multicast);
                    if (msg == null) {
                        return;
                    }
                    msg.timeStamp = startTime;
                }
            }
            LinkedList<Message> msgs = new LinkedList<Message>();
            if (is_message_list) {
                Enumeration en = l.elements();
                while (en.hasMoreElements()) {
                    Message m = (Message)en.nextElement();
                    if (this.stack.enableClockStats) {
                        m.timeStamp = this.nanoTime();
                    }
                    msgs.add(m);
                }
            } else {
                msgs.add(msg);
            }
            Iterator it = msgs.iterator();
            while (it.hasNext()) {
                msg = (Message)it.next();
                Address src = msg.getSrc();
                if (this.loopback && multicast && src != null && this.local_addr.equals(src)) {
                    if (trace) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "discarding my own multicast message " + msg);
                    }
                    it.remove();
                    continue;
                }
                this.handleIncomingMessage(msg);
                it.remove();
            }
        }
        catch (QueueClosedException closed_ex) {
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            this.log.getInternalLogWriter().info(JGroupsStrings.TP_FAILED_UNMARSHALLING_MESSAGE_FROM__0, new Object[]{sender}, t);
        }
    }

    protected void handleIncomingMessage(Message msg) {
        TpHeader hdr;
        if (this.stats) {
            ++this.num_msgs_received;
            this.num_bytes_received += (long)msg.getLength();
        }
        Event evt = new Event(1, msg);
        if (VERBOSE || GemFireTracer.DEBUG) {
            StringBuffer sb = new StringBuffer("received message ").append(msg);
            this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, sb);
        }
        if (this.observer != null) {
            this.observer.up(evt, this.up_queue.size());
        }
        if ((hdr = (TpHeader)msg.getHeader(this.name)) != null) {
            String ch_name = hdr.channel_name;
            if (ch_name != null && this.channel_name != null && !this.channel_name.equals(ch_name)) {
                if (this.warn) {
                    this.log.warn(new StringBuilder("discarded message from different group \"").append(ch_name).append("\" (our group is \"").append(this.channel_name).append("\"). Sender was ").append(msg.getSrc()));
                }
                return;
            }
        } else {
            if (trace) {
                this.log.trace(new StringBuffer("message does not have a transport header, msg is ").append(msg).append(", headers are ").append(msg.getHeaders()).append(", will be discarded"));
            }
            return;
        }
        msg.removeHeader(this.name);
        long sTime = 0L;
        if (this.stack.enableJgStackStats) {
            sTime = this.nanoTime();
        }
        this.passUp(evt);
        if (this.stack.enableJgStackStats) {
            this.stack.gemfireStats.incjgUpTime(this.nanoTime() - sTime);
        }
    }

    protected void send(Message msg, Address dest, boolean multicast) throws Exception {
        if (this.enable_bundling && msg.bundleable && multicast) {
            this.bundler.send(msg, dest);
            return;
        }
        Buffer buf = this.messageToBuffer(msg, multicast);
        if (buf.getLength() > 60000 && NAKACK.isRetransmission(msg)) {
            throw new NAKACK.RetransmissionTooLargeException("serialized size is " + buf.getLength());
        }
        this.doSend(buf, msg.isJoinResponse, dest, multicast);
    }

    protected void doSend(Buffer buf, boolean isJoinResponse, Address dest, boolean multicast) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.sendToAllMembers(buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.sendToSingleMember(dest, isJoinResponse, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    private Buffer messageToBuffer(Message msg, boolean multicast) throws Exception {
        int flags = 0;
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream((int)msg.size());
        ExposedBufferedOutputStream buf_out_stream = new ExposedBufferedOutputStream(out_stream, (int)msg.size());
        DataOutputStream dos = new DataOutputStream(buf_out_stream);
        dos.writeShort(22920);
        short msgVersion = 0;
        if (multicast) {
            flags = (byte)(flags + 2);
            msgVersion = this.getMulticastVersion();
        }
        dos.writeByte(flags);
        if (multicast) {
            Version.writeOrdinal(dos, msgVersion, true);
        }
        msg.setVersion(msgVersion);
        msg.writeTo(dos);
        dos.flush();
        Buffer retval = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        return retval;
    }

    protected Message bufferToMessage(DataInputStream instream, Address dest, Address sender, boolean multicast) throws Exception {
        short mcastVersion = Version.CURRENT_ORDINAL;
        if (multicast) {
            short mcastOrdinal = Version.readOrdinal(instream);
            if (mcastOrdinal > Version.CURRENT_ORDINAL) {
                this.log.getInternalLogWriter().info(JGroupsStrings.IGNORING_MULTICAST_MESSAGE_WITH_HIGHER_VERSION_FROM_0_1_2, new Object[]{sender, mcastOrdinal, Version.CURRENT_ORDINAL});
                return null;
            }
            mcastVersion = mcastOrdinal;
        }
        Message msg = new Message(false);
        msg.setVersion(mcastVersion);
        msg.readFrom(instream);
        this.postUnmarshalling(msg, dest, sender, multicast);
        return msg;
    }

    protected Buffer listToBuffer(com.gemstone.org.jgroups.util.List l, boolean multicast) throws Exception {
        int flags = 0;
        int len = l != null ? l.size() : 0;
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(65535);
        ExposedBufferedOutputStream buf_out_stream = new ExposedBufferedOutputStream(out_stream, 65535);
        DataOutputStream dos = new DataOutputStream(buf_out_stream);
        dos.writeShort(22920);
        flags = (byte)(flags + 1);
        short mcastVersion = 0;
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        if (multicast) {
            mcastVersion = this.getMulticastVersion();
            Version.writeOrdinal(dos, mcastVersion, true);
            try {
                dos = new VersionedDataOutputStream(dos, Version.fromOrdinal(mcastVersion, false));
            }
            catch (UnsupportedVersionException e) {
                throw new IOException("Unexpected exception during serialization", e);
            }
        }
        dos.writeInt(len);
        boolean writeaddrs = true;
        if (this.local_addr != null) {
            writeaddrs = false;
            dos.writeBoolean(false);
            Util.writeAddress(this.local_addr, dos);
        } else {
            dos.writeBoolean(true);
        }
        if (l != null) {
            Enumeration en = l.elements();
            while (en.hasMoreElements()) {
                Message msg = (Message)en.nextElement();
                boolean resurrect = false;
                if (!writeaddrs && msg.getSrc().equals(this.local_addr)) {
                    msg.setSrc(null);
                    resurrect = true;
                }
                if (multicast) {
                    msg.setVersion(mcastVersion);
                }
                msg.writeTo(dos);
                if (!resurrect) continue;
                msg.setSrc(this.local_addr);
            }
        }
        dos.flush();
        Buffer retval = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineMulticastVersion() {
        short currOrdinal;
        short result = currOrdinal = Version.CURRENT_ORDINAL;
        Vector vector = this.members;
        synchronized (vector) {
            Iterator it = this.members.iterator();
            while (it.hasNext()) {
                short ver = ((Address)it.next()).getVersionOrdinal();
                if (ver >= currOrdinal) continue;
                if (result == 0) {
                    result = ver;
                    continue;
                }
                if (ver >= result) continue;
                result = ver;
            }
        }
        this.multicastVersion = result;
        Message.multicastVersion = result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getMulticastVersion() {
        Vector vector = this.members;
        synchronized (vector) {
            if (this.multicastVersion <= 0) {
                return Version.CURRENT_ORDINAL;
            }
            return this.multicastVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.gemstone.org.jgroups.util.List bufferToList(DataInputStream instream, Address dest, Address source, boolean multicast) throws Exception {
        com.gemstone.org.jgroups.util.List l = new com.gemstone.org.jgroups.util.List();
        InputStream in = null;
        Address src = null;
        try {
            boolean readaddr;
            Object mcastVersion;
            if (multicast) {
                short mcastOrdinal = Version.readOrdinal(instream);
                if (mcastOrdinal > Version.CURRENT_ORDINAL) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.IGNORING_MULTICAST_MESSAGE_WITH_HIGHER_VERSION_FROM_0_1_2, new Object[]{source, mcastOrdinal, Version.CURRENT_ORDINAL});
                    com.gemstone.org.jgroups.util.List list = null;
                    return list;
                }
                if (mcastOrdinal < Version.CURRENT_ORDINAL) {
                    mcastVersion = Version.fromOrdinal(mcastOrdinal, false);
                    instream = new VersionedDataInputStream(instream, (Version)mcastVersion);
                }
            }
            int len = instream.readInt();
            boolean bl = readaddr = !instream.readBoolean();
            if (readaddr) {
                src = Util.readAddress(instream);
                mcastVersion = this.members;
                synchronized (mcastVersion) {
                    int idx = this.members.indexOf(src);
                    if (idx >= 0) {
                        src = (Address)this.members.get(idx);
                    }
                }
            }
            for (int i = 0; i < len; ++i) {
                Message msg = new Message(false);
                msg.readFrom(instream);
                if (readaddr && msg.getSrc() == null) {
                    msg.setSrc(src);
                }
                this.postUnmarshallingList(msg, dest, multicast);
                l.add(msg);
            }
            com.gemstone.org.jgroups.util.List list = l;
            return list;
        }
        finally {
            Util.closeInputStream(in);
        }
    }

    private List parseInterfaceList(String s) throws Exception {
        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>(10);
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            String interface_name = tok.nextToken();
            NetworkInterface intf = NetworkInterface.getByName(interface_name);
            if (intf == null) {
                intf = NetworkInterface.getByInetAddress(InetAddress.getByName(interface_name));
            }
            if (intf == null) {
                throw new Exception("interface " + interface_name + " not found");
            }
            if (interfaces.contains(intf)) {
                this.log.warn("did not add interface " + interface_name + " (already present in " + this.print(interfaces) + ")");
                continue;
            }
            interfaces.add(intf);
        }
        return interfaces;
    }

    private String print(List interfaces) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (NetworkInterface intf : interfaces) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(intf.getName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Vector vector = this.members;
                synchronized (vector) {
                    this.view = (View)evt.getArg();
                    this.members.clear();
                    Vector tmpvec = this.view.getMembers();
                    this.members.addAll(tmpvec);
                    this.determineMulticastVersion();
                    break;
                }
            }
            case 7: {
                this.passUp(new Event(8, this.local_addr));
                break;
            }
            case 2: {
                this.channel_name = (String)evt.getArg();
                this.header = new TpHeader(this.channel_name);
                this.passUp(new Event(3));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.passUp(new Event(5));
                break;
            }
            case 56: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("received CONFIG event: " + evt.getArg());
                }
                this.handleConfigEvent((HashMap)evt.getArg());
            }
        }
    }

    protected void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("additional_data")) {
            this.additional_data = (byte[])map.get("additional_data");
        }
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }

    private class DiagnosticsHandler
    implements Runnable {
        volatile Thread t = null;
        volatile MulticastSocket diag_sock = null;

        DiagnosticsHandler() {
        }

        synchronized void start() throws IOException {
            this.diag_sock = new MulticastSocket(TP.this.diagnostics_port);
            List interfaces = Util.getAllAvailableInterfaces();
            this.bindToInterfaces(interfaces, this.diag_sock);
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "DiagnosticsHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        synchronized void stop() {
            if (this.diag_sock != null) {
                this.diag_sock.close();
            }
            if (this.t != null) {
                this.t.interrupt();
            }
            this.t = null;
        }

        @Override
        public void run() {
            byte[] buf = new byte[1500];
            while (true) {
                SystemFailure.checkFailure();
                if (this.diag_sock.isClosed() || Thread.currentThread().isInterrupted()) break;
                DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
                try {
                    this.diag_sock.receive(packet);
                    TP.this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset(), packet.getLength()));
                }
                catch (IOException iOException) {}
            }
        }

        private void bindToInterfaces(List interfaces, MulticastSocket s) throws IOException {
            InetSocketAddress group_addr = new InetSocketAddress(TP.this.diagnostics_addr, TP.this.diagnostics_port);
            for (NetworkInterface i : interfaces) {
                try {
                    s.joinGroup(group_addr, i);
                    if (!Protocol.trace) continue;
                    TP.this.log.trace("joined " + group_addr + " on " + i.getName());
                }
                catch (IOException e) {
                    TP.this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
                }
            }
        }
    }

    protected class Bundler {
        final HashMap msgs = new HashMap(36);
        long count = 0L;
        int num_msgs = 0;
        long start = 0L;
        BundlingTimer bundling_timer = null;

        protected Bundler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void send(Message msg, Address dest) throws Exception {
            long gsstart = 0L;
            if (TP.this.stack.enableClockStats) {
                gsstart = TP.this.nanoTime();
            }
            try {
                long length = msg.size();
                if (this.checkLength(length)) {
                    TP.this.log.getInternalLogWriter().warning(JGroupsStrings.TP_SENDING_OVERSIZED_MESSAGE__0__HEADERS__1, new Object[]{msg.toString(), msg.printObjectHeaders()});
                    TP.this.log.getInternalLogWriter().warning(JGroupsStrings.TP_PAYLOAD___0, msg.toStringAsObject());
                }
                if (this.count + length >= (long)TP.this.max_bundle_size) {
                    this.cancelTimer();
                    this.bundleAndSend();
                }
                this.addMessage(msg, dest);
                this.count += length;
                this.startTimer();
            }
            finally {
                if (TP.this.stack.enableClockStats) {
                    if (TP.this.log.isDebugEnabled()) {
                        TP.this.log.debug("bundled " + msg.toString() + " headers: " + msg.printObjectHeaders());
                    }
                    if (TP.this.stack.enableClockStats) {
                        TP.this.stack.gemfireStats.incBatchSendTime(gsstart);
                    }
                }
            }
        }

        private void startTimer() {
            if (this.bundling_timer == null || this.bundling_timer.cancelled()) {
                this.bundling_timer = new BundlingTimer();
                TP.this.timer.add(this.bundling_timer);
            }
        }

        private void cancelTimer() {
            if (this.bundling_timer != null) {
                this.bundling_timer.cancel();
                this.bundling_timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMessage(Message msg, Address dest) {
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                com.gemstone.org.jgroups.util.List tmp = (com.gemstone.org.jgroups.util.List)this.msgs.get(dest);
                if (tmp == null) {
                    tmp = new com.gemstone.org.jgroups.util.List();
                    this.msgs.put(dest, tmp);
                }
                tmp.add(msg);
                ++this.num_msgs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleAndSend() {
            HashMap hashMap = this.msgs;
            synchronized (hashMap) {
                if (this.msgs.size() == 0) {
                    return;
                }
                try {
                    if (Protocol.trace) {
                        long stop = System.currentTimeMillis();
                        double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                        StringBuffer sb = new StringBuffer("sending ").append(this.num_msgs).append(" msgs (");
                        sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size), collected in " + (stop - this.start) + "ms) to ").append(this.msgs.size()).append(" destination(s)");
                        if (this.msgs.size() > 1) {
                            sb.append(" (dests=").append(this.msgs.keySet()).append(")");
                        }
                        TP.this.log.trace(sb.toString());
                    }
                    for (Map.Entry entry : this.msgs.entrySet()) {
                        com.gemstone.org.jgroups.util.List l = (com.gemstone.org.jgroups.util.List)entry.getValue();
                        if (l.size() == 0) continue;
                        Address dst = (Address)entry.getKey();
                        boolean multicast = dst == null || dst.isMulticastAddress();
                        try {
                            if (TP.this.stack.enableClockStats) {
                                this.start = TP.this.nanoTime();
                            }
                            Buffer buffer = TP.this.listToBuffer(l, multicast);
                            if (TP.this.stack.enableClockStats) {
                                TP.this.stack.gemfireStats.incBatchCopyTime(this.start);
                                this.start = TP.this.nanoTime();
                            }
                            TP.this.doSend(buffer, false, dst, multicast);
                            if (!TP.this.stack.enableClockStats) continue;
                            TP.this.stack.gemfireStats.incBatchFlushTime(this.start);
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable e) {
                            SystemFailure.checkFailure();
                            if (e instanceof Exception && e.getCause() != null && "No buffer space available".equals(e.getCause().getMessage())) {
                                TP.this.log.getInternalLogWriter().warning(JGroupsStrings.TP_OUT_OF_SOCKET_BUFFER_SPACE_INCREASE_0, multicast ? "mcast-send-buffer-size" : "udp-send-buffer-size");
                                continue;
                            }
                            if (!TP.this.log.isErrorEnabled()) continue;
                            TP.this.log.error(JGroupsStrings.TP_EXCEPTION_SENDING_MSG, e);
                        }
                    }
                }
                finally {
                    this.msgs.clear();
                    this.num_msgs = 0;
                    this.start = 0L;
                    this.count = 0L;
                }
            }
        }

        private boolean checkLength(long len) throws Exception {
            return len > (long)TP.this.max_bundle_size;
        }

        protected class BundlingTimer
        implements TimeScheduler.Task {
            boolean cancelled = false;

            protected BundlingTimer() {
            }

            void cancel() {
                this.cancelled = true;
            }

            @Override
            public boolean cancelled() {
                return this.cancelled;
            }

            @Override
            public long nextInterval() {
                return TP.this.max_bundle_timeout;
            }

            @Override
            public void run() {
                Bundler.this.bundleAndSend();
                this.cancelled = true;
            }
        }
    }

    class OutgoingPacketHandler
    implements Runnable {
        Thread t = null;

        OutgoingPacketHandler() {
        }

        synchronized void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "OutgoingPacketHandler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        synchronized void stop() {
            Thread tmp = this.t;
            this.t = null;
            if (tmp != null) {
                tmp.interrupt();
            }
        }

        @Override
        public void run() {
            boolean multicast = false;
            while (true) {
                Message msg;
                block8: {
                    SystemFailure.checkFailure();
                    if (Thread.currentThread().isInterrupted()) break;
                    try {
                        msg = (Message)TP.this.outgoing_queue.take();
                        multicast = msg.getDest() == null || msg.getDest().isMulticastAddress();
                        this.handleMessage(msg);
                    }
                    catch (QueueClosedException closed_ex) {
                        break;
                    }
                    catch (InterruptedException interruptedEx) {
                        break;
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable th) {
                        SystemFailure.checkFailure();
                        if (th instanceof Exception && th.getCause() != null && "No buffer space available".equals(th.getCause().getMessage())) {
                            TP.this.log.getInternalLogWriter().warning(JGroupsStrings.TP_OUT_OF_SOCKET_BUFFER_SPACE_INCREASE_0, multicast ? " DistributionConfig.MCAST_SEND_BUFFER_SIZE_NAME" : "udp-send-buffer-size");
                        }
                        if (!TP.this.log.isErrorEnabled()) break block8;
                        TP.this.log.error(JGroupsStrings.TP_EXCEPTION_SENDING_PACKET, th);
                    }
                }
                msg = null;
            }
            if (Protocol.trace) {
                TP.this.log.trace("outgoing message handler terminating");
            }
        }

        protected void handleMessage(Message msg) throws Throwable {
            Address dest;
            TP.this.send(msg, dest, (dest = msg.getDest()) == null || dest.isMulticastAddress());
        }
    }

    class IncomingMessageHandler
    implements Runnable {
        Thread t;

        IncomingMessageHandler() {
        }

        public synchronized void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "UDP Incoming Message Handler");
                this.t.setDaemon(true);
                this.t.setPriority(10);
                this.t.start();
            }
        }

        public synchronized void stop() {
            TP.this.incoming_msg_queue.close(false);
            if (this.t != null) {
                this.t.interrupt();
            }
            this.t = null;
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (TP.this.incoming_msg_queue.closed() || Thread.currentThread().isInterrupted()) break;
                try {
                    Message msg = (Message)TP.this.incoming_msg_queue.remove();
                    TP.this.handleIncomingMessage(msg);
                    continue;
                }
                catch (InterruptedException ie) {
                }
                catch (QueueClosedException closed_ex) {
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error(JGroupsStrings.TP_ERROR_PROCESSING_INCOMING_MESSAGE, ex);
                    continue;
                }
                break;
            }
            if (Protocol.trace) {
                TP.this.log.trace("incoming message handler terminating");
            }
        }
    }

    class IncomingPacketHandler
    implements Runnable {
        Thread t = null;

        IncomingPacketHandler() {
        }

        synchronized void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread((Runnable)this, "UDP Incoming Packet Handler");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        synchronized void stop() {
            TP.this.incoming_packet_queue.close(true);
            if (this.t != null) {
                this.t.interrupt();
            }
            this.t = null;
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (TP.this.incoming_packet_queue.closed() || Thread.currentThread().isInterrupted()) break;
                try {
                    IncomingQueueEntry entry = (IncomingQueueEntry)TP.this.incoming_packet_queue.remove();
                    TP.this.handleIncomingPacket(entry.dest, entry.sender, entry.buf, entry.offset, entry.length, entry.timeStamp);
                    continue;
                }
                catch (InterruptedException ie) {
                    if (!TP.this.log.isTraceEnabled()) break;
                    TP.this.log.trace("packet handler thread terminating (interrupted)");
                }
                catch (QueueClosedException closed_ex) {
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    if (!TP.this.log.isErrorEnabled()) continue;
                    TP.this.log.error(JGroupsStrings.TP_ERROR_PROCESSING_INCOMING_PACKET, ex);
                    continue;
                }
                break;
            }
            if (Protocol.trace) {
                TP.this.log.trace("incoming packet handler terminating");
            }
        }
    }

    static class IncomingQueueEntry {
        Address dest = null;
        Address sender = null;
        byte[] buf;
        int offset;
        int length;
        long timeStamp;

        IncomingQueueEntry(Address dest, Address sender, byte[] buf, int offset, int length, long timeStamp) {
            this.dest = dest;
            this.sender = sender;
            this.buf = buf;
            this.offset = offset;
            this.length = length;
            this.timeStamp = timeStamp;
        }
    }
}

