/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.protocols.TOTAL_OLD;
import com.gemstone.org.jgroups.util.GemFireTracer;

class TotalRetransmissionThread
extends Thread {
    private long last_retrans_request_time;
    private long last_requested_seq;
    private static final long polling_delay = 1000L;
    private static final long resend_timeout = 2000L;
    private static final int max_request = 10;
    private TOTAL_OLD prot_ptr;
    private boolean is_running;
    final GemFireTracer log = GemFireTracer.getLog(TotalRetransmissionThread.class);

    TotalRetransmissionThread(TOTAL_OLD parent_prot) {
        if (parent_prot != null) {
            this.prot_ptr = parent_prot;
        } else {
            this.log.error(JGroupsStrings.TOTAL_OLD_ERROR_TOTALRETRANSMISSIONTHREADTOTALRETRANSMISSIONTHREAD__GIVEN_PARENT_PROTOCOL_REFERENCE_IS_NULLN__FATAL_ERROR__TOTAL_OLD_PROTOCOL_WILL_NOT_FUNCTION_PROPERLY);
            this.is_running = false;
        }
        this.reset();
        this.is_running = true;
    }

    public void reset() {
        this.last_retrans_request_time = -1L;
        this.last_requested_seq = -1L;
    }

    private void sendResendRequest(Address sequencer, Address local_addr, long seq_id) {
        Message resend_msg = new Message(sequencer, local_addr, null);
        resend_msg.putHeader(this.getName(), new TOTAL_OLD.TotalHeader(7, seq_id));
        this.prot_ptr.passDown(new Event(1, resend_msg));
        this.log.error(JGroupsStrings.TOTAL_OLD_TOTALRETRANSMISSIONTHREADRESEND__RESEND_REQUESTED_FOR_MESSAGE__0, seq_id);
    }

    private void checkForResend() {
        long next_seq_id;
        long first_seq_id = this.prot_ptr.getFirstQueuedSeqID();
        if (first_seq_id >= 0L && (next_seq_id = this.prot_ptr.getNextSeqID()) < first_seq_id) {
            long time_now = System.currentTimeMillis();
            if (next_seq_id > this.last_requested_seq || time_now > this.last_retrans_request_time + 2000L || this.last_retrans_request_time < 0L) {
                long temp_long;
                Address sequencer = this.prot_ptr.getSequencer();
                if (sequencer == null) {
                    System.out.println("Error: (TOTAL_OLD) TotalRetransmissionThread.checkForResend() - could not determine sequencer to send a TOTAL_RESEND request");
                    return;
                }
                Address local_addr = this.prot_ptr.getLocalAddr();
                if (local_addr == null) {
                    System.out.println("Warning: (TOTAL_OLD) TotalRetransmissionThread.checkForResend() - local address not specified in TOTAL_RESEND request... attempting to send requests anyway");
                }
                long last_resend_seq_id = (temp_long = next_seq_id + 10L) > first_seq_id ? first_seq_id : temp_long;
                for (long resend_seq = next_seq_id; resend_seq < last_resend_seq_id; ++resend_seq) {
                    this.sendResendRequest(sequencer, local_addr, resend_seq);
                }
                this.last_retrans_request_time = time_now;
                this.last_requested_seq = last_resend_seq_id;
            }
        }
    }

    @Override
    public void run() {
        while (this.is_running) {
            SystemFailure.checkFailure();
            this.checkForResend();
            try {
                TotalRetransmissionThread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void stopResendRequests() {
        this.is_running = false;
    }
}

