/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.protocols;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Header;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Streamable;
import com.gemstone.org.jgroups.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    private static int MIN_SLEEP_TIME = 500;
    private Address local_addr = null;
    protected long timeout = 2000L;
    private int num_msgs = 1;
    final Hashtable suspects = new Hashtable();
    boolean suspectsAdded;
    private Thread timer = null;
    static final String name = "VERIFY_SUSPECT";
    private boolean playingDead;
    private View view;
    private Object view_lock = new Object();
    private boolean disconnecting;
    static final long SUSPECT_FAST_TIMEOUT = Integer.getInteger("gemfire.fast-member-timeout", 1000).intValue();

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_msgs")) != null) {
            this.num_msgs = Integer.parseInt(str);
            if (this.num_msgs <= 0) {
                if (this.warn) {
                    this.log.warn("num_msgs is invalid (" + this.num_msgs + "): setting it to 1");
                }
                this.num_msgs = 1;
            }
            props.remove("num_msgs");
        }
        if (props.size() > 0) {
            this.log.error(JGroupsStrings.VERIFY_SUSPECT_VERIFY_SUSPECTSETPROPERTIES_THE_FOLLOWING_PROPERTIES_ARE_NOT_RECOGNIZED__0, props);
            return false;
        }
        this.disconnecting = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                Object object = this.view_lock;
                synchronized (object) {
                    this.view = (View)evt.getArg();
                    break;
                }
            }
            case 1007: {
                this.stop();
                this.disconnecting = true;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                long viewId = v.getVid().getId();
                HashSet<IpAddress> removals = new HashSet<IpAddress>();
                Hashtable hashtable = this.suspects;
                synchronized (hashtable) {
                    for (IpAddress mbr : this.suspects.keySet()) {
                        if (v.containsMember(mbr) || (long)mbr.getBirthViewId() >= viewId) continue;
                        removals.add(mbr);
                    }
                }
                for (IpAddress mbr : removals) {
                    this.unsuspect(mbr);
                }
                break;
            }
            case 9: {
                if (this.disconnecting) break;
                SuspectMember sm = (SuspectMember)evt.getArg();
                if (sm == null || sm.suspectedMember == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error(JGroupsStrings.VERIFY_SUSPECT_SUSPECTED_MEMBER_IS_NULL);
                    }
                    return;
                }
                this.suspect(sm);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Object obj = msg.getHeader(name);
                if (msg.getSrc() != null && ((IpAddress)msg.getSrc()).getBirthViewId() >= 0) {
                    this.unsuspect(msg.getSrc());
                }
                if (obj == null || !(obj instanceof VerifyHeader)) break;
                if (this.disconnecting) {
                    return;
                }
                VerifyHeader hdr = (VerifyHeader)msg.removeHeader(name);
                switch (hdr.type) {
                    case 1: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.VERIFY_SUSPECT_ARE_YOU_DEAD_HDRFROM_IS_NULL);
                            }
                        } else {
                            if (this.playingDead) {
                                return;
                            }
                            for (int i = 0; i < this.num_msgs; ++i) {
                                Message rsp = new Message(hdr.from, this.local_addr, null);
                                rsp.putHeader(name, new VerifyHeader(2, this.local_addr));
                                this.passDown(new Event(1, rsp));
                            }
                        }
                        return;
                    }
                    case 2: {
                        if (hdr.from == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error(JGroupsStrings.VERIFY_SUSPECT_I_AM_NOT_DEAD_HDRFROM_IS_NULL);
                            }
                            return;
                        }
                        this.unsuspect(hdr.from);
                        return;
                    }
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public void playDead(boolean flag) {
        this.playingDead = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            SystemFailure.checkFailure();
            if (Thread.currentThread().isInterrupted() || !this.stack.getChannel().isOpen()) break;
            long diff = 0L;
            if (this.suspects.size() <= 0) break;
            ArrayList<Message> msgs = new ArrayList<Message>();
            long sleepTime = this.timeout;
            HashSet<SuspectMember> passUps = new HashSet<SuspectMember>();
            Hashtable hashtable = this.suspects;
            synchronized (hashtable) {
                this.suspectsAdded = false;
                Enumeration e = this.suspects.keys();
                while (e.hasMoreElements()) {
                    SuspectMember sm = (SuspectMember)e.nextElement();
                    Address mbr = sm.suspectedMember;
                    long val = (Long)this.suspects.get(sm);
                    long curr_time = System.currentTimeMillis();
                    diff = curr_time - val;
                    if (diff >= this.timeout) {
                        this.log.getInternalLogWriter().info(JGroupsStrings.DEBUG, "" + this.local_addr + ": No suspect verification response received from " + mbr + " in " + diff + " milliseconds: I believe it is gone.");
                        passUps.add(sm);
                        this.suspects.remove(sm);
                        continue;
                    }
                    Message msg = new Message(mbr, this.local_addr, null);
                    msg.putHeader(name, new VerifyHeader(1, this.local_addr));
                    msgs.add(msg);
                    sleepTime = Math.min(sleepTime, this.timeout - diff);
                    diff = Math.max((long)MIN_SLEEP_TIME, sleepTime);
                }
            }
            for (SuspectMember sm : passUps) {
                this.passUp(new Event(9, sm));
            }
            Iterator it = msgs.iterator();
            while (it.hasNext()) {
                if (this.disconnecting) continue;
                this.passDown(new Event(1, it.next()));
            }
            if (sleepTime <= 0L) continue;
            hashtable = this.suspects;
            synchronized (hashtable) {
                if (!this.suspectsAdded) {
                    try {
                        this.suspects.wait(sleepTime);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspect(SuspectMember sm) {
        if (sm == null) {
            return;
        }
        Address mbr = sm.suspectedMember;
        if (mbr.equals(this.local_addr)) {
            return;
        }
        Object object = this.view_lock;
        synchronized (object) {
            if (this.view == null) {
                return;
            }
        }
        sm.suspectedMember = mbr = this.view.getMember(mbr);
        object = this.suspects;
        synchronized (object) {
            if (this.suspects.containsKey(sm)) {
                this.startTimer();
                return;
            }
            long suspectTime = System.currentTimeMillis();
            this.suspects.put(sm, suspectTime);
            this.suspectsAdded = true;
            this.suspects.notify();
        }
        if (trace) {
            this.log.trace("verifying that " + mbr + " is gone");
        }
        for (int i = 0; i < this.num_msgs; ++i) {
            Message msg = new Message(mbr, this.local_addr, null);
            msg.putHeader(name, new VerifyHeader(1, this.local_addr));
            this.passDown(new Event(1, msg));
        }
        this.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (((IpAddress)mbr).getBirthViewId() < 0) {
            if (this.log.getInternalLogWriter().fineEnabled()) {
                this.log.getInternalLogWriter().fine("Unsuspect() found view id missing from " + mbr + " which is abnormal if this member isn't in the process of joining");
            }
            return;
        }
        SuspectMember sm = new SuspectMember(this.local_addr, mbr);
        if (!this.suspects.containsKey(sm)) {
            return;
        }
        Hashtable hashtable = this.suspects;
        synchronized (hashtable) {
            if (this.suspects.containsKey(sm)) {
                if (this.view.getCreator().equals(this.local_addr)) {
                    this.log.getInternalLogWriter().info(JGroupsStrings.VERIFY_SUSPECT_MEMBER_0_IS_NO_LONGER_SUSPECT, mbr);
                }
                this.suspects.remove(sm);
                this.passDown(new Event(51, mbr));
                this.passUp(new Event(51, mbr));
            }
        }
    }

    synchronized void startTimer() {
        Thread tmp = this.timer;
        if (tmp == null || !tmp.isAlive()) {
            tmp = new Thread(GemFireTracer.GROUP, this, "VERIFY_SUSPECT.TimerThread");
            tmp.setDaemon(true);
            tmp.start();
            this.timer = tmp;
        }
    }

    @Override
    public synchronized void stop() {
        Thread tmp = this.timer;
        if (tmp != null && tmp.isAlive()) {
            tmp.interrupt();
        }
    }

    public static class VerifyHeader
    extends Header
    implements Streamable {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from = null;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.type);
            out.writeObject(this.from);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = (Address)in.readObject();
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }
    }
}

